/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.id;

import it.link.pdd.tools.migrazione_govway.utils.id.ClusterIdentifier;
import it.link.pdd.tools.migrazione_govway.utils.id.IUniqueIdentifier;
import it.link.pdd.tools.migrazione_govway.utils.id.IUniqueIdentifierGenerator;
import it.link.pdd.tools.migrazione_govway.utils.id.UniqueIdentifierException;
import java.net.InetAddress;

public class ClusterIdentifierGenerator
implements IUniqueIdentifierGenerator {
    private String clusterIDSuffix = null;

    @Override
    public void init(Object ... o) throws UniqueIdentifierException {
        this.clusterIDSuffix = (String)o[0];
    }

    @Override
    public IUniqueIdentifier newID() throws UniqueIdentifierException {
        try {
            ClusterIdentifier clusterID = new ClusterIdentifier();
            InetAddress localMachine = InetAddress.getLocalHost();
            clusterID.setHostname(localMachine.getHostName());
            clusterID.setSuffix(this.clusterIDSuffix);
            return clusterID;
        }
        catch (Exception e) {
            throw new UniqueIdentifierException("Generazione clusteID fallita: " + e.getMessage(), e);
        }
    }

    @Override
    public IUniqueIdentifier convertFromString(String value) throws UniqueIdentifierException {
        if (!value.endsWith(this.clusterIDSuffix)) {
            throw new UniqueIdentifierException("ClusterID non nel corretto formato");
        }
        if (value.length() <= this.clusterIDSuffix.length() + 1) {
            throw new UniqueIdentifierException("ClusterID non nel corretto formato");
        }
        ClusterIdentifier clusterID = new ClusterIdentifier();
        clusterID.setHostname(value.substring(0, value.length() - (this.clusterIDSuffix.length() + 1)));
        clusterID.setSuffix(this.clusterIDSuffix);
        return clusterID;
    }
}

