/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.id;

import it.link.pdd.tools.migrazione_govway.utils.id.ApacheGeneratorConfiguration;
import it.link.pdd.tools.migrazione_govway.utils.id.BaseUniqueIdentifier;
import it.link.pdd.tools.migrazione_govway.utils.id.IUniqueIdentifier;
import it.link.pdd.tools.migrazione_govway.utils.id.IUniqueIdentifierGenerator;
import it.link.pdd.tools.migrazione_govway.utils.id.UniqueIdentifierException;
import it.link.pdd.tools.migrazione_govway.utils.id.apache.IdentifierGenerator;
import it.link.pdd.tools.migrazione_govway.utils.id.apache.serial.AlphanumericGenerator;
import it.link.pdd.tools.migrazione_govway.utils.id.apache.serial.EnumTypeGenerator;
import it.link.pdd.tools.migrazione_govway.utils.id.apache.serial.LongGenerator;
import it.link.pdd.tools.migrazione_govway.utils.id.apache.serial.NumericGenerator;
import it.link.pdd.tools.migrazione_govway.utils.id.apache.serial.PrefixedAlphanumericGenerator;
import it.link.pdd.tools.migrazione_govway.utils.id.apache.serial.PrefixedLeftPaddedNumericGenerator;
import it.link.pdd.tools.migrazione_govway.utils.id.apache.serial.PrefixedNumericGenerator;
import it.link.pdd.tools.migrazione_govway.utils.id.apache.serial.TimeBasedAlphanumericIdentifierGenerator;

public class ApacheIdentifierGenerator
implements IUniqueIdentifierGenerator {
    private IdentifierGenerator identifierGenerator;

    @Override
    public IUniqueIdentifier newID() throws UniqueIdentifierException {
        try {
            return new BaseUniqueIdentifier(this.identifierGenerator.nextIdentifier());
        }
        catch (Exception e) {
            throw new UniqueIdentifierException(e.getMessage(), e);
        }
    }

    @Override
    public IUniqueIdentifier convertFromString(String value) throws UniqueIdentifierException {
        BaseUniqueIdentifier id = new BaseUniqueIdentifier(value);
        return id;
    }

    public void initialize(ApacheGeneratorConfiguration config) throws UniqueIdentifierException {
        this.init(config);
    }

    @Override
    public void init(Object ... o) throws UniqueIdentifierException {
        if (o == null || o.length < 1) {
            throw new UniqueIdentifierException("Devi indicare (tramite il primo parametro) la configurazione di ApacheGenerator tramite la classe: " + ApacheGeneratorConfiguration.class.getName());
        }
        if (!(o[0] instanceof ApacheGeneratorConfiguration)) {
            throw new UniqueIdentifierException("Devi indicare (tramite il primo parametro) la configurazione di ApacheGenerator tramite la classe: " + ApacheGeneratorConfiguration.class.getName());
        }
        ApacheGeneratorConfiguration config = (ApacheGeneratorConfiguration)o[0];
        if (config.getType() == null) {
            throw new UniqueIdentifierException("Il tipo di ApacheGenerator deve essere indicato nella configurazione");
        }
        try {
            switch (config.getType()) {
                case ALPHANUMERIC: 
                case PREFIXED_ALPHANUMERIC: {
                    if (EnumTypeGenerator.PREFIXED_ALPHANUMERIC.equals((Object)config.getType()) && config.getPrefix() == null) {
                        throw new UniqueIdentifierException("Il tipo di ApacheGenerator indicato nella configurazione richiede un prefisso");
                    }
                    this.identifierGenerator = config.getInitialStringValue() != null ? (EnumTypeGenerator.ALPHANUMERIC.equals((Object)config.getType()) ? new AlphanumericGenerator(config.isWrap(), config.getInitialStringValue()) : new PrefixedAlphanumericGenerator(config.getPrefix(), config.isWrap(), config.getInitialStringValue())) : (config.getSize() != null ? (EnumTypeGenerator.ALPHANUMERIC.equals((Object)config.getType()) ? new AlphanumericGenerator(config.isWrap(), config.getSize()) : new PrefixedAlphanumericGenerator(config.getPrefix(), config.isWrap(), config.getSize())) : (EnumTypeGenerator.ALPHANUMERIC.equals((Object)config.getType()) ? new AlphanumericGenerator(config.isWrap()) : new PrefixedAlphanumericGenerator(config.getPrefix(), config.isWrap())));
                    if (config.getEndDigit() != null && config.getStartDigit() != null) {
                        ((AlphanumericGenerator)this.identifierGenerator).setStartEndDigit(config.getStartDigit().charValue(), config.getEndDigit().charValue());
                    } else if (config.getEndDigit() != null) {
                        ((AlphanumericGenerator)this.identifierGenerator).setEndDigit(config.getEndDigit().charValue());
                    } else if (config.getStartDigit() != null) {
                        ((AlphanumericGenerator)this.identifierGenerator).setStartDigit(config.getStartDigit().charValue());
                    }
                    if (config.getEndLetter() != null && config.getStartLetter() != null) {
                        ((AlphanumericGenerator)this.identifierGenerator).setStartEndChar(config.getStartLetter().charValue(), config.getEndLetter().charValue());
                    } else if (config.getEndLetter() != null) {
                        ((AlphanumericGenerator)this.identifierGenerator).setEndChar(config.getEndLetter().charValue());
                    } else if (config.getStartLetter() != null) {
                        ((AlphanumericGenerator)this.identifierGenerator).setStartChar(config.getStartLetter().charValue());
                    }
                    if (config.isEnableLowerCaseLetter() != null) {
                        ((AlphanumericGenerator)this.identifierGenerator).setLowerChar(config.isEnableLowerCaseLetter());
                    }
                    if (config.isEnableUpperCaseLetter() == null) break;
                    ((AlphanumericGenerator)this.identifierGenerator).setUpperChar(config.isEnableUpperCaseLetter());
                    break;
                }
                case NUMERIC: 
                case PREFIXED_NUMERIC: {
                    if (EnumTypeGenerator.PREFIXED_NUMERIC.equals((Object)config.getType()) && config.getPrefix() == null) {
                        throw new UniqueIdentifierException("Il tipo di ApacheGenerator indicato nella configurazione richiede un prefisso");
                    }
                    if (config.getInitalLongValue() == null) {
                        throw new UniqueIdentifierException("Il tipo di ApacheGenerator indicato nella configurazione richiede il valore iniziale di tipo Long ('initialLongValue')");
                    }
                    if (EnumTypeGenerator.NUMERIC.equals((Object)config.getType())) {
                        this.identifierGenerator = new NumericGenerator(config.isWrap(), config.getInitalLongValue());
                        break;
                    }
                    this.identifierGenerator = new PrefixedNumericGenerator(config.getPrefix(), config.isWrap(), config.getInitalLongValue());
                    break;
                }
                case PREFIXED_LEFT_PADDED_NUMERIC: {
                    if (EnumTypeGenerator.PREFIXED_ALPHANUMERIC.equals((Object)config.getType()) && config.getPrefix() == null) {
                        throw new UniqueIdentifierException("Il tipo di ApacheGenerator indicato nella configurazione richiede un prefisso");
                    }
                    if (config.getSize() == null) {
                        throw new UniqueIdentifierException("Il tipo di ApacheGenerator indicato nella configurazione richiede la dimensione ('size')");
                    }
                    this.identifierGenerator = new PrefixedLeftPaddedNumericGenerator(config.getPrefix(), config.isWrap(), config.getSize());
                    break;
                }
                case TIME_BASED_ALPHANUMERIC: {
                    this.identifierGenerator = new TimeBasedAlphanumericIdentifierGenerator();
                    break;
                }
                case LONG: {
                    if (config.getInitalLongValue() == null) {
                        throw new UniqueIdentifierException("Il tipo di ApacheGenerator indicato nella configurazione richiede il valore iniziale di tipo Long ('initialLongValue')");
                    }
                    this.identifierGenerator = new LongGenerator(config.isWrap(), config.getInitalLongValue());
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new UniqueIdentifierException(e.getMessage(), e);
        }
    }
}

