/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.digest;

import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.digest.IDigestReader;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXPathExpressionEngine;
import it.link.pdd.tools.migrazione_govway.utils.xml.DynamicNamespaceContext;
import it.link.pdd.tools.migrazione_govway.utils.xml.XPathNotFoundException;
import it.link.pdd.tools.migrazione_govway.utils.xml.XPathReturnType;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSecurityDigestReader
implements IDigestReader {
    private Logger log;
    private AbstractXPathExpressionEngine xpathEngine;
    private AbstractXMLUtils xmlUtils;

    public WSSecurityDigestReader(AbstractXMLUtils xmlUtils, AbstractXPathExpressionEngine xpathEngine) {
        this(LoggerWrapperFactory.getLogger(WSSecurityDigestReader.class), xmlUtils, xpathEngine);
    }

    public WSSecurityDigestReader(Logger log, AbstractXMLUtils xmlUtils, AbstractXPathExpressionEngine xpathEngine) {
        this.log = log;
        this.xmlUtils = xmlUtils;
        this.xpathEngine = xpathEngine;
    }

    @Override
    public String getDigest(Element element, String referenceId, DynamicNamespaceContext dnc) throws UtilsException {
        try {
            String xPathReferenceElement = "//{http://www.w3.org/2000/09/xmldsig#}Reference[@URI='" + referenceId + "']";
            Node n = null;
            try {
                this.log.debug("Search referenceId con xpath [" + xPathReferenceElement + "] ...");
                n = (Node)this.xpathEngine.getMatchPattern(element, dnc, xPathReferenceElement, XPathReturnType.NODE);
            }
            catch (XPathNotFoundException notFound) {
                xPathReferenceElement = "//Reference[@URI='" + referenceId + "']";
                this.log.debug("Search(2) referenceId con xpath [" + xPathReferenceElement + "] ...");
                try {
                    n = (Node)this.xpathEngine.getMatchPattern(element, dnc, xPathReferenceElement, XPathReturnType.NODE);
                }
                catch (XPathNotFoundException notFoundInternal) {
                    this.log.debug("Reference id [" + referenceId + "] non troavata");
                    return null;
                }
            }
            byte[] nBytes = this.xmlUtils.toByteArray(n);
            this.log.debug("Found Reference Element [" + this.xmlUtils.toString(n) + "]");
            String xPathDigestValue = "//{http://www.w3.org/2000/09/xmldsig#}DigestValue/text()";
            String digest = null;
            try {
                this.log.debug("Search digestValue con xpath [" + xPathDigestValue + "] ...");
                digest = (String)this.xpathEngine.getMatchPattern(this.xmlUtils.newDocument(nBytes), dnc, xPathDigestValue, XPathReturnType.STRING);
            }
            catch (XPathNotFoundException notFound) {
                xPathDigestValue = "//DigestValue/text()";
                this.log.debug("Search(2) digestValue con xpath [" + xPathDigestValue + "] ...");
                digest = (String)this.xpathEngine.getMatchPattern(element, dnc, xPathReferenceElement, XPathReturnType.STRING);
            }
            this.log.debug("Found DigestValue [" + digest + "]");
            return digest;
        }
        catch (Exception e) {
            this.log.error("Errore durante la getDigest", (Throwable)e);
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

