/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.date;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.date.IDate;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.net.time.TimeUDPClient;

public class UDPTimeDate
implements IDate {
    private static InetAddress server = null;
    private static TimeUDPClient udpClient = null;
    private static int defaultTimeout = -1;
    private static Hashtable<String, Date> time = null;
    private static boolean cacheEnabled = true;
    private static int cacheRefresh = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date getDateCached() throws Exception {
        if (!cacheEnabled) {
            return udpClient.getDate(server);
        }
        String key = "" + System.currentTimeMillis() / (long)cacheRefresh;
        if (time.containsKey(key)) {
            return time.get(key);
        }
        Hashtable<String, Date> hashtable = time;
        synchronized (hashtable) {
            if (time.containsKey(key)) {
                return time.get(key);
            }
            Date d = udpClient.getDate(server);
            time.clear();
            time.put(key, d);
            return d;
        }
    }

    @Override
    public void init(Properties properties) throws UtilsException {
        try {
            String cacheRefreshS;
            String cacheS;
            String ipaddressS;
            udpClient = new TimeUDPClient();
            String timeoutS = properties.getProperty("time.timeout");
            if (timeoutS != null) {
                try {
                    defaultTimeout = Integer.parseInt(timeoutS);
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.time.timeout value non valido: " + e.getMessage(), e);
                }
            }
            if (defaultTimeout != -1) {
                udpClient.setDefaultTimeout(defaultTimeout);
            }
            if ((ipaddressS = properties.getProperty("time.server")) == null) {
                throw new Exception("org.openspcoop.pdd.date.property.time.server value non definito");
            }
            if (ipaddressS != null) {
                try {
                    server = InetAddress.getByName(ipaddressS);
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.time.server value non valido: " + e.getMessage(), e);
                }
            }
            if ((cacheS = properties.getProperty("time.cache.enable")) != null) {
                try {
                    cacheEnabled = Boolean.parseBoolean(cacheS);
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.time.cache.enable non valido: " + e.getMessage(), e);
                }
            }
            if ((cacheRefreshS = properties.getProperty("time.cache.refresh")) != null) {
                try {
                    int value = Integer.parseInt(cacheRefreshS);
                    if (value > 1000) {
                        throw new Exception("Valore deve essere minore di 1000");
                    }
                    cacheRefresh = 1000 / value;
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.time.cache.refresh non valido: " + e.getMessage(), e);
                }
            }
            udpClient.open();
            time = new Hashtable();
        }
        catch (Exception e) {
            udpClient = null;
            throw new UtilsException("Inizializzazione TimeUDP Client (properties) non riuscita: " + e.getMessage(), e);
        }
    }

    @Override
    public void close() throws UtilsException {
        try {
            if (udpClient != null) {
                udpClient.close();
            }
        }
        catch (Exception e) {
            throw new UtilsException("Chiusura TimeUDP Client non riuscita: " + e.getMessage(), e);
        }
    }

    @Override
    public Date getDate() throws UtilsException {
        try {
            if (udpClient == null) {
                throw new Exception("Inizializzazione non effettuata, invocare metodo init");
            }
            return UDPTimeDate.getDateCached();
        }
        catch (Exception e) {
            throw new UtilsException("getDate error: " + e.getMessage(), e);
        }
    }

    @Override
    public long getTimeMillis() throws UtilsException {
        try {
            if (udpClient == null) {
                throw new Exception("Inizializzazione non effettuata, invocare metodo init");
            }
            return UDPTimeDate.getDateCached().getTime();
        }
        catch (Exception e) {
            throw new UtilsException("getDate error: " + e.getMessage(), e);
        }
    }

    @Override
    public Timestamp getTimestamp() throws UtilsException {
        try {
            if (udpClient == null) {
                throw new Exception("Inizializzazione non effettuata, invocare metodo init");
            }
            return new Timestamp(UDPTimeDate.getDateCached().getTime());
        }
        catch (Exception e) {
            throw new UtilsException("getDate error: " + e.getMessage(), e);
        }
    }

    @Override
    public Calendar getCalendar() throws UtilsException {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(this.getDate());
        return c;
    }
}

