/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.date;

import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import it.link.pdd.tools.migrazione_govway.utils.date.UnitaTemporale;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static Date convertToLeftInterval(Date date, UnitaTemporale unitaTemporale) {
        Calendar calendar = null;
        try {
            calendar = DateManager.getCalendar();
        }
        catch (Exception e) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        switch (unitaTemporale) {
            case SECONDI: {
                calendar.set(14, 0);
                break;
            }
            case MINUTI: {
                calendar.set(13, 0);
                calendar.set(14, 0);
                break;
            }
            case ORARIO: {
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                break;
            }
            case GIORNALIERO: {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                break;
            }
            case SETTIMANALE: {
                while (2 != calendar.get(7)) {
                    calendar.add(7, -1);
                }
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                break;
            }
            case MENSILE: {
                calendar.set(5, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
        }
        return calendar.getTime();
    }

    public static Date convertToRightInterval(Date date, UnitaTemporale unitaTemporale) {
        Calendar calendar = null;
        try {
            calendar = DateManager.getCalendar();
        }
        catch (Exception e) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        switch (unitaTemporale) {
            case SECONDI: {
                calendar.set(14, 999);
                break;
            }
            case MINUTI: {
                calendar.set(13, 59);
                calendar.set(14, 999);
                break;
            }
            case ORARIO: {
                calendar.set(12, 59);
                calendar.set(13, 59);
                calendar.set(14, 999);
                break;
            }
            case GIORNALIERO: {
                calendar.set(11, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                calendar.set(14, 999);
                break;
            }
            case SETTIMANALE: {
                while (1 != calendar.get(7)) {
                    calendar.add(7, 1);
                }
                calendar.set(11, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                calendar.set(14, 999);
                break;
            }
            case MENSILE: {
                calendar.set(11, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                calendar.set(14, 999);
                int lastDayActualMonth = calendar.getActualMaximum(5);
                calendar.set(5, lastDayActualMonth);
            }
        }
        return calendar.getTime();
    }

    public static Date incrementDate(Date date, UnitaTemporale unitaTemporale, int increment) {
        if (increment == 0) {
            return date;
        }
        Calendar calendar = null;
        try {
            calendar = DateManager.getCalendar();
        }
        catch (Exception e) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        switch (unitaTemporale) {
            case SECONDI: {
                calendar.add(13, increment);
                break;
            }
            case MINUTI: {
                calendar.add(12, increment);
                break;
            }
            case ORARIO: {
                calendar.add(11, increment);
                break;
            }
            case GIORNALIERO: {
                calendar.add(6, increment);
                break;
            }
            case SETTIMANALE: {
                calendar.add(6, increment * 7);
                break;
            }
            case MENSILE: {
                calendar.add(2, increment);
                int lastDayActualMonth = calendar.getActualMaximum(5);
                calendar.set(5, lastDayActualMonth);
            }
        }
        return calendar.getTime();
    }
}

