/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.datasource.test;

import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.datasource.Connection;
import it.link.pdd.tools.migrazione_govway.utils.datasource.DataSource;
import it.link.pdd.tools.migrazione_govway.utils.datasource.DataSourceFactory;
import it.link.pdd.tools.migrazione_govway.utils.datasource.test.ExampleServletInitListener;
import it.link.pdd.tools.migrazione_govway.utils.id.UniversallyUniqueIdentifierGenerator;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExampleService
extends HttpServlet {
    private static UniversallyUniqueIdentifierGenerator uuidGenerator = new UniversallyUniqueIdentifierGenerator();
    private static final long serialVersionUID = 1L;

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!ExampleServletInitListener.isInitialized()) {
            throw new ServletException("Applicazione non inizializzata");
        }
        Object prefix = "";
        try {
            boolean useUUID = false;
            boolean useApplicativeID = false;
            if (req.getParameter("useUUID") != null) {
                useUUID = Boolean.parseBoolean(req.getParameter("useUUID").trim());
            } else if (req.getParameter("useApplicativeID") != null) {
                useApplicativeID = Boolean.parseBoolean(req.getParameter("useApplicativeID").trim());
            }
            String idTransazione = uuidGenerator.newID().getAsString();
            prefix = "[" + idTransazione + "] ";
            System.out.println((String)prefix + "Ricevuta richiesta ...");
            DataSource dsConfig = null;
            String idDsConfig = null;
            idDsConfig = useUUID ? ExampleServletInitListener.UUID_CONFIGURAZIONE : (useApplicativeID ? "Esempio2ConfigurazioneProdotto" : ExampleServletInitListener.JNDI_NAME_CONFIGURAZIONE);
            System.out.println((String)prefix + "Recupero datasource configurazione [" + idDsConfig + "] ...");
            dsConfig = DataSourceFactory.getInstance(idDsConfig);
            System.out.println((String)prefix + "Recuperato datasource configurazione [" + idDsConfig + "]");
            DataSource dsRuntime = null;
            String idDsRuntime = null;
            idDsRuntime = useUUID ? ExampleServletInitListener.UUID_RUNTIME : (useApplicativeID ? "Esempio1RuntimeProdotto" : ExampleServletInitListener.JNDI_NAME_RUNTIME);
            System.out.println((String)prefix + "Recupero datasource runtime [" + idDsRuntime + "] ...");
            dsRuntime = DataSourceFactory.getInstance(idDsRuntime);
            System.out.println((String)prefix + "Recuperato datasource runtime [" + idDsRuntime + "]");
            Connection conConfigInit = null;
            Connection conConfig1 = null;
            Connection conConfig2 = null;
            java.sql.Connection conRuntime1 = null;
            java.sql.Connection conRuntime2 = null;
            try {
                conConfigInit = dsConfig.getWrappedConnection();
                conConfig1 = dsConfig.getWrappedConnection(idTransazione);
                conConfig2 = dsConfig.getWrappedConnection(idTransazione, "AccettazioneRichiesta");
                System.out.println((String)prefix + "Recuperate connessioni dalla configurazione, sleep 10s ...");
                Utilities.sleep(10000L);
                conRuntime1 = dsRuntime.getConnection();
                conRuntime2 = dsRuntime.getConnection(idTransazione, "AccettazioneRichiesta");
                System.out.println((String)prefix + "Recuperate connessioni dalla runtime, sleep 20s ...");
                Utilities.sleep(20000L);
            }
            finally {
                try {
                    if (conConfigInit != null) {
                        conConfigInit.close();
                    }
                }
                catch (Exception eClose) {
                    System.err.println((String)prefix + "Rilascio connessione configInit non riuscito: " + eClose.getMessage());
                    eClose.printStackTrace(System.err);
                }
                try {
                    if (conConfig1 != null) {
                        conConfig1.close();
                    }
                }
                catch (Exception eClose) {
                    System.err.println((String)prefix + "Rilascio connessione config1 non riuscito: " + eClose.getMessage());
                    eClose.printStackTrace(System.err);
                }
                try {
                    if (conConfig2 != null) {
                        conConfig2.close();
                    }
                }
                catch (Exception eClose) {
                    System.err.println((String)prefix + "Rilascio connessione config2 non riuscito: " + eClose.getMessage());
                    eClose.printStackTrace(System.err);
                }
                try {
                    if (conRuntime1 != null) {
                        conRuntime1.close();
                    }
                }
                catch (Exception eClose) {
                    System.err.println((String)prefix + "Rilascio connessione runtime1 non riuscito: " + eClose.getMessage());
                    eClose.printStackTrace(System.err);
                }
                try {
                    if (conRuntime2 != null) {
                        conRuntime2.close();
                    }
                }
                catch (Exception eClose) {
                    System.err.println((String)prefix + "Rilascio connessione runtime2 non riuscito: " + eClose.getMessage());
                    eClose.printStackTrace(System.err);
                }
            }
            System.out.println((String)prefix + "Terminata attivita");
        }
        catch (Exception e) {
            System.err.println((String)prefix + "Errore: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }
}

