/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.datasource;

import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.datasource.DataSourceFactory;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.slf4j.Logger;

public class JmxDataSource
extends NotificationBroadcasterSupport
implements DynamicMBean {
    public static final String NUMERO_DATASOURCE = "datasources";
    public static final String CONNESSIONI_ALLOCATE = "getUsedConnections";
    public static final String DATASOURCE_CREATI = "getDatasources";
    public static final String MSG_OPERAZIONE_NON_EFFETTUATA = "Operazione non riuscita: ";
    private Logger log = LoggerWrapperFactory.getLogger(JmxDataSource.class);

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo o vuoto");
        }
        if (attributeName.equals(NUMERO_DATASOURCE)) {
            return DataSourceFactory.sizeDatasources();
        }
        throw new AttributeNotFoundException("Attributo " + attributeName + " non trovato");
    }

    @Override
    public AttributeList getAttributes(String[] attributesNames) {
        if (attributesNames == null) {
            throw new IllegalArgumentException("Array nullo");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            try {
                list.add(new Attribute(attributesNames[i], this.getAttribute(attributesNames[i])));
                continue;
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo");
        }
        try {
            if (!attribute.getName().equals(NUMERO_DATASOURCE)) {
                throw new AttributeNotFoundException("Attributo " + attribute.getName() + " non trovato");
            }
        }
        catch (ClassCastException ce) {
            throw new InvalidAttributeValueException("il tipo " + attribute.getValue().getClass() + " dell'attributo " + attribute.getName() + " non e' valido");
        }
        catch (JMException j) {
            throw new MBeanException(j);
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Lista degli attributi e' nulla");
        }
        AttributeList ret = new AttributeList();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                ret.add(attribute);
            }
            catch (JMException jMException) {}
        }
        return ret;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException("Nessuna operazione definita");
        }
        if (actionName.equals(CONNESSIONI_ALLOCATE)) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[getUsedConnections] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0]) && (param1 = (String)params[0]) == null) {
                throw new MBeanException(new Exception("Identificativo del datasource non fornito"));
            }
            return this.getUsedDBConnections(param1);
        }
        if (actionName.equals(DATASOURCE_CREATI)) {
            return this.getDatasource();
        }
        throw new UnsupportedOperationException("Operazione " + actionName + " sconosciuta");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        try {
            boolean READABLE = true;
            boolean WRITABLE = true;
            boolean IS_GETTER = true;
            String className = this.getClass().getName();
            String description = "Datasource allocati con la libreria it.link.pdd.tools.migrazione_govway.utils.datasource, premi pulsante (apply changes) per aggiornare i dati";
            MBeanAttributeInfo numDatasourceVAR = new MBeanAttributeInfo(NUMERO_DATASOURCE, Long.TYPE.getName(), "Numero di Datasource allocati", true, false, false);
            MBeanOperationInfo getConnessioneAllocateOP = new MBeanOperationInfo(CONNESSIONI_ALLOCATE, "Moduli funzionali che dispongono di una connessione verso il datasource fornito come parametro", new MBeanParameterInfo[]{new MBeanParameterInfo("idDatasource", String.class.getName(), "Identificativo del datasource")}, String.class.getName(), 1);
            MBeanOperationInfo getDatasourceAllocatiOP = new MBeanOperationInfo(DATASOURCE_CREATI, "Datasource allocati", null, String.class.getName(), 1);
            MBeanConstructorInfo defaultConstructor = new MBeanConstructorInfo("Default Constructor", "Crea e inizializza una nuova istanza del MBean", null);
            MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{numDatasourceVAR};
            MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{defaultConstructor};
            MBeanOperationInfo[] operations = new MBeanOperationInfo[]{getDatasourceAllocatiOP, getConnessioneAllocateOP};
            return new MBeanInfo(className, description, attributes, constructors, operations, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getUsedDBConnections(String uuidDataSource) {
        String[] risorse = null;
        try {
            risorse = DataSourceFactory.getInstance(uuidDataSource).getJmxStatus();
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            return MSG_OPERAZIONE_NON_EFFETTUATA + e.getMessage();
        }
        if (risorse == null || risorse.length <= 0) {
            return "Nessuna connessione allocata";
        }
        StringBuffer bf = new StringBuffer();
        bf.append(risorse.length + " connessioni allocate: \n");
        for (int i = 0; i < risorse.length; ++i) {
            bf.append(risorse[i] + "\n");
        }
        return bf.toString();
    }

    public String getDatasource() {
        String[] risorse = null;
        try {
            risorse = DataSourceFactory.getJmxStatus();
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            return MSG_OPERAZIONE_NON_EFFETTUATA + e.getMessage();
        }
        if (risorse == null || risorse.length <= 0) {
            return "Nessun datasource allocato";
        }
        StringBuffer bf = new StringBuffer();
        bf.append(risorse.length + " datasource allocati: \n");
        for (int i = 0; i < risorse.length; ++i) {
            bf.append(risorse[i] + "\n");
        }
        return bf.toString();
    }
}

