/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.datasource;

import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.UtilsAlreadyExistsException;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.datasource.DataSource;
import it.link.pdd.tools.migrazione_govway.utils.datasource.DataSourceParams;
import it.link.pdd.tools.migrazione_govway.utils.datasource.JmxDataSource;
import it.link.pdd.tools.migrazione_govway.utils.resources.GestoreJNDI;
import it.link.pdd.tools.migrazione_govway.utils.resources.GestoreRisorseJMX;
import it.link.pdd.tools.migrazione_govway.utils.resources.RisorseJMXException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.RefAddr;
import javax.naming.Reference;

public class DataSourceFactory {
    private static Hashtable<String, DataSource> mapUUIDtoDatasources = new Hashtable();
    private static Hashtable<String, String> mapApplicativeIDtoUUID = new Hashtable();
    private static Hashtable<String, String> mapJndiNametoUUID = new Hashtable();
    private static GestoreRisorseJMX gestoreRisorse = null;
    private static final String DATE_FORMAT = "yyyy-MM-dd_HH:mm:ss.SSS";

    private static synchronized void initGestoreRisorseJMX() throws RisorseJMXException {
        if (gestoreRisorse == null) {
            gestoreRisorse = new GestoreRisorseJMX();
        }
    }

    public static int sizeDatasources() {
        return mapUUIDtoDatasources.size();
    }

    public static String[] getJmxStatus() throws UtilsException {
        if (mapUUIDtoDatasources == null || mapUUIDtoDatasources.size() <= 0) {
            return null;
        }
        Collection<DataSource> list = mapUUIDtoDatasources.values();
        Iterator<DataSource> it = list.iterator();
        ArrayList<String> listResource = new ArrayList<String>();
        while (it.hasNext()) {
            DataSource datasource = it.next();
            StringBuffer bf = new StringBuffer();
            SimpleDateFormat dateformat = new SimpleDateFormat(DATE_FORMAT);
            bf.append("(").append(dateformat.format(datasource.getDate())).append(") ");
            bf.append("idDatasource:");
            bf.append(datasource.getUuidDatasource());
            if (datasource.getJndiName() != null) {
                if (bf.length() > 0) {
                    bf.append(" ");
                }
                bf.append("jndiName:");
                bf.append(datasource.getJndiName());
            }
            if (datasource.getApplicativeIdDatasource() != null) {
                if (bf.length() > 0) {
                    bf.append(" ");
                }
                bf.append("idApplicativo:");
                bf.append(datasource.getApplicativeIdDatasource());
            }
            if (bf.length() > 0) {
                bf.append(" ");
            }
            bf.append("ConnessioniAttive:");
            bf.append(datasource.size());
            listResource.add(bf.toString());
        }
        if (listResource.size() > 0) {
            Collections.sort(listResource);
            return listResource.toArray(new String[1]);
        }
        return null;
    }

    public static DataSource newInstance(String jndiName, Properties jndiContext, DataSourceParams params) throws UtilsException, UtilsAlreadyExistsException {
        if (jndiContext == null) {
            jndiContext = new Properties();
        }
        GestoreJNDI jndi = new GestoreJNDI(jndiContext);
        Object oSearch = null;
        try {
            oSearch = jndi.lookup(jndiName);
        }
        catch (Throwable t) {
            throw new UtilsException("Lookup jndiResource [" + jndiName + "] failed: " + t.getMessage(), t);
        }
        if (oSearch == null) {
            throw new UtilsException("Lookup jndiResource [" + jndiName + "] not found");
        }
        javax.sql.DataSource datasource = null;
        try {
            datasource = (javax.sql.DataSource)oSearch;
        }
        catch (Throwable t) {
            StringBuffer bf = new StringBuffer();
            if (oSearch instanceof Reference) {
                Reference r = (Reference)oSearch;
                bf.append(" (Factory=");
                bf.append(r.getFactoryClassName());
                bf.append(" FactoryLocation=");
                bf.append(r.getFactoryClassLocation());
                Enumeration<RefAddr> enR = r.getAll();
                if (enR != null) {
                    while (enR.hasMoreElements()) {
                        RefAddr refAddr = enR.nextElement();
                        bf.append(" [").append("type=").append(refAddr.getType()).append(" content=").append(refAddr.getContent()).append("]");
                    }
                }
                bf.append(")");
            }
            throw new UtilsException("lookup failed (object class: " + oSearch.getClass().getName() + ")" + bf.toString() + ": " + t.getMessage(), t);
        }
        return DataSourceFactory.newInstance(datasource, params, jndiName);
    }

    public static DataSource newInstance(javax.sql.DataSource datasource, DataSourceParams params) throws UtilsException, UtilsAlreadyExistsException {
        return DataSourceFactory.newInstance(datasource, params, null);
    }

    public static synchronized DataSource newInstance(javax.sql.DataSource datasource, DataSourceParams params, String jndiName) throws UtilsException, UtilsAlreadyExistsException {
        if (params == null) {
            throw new UtilsException("Parameters undefined");
        }
        if (params.getDatabaseType() == null) {
            throw new UtilsException("Parameters.databaseType undefined");
        }
        try {
            if (params.getApplicativeId() != null && mapApplicativeIDtoUUID.containsKey(params.getApplicativeId())) {
                throw new UtilsAlreadyExistsException("Datasource with applicative id [" + params.getApplicativeId() + "] already exists");
            }
            if (jndiName != null && mapJndiNametoUUID.containsKey(jndiName)) {
                throw new UtilsAlreadyExistsException("Datasource with jndiName [" + jndiName + "] already exists");
            }
            DataSource ds = new DataSource(datasource, params.getDatabaseType(), params.isWrapOriginalMethods(), jndiName, params.getApplicativeId());
            String uuidDatasource = ds.getUuidDatasource();
            mapUUIDtoDatasources.put(uuidDatasource, ds);
            if (params.getApplicativeId() != null) {
                mapApplicativeIDtoUUID.put(params.getApplicativeId(), uuidDatasource);
            }
            if (jndiName != null) {
                mapJndiNametoUUID.put(jndiName, uuidDatasource);
            }
            if (params.isBindJmx() && gestoreRisorse == null) {
                DataSourceFactory.initGestoreRisorseJMX();
                gestoreRisorse.registerMBean(JmxDataSource.class, params.getJmxDomain(), params.getJmxType(), params.getJmxName(), false);
            }
            return ds;
        }
        catch (UtilsAlreadyExistsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static DataSource getInstance(String id) throws UtilsException {
        String uuid = id;
        if (mapApplicativeIDtoUUID.containsKey(id)) {
            uuid = mapApplicativeIDtoUUID.get(id);
        } else if (mapJndiNametoUUID.containsKey(id)) {
            uuid = mapJndiNametoUUID.get(id);
        }
        DataSource d = mapUUIDtoDatasources.get(uuid);
        if (d == null) {
            throw new UtilsException("Datasource with id [" + id + "] not exists");
        }
        return d;
    }

    public static void closeResources() throws UtilsException {
        mapApplicativeIDtoUUID.clear();
        mapJndiNametoUUID.clear();
        Collection<DataSource> list = mapUUIDtoDatasources.values();
        for (DataSource datasource : list) {
            datasource.setClosed(true);
        }
        boolean waitCloseConnection = true;
        int maxWait = 60000;
        int sleep = 1000;
        int index = 0;
        int count = 1;
        int total = maxWait / sleep;
        while (waitCloseConnection && index < maxWait) {
            list = mapUUIDtoDatasources.values();
            Iterator<DataSource> it = list.iterator();
            boolean closeAll = true;
            StringBuffer bf = new StringBuffer();
            boolean debugClose = true;
            while (it.hasNext()) {
                DataSource datasource = it.next();
                if (datasource.size() <= 0) continue;
                closeAll = false;
                bf.append("Find datasource (applicative-id:" + datasource.getApplicativeIdDatasource() + " jndi:" + datasource.getJndiName() + ") with " + datasource.size() + " released connection:");
                String[] status = datasource.getJmxStatus();
                if (status == null) break;
                for (int i = 0; i < status.length; ++i) {
                    bf.append("\n");
                    bf.append("\t" + status[i]);
                }
            }
            if (!closeAll) {
                if (debugClose && count % 5 == 0) {
                    System.out.println(bf.toString());
                }
                System.out.println("Wait close connection (" + count + "/" + total + ") ...");
                Utilities.sleep(sleep);
                index += sleep;
                ++count;
                continue;
            }
            waitCloseConnection = false;
        }
        if (waitCloseConnection) {
            System.out.println("Forzo chiusura connessioni");
            list = mapUUIDtoDatasources.values();
            for (DataSource datasource : list) {
                if (datasource.size() <= 0) continue;
                datasource.releaseConnnections();
            }
        }
        mapUUIDtoDatasources.clear();
        if (gestoreRisorse != null) {
            gestoreRisorse.unregisterMBeans();
        }
    }
}

