/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.datasource;

import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.datasource.Connection;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import it.link.pdd.tools.migrazione_govway.utils.id.UniversallyUniqueIdentifierGenerator;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Wrapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Logger;

public class DataSource
implements javax.sql.DataSource,
Wrapper {
    private javax.sql.DataSource datasource;
    private TipiDatabase tipoDatabase;
    private boolean wrapOriginalMethods;
    private String uuidDatasource;
    private String applicativeIdDatasource;
    private Date date = null;
    private int transactionIsolationLevelDefault;
    private String jndiName;
    private boolean closed = false;
    private static UniversallyUniqueIdentifierGenerator uuidGenerator = new UniversallyUniqueIdentifierGenerator();
    private Hashtable<String, Connection> releasedConnections = new Hashtable();
    private static final String DATE_FORMAT = "yyyy-MM-dd_HH:mm:ss.SSS";

    public String[] getJmxStatus() throws UtilsException {
        if (this.releasedConnections == null || this.releasedConnections.size() <= 0) {
            return null;
        }
        Collection<Connection> list = this.releasedConnections.values();
        Iterator<Connection> it = list.iterator();
        ArrayList<String> listResource = new ArrayList<String>();
        while (it.hasNext()) {
            Connection connection = it.next();
            StringBuffer bf = new StringBuffer();
            SimpleDateFormat dateformat = new SimpleDateFormat(DATE_FORMAT);
            bf.append("(").append(dateformat.format(connection.getDate())).append(") ");
            if (connection.getIdTransazione() != null) {
                if (bf.length() > 0) {
                    bf.append(" ");
                }
                bf.append("idTransazione:");
                bf.append(connection.getIdTransazione());
            }
            if (connection.getModuloFunzionale() != null && connection.getModuloFunzionale() instanceof String) {
                if (bf.length() > 0) {
                    bf.append(" ");
                }
                bf.append("moduloFunzionale:");
                bf.append(connection.getModuloFunzionale());
            }
            listResource.add(bf.toString());
        }
        if (listResource.size() > 0) {
            Collections.sort(listResource);
            return listResource.toArray(new String[1]);
        }
        return null;
    }

    protected DataSource(javax.sql.DataSource datasource, TipiDatabase tipoDatabase, boolean wrapOriginalMethods, String jndiName, String applicativeIdDatasource) throws SQLException {
        try {
            this.datasource = datasource;
            this.tipoDatabase = tipoDatabase;
            this.wrapOriginalMethods = wrapOriginalMethods;
            this.uuidDatasource = uuidGenerator.newID().getAsString();
            this.jndiName = jndiName;
            this.applicativeIdDatasource = applicativeIdDatasource;
            this.date = DateManager.getDate();
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
        try {
            java.sql.Connection connectionTest = this.datasource.getConnection();
            this.transactionIsolationLevelDefault = connectionTest.getTransactionIsolation();
            connectionTest.close();
        }
        catch (Exception e) {
            throw new SQLException("Test getConnection failed: " + e.getMessage(), e);
        }
    }

    public String getUuidDatasource() {
        return this.uuidDatasource;
    }

    public String getApplicativeIdDatasource() {
        return this.applicativeIdDatasource;
    }

    public int size() {
        return this.releasedConnections.size();
    }

    public int getTransactionIsolationLevelDefault() {
        return this.transactionIsolationLevelDefault;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public Date getDate() {
        return this.date;
    }

    boolean isClosed() {
        return this.closed;
    }

    void setClosed(boolean closed) {
        this.closed = closed;
    }

    void releaseConnnections() {
        Collection<Connection> list = this.releasedConnections.values();
        for (Connection connection : list) {
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        if (this.wrapOriginalMethods) {
            return this.getWrappedConnection(null, null);
        }
        throw new SQLException("Not Supported, use getWrappedConnection");
    }

    @Override
    public java.sql.Connection getConnection(String idTransazione, String moduloFunzionale) throws SQLException {
        if (this.wrapOriginalMethods) {
            return this.getWrappedConnection(idTransazione, moduloFunzionale);
        }
        throw new SQLException("Not Supported, use getWrappedConnection");
    }

    public Connection getWrappedConnection() throws SQLException {
        return this.getWrappedConnection(null, null);
    }

    public Connection getWrappedConnection(String idTransazione) throws SQLException {
        return this.getWrappedConnection(idTransazione, null);
    }

    public Connection getWrappedConnection(String idTransazione, Object moduloFunzionale) throws SQLException {
        if (this.closed) {
            throw new SQLException("Shutdown in progress");
        }
        try {
            Connection c = new Connection(this.datasource.getConnection(), this.tipoDatabase, idTransazione, moduloFunzionale, this.uuidDatasource);
            this.releasedConnections.put(c.getId(), c);
            return c;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    protected void unregisterConnection(Connection connection) throws SQLException {
        if (this.releasedConnections.containsKey(connection.getId())) {
            this.releasedConnections.remove(connection.getId()).closeWrappedConnection();
        }
    }

    public void closeConnection(Connection connection) throws SQLException {
        if (connection == null) {
            throw new SQLException("Parameter undefined");
        }
        connection.close();
    }

    public void closeConnection(java.sql.Connection connection) throws SQLException {
        if (connection == null) {
            throw new SQLException("Parameter undefined");
        }
        if (!(connection instanceof Connection)) {
            throw new SQLException("Connection type unsupported, expected:" + Connection.class + " found:" + connection.getClass().getName());
        }
        ((Connection)connection).close();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.datasource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter pw) throws SQLException {
        this.datasource.setLogWriter(pw);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.datasource.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        this.datasource.setLoginTimeout(timeout);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.datasource instanceof Wrapper) {
            return this.datasource.unwrap(iface);
        }
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (this.datasource instanceof Wrapper) {
            return this.datasource.isWrapperFor(iface);
        }
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.datasource.getParentLogger();
    }
}

