/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.credential;

import it.link.pdd.tools.migrazione_govway.utils.credential.IPrincipalReader;
import it.link.pdd.tools.migrazione_govway.utils.credential.IdentityPrincipalReader;
import it.link.pdd.tools.migrazione_govway.utils.credential.PrincipalReaderException;
import it.link.pdd.tools.migrazione_govway.utils.credential.PrincipalReaderType;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;

public class PrincipalReaderFactory {
    public static IPrincipalReader getReader(Logger log, String nomePrincipalReader) throws PrincipalReaderException {
        log.debug("Caricamento Principal Reader [" + nomePrincipalReader + "] in corso...");
        PrincipalReaderType principalReaderType = PrincipalReaderType.toEnumConstant(nomePrincipalReader);
        String className = null;
        if (principalReaderType != null) {
            switch (principalReaderType) {
                case PRINCIPAL: {
                    return new IdentityPrincipalReader(log);
                }
            }
        } else {
            className = nomePrincipalReader;
        }
        log.debug("Caricamento classe [" + className + "] in corso...");
        try {
            Class<?> c = Class.forName(className);
            Constructor<?> constructor = c.getConstructor(Logger.class);
            IPrincipalReader p = (IPrincipalReader)constructor.newInstance(log);
            return p;
        }
        catch (Exception e) {
            throw new PrincipalReaderException("Impossibile caricare la classe indicata [" + className + "] " + e.getMessage(), e);
        }
    }
}

