/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.cache;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.cache.AbstractCacheJmx;
import it.link.pdd.tools.migrazione_govway.utils.resources.GestoreRisorseJMX;
import it.link.pdd.tools.migrazione_govway.utils.resources.RisorseJMXException;
import org.slf4j.Logger;

public class CacheJMXUtils {
    private static String JMX_DOMAIN = "it.link.pdd.tools.migrazione_govway.utils";
    private static String JMX_TYPE = "type";
    private static GestoreRisorseJMX gestoreRisorse = null;

    private static synchronized void initGestoreRisorseJMX(Logger log) throws RisorseJMXException {
        if (gestoreRisorse == null) {
            gestoreRisorse = new GestoreRisorseJMX(log);
        }
    }

    public static void register(Logger log, AbstractCacheJmx cache) throws UtilsException {
        CacheJMXUtils.register(log, cache, null, null, cache.getCacheWrapper().getCacheName());
    }

    public static void register(Logger log, AbstractCacheJmx cache, String jmxName) throws UtilsException {
        CacheJMXUtils.register(log, cache, null, null, jmxName);
    }

    public static void register(Logger log, AbstractCacheJmx cache, String jmxDomain, String jmxName) throws UtilsException {
        CacheJMXUtils.register(log, cache, jmxDomain, null, jmxName);
    }

    public static void register(Logger log, AbstractCacheJmx cache, String jmxDomain, String jmxType, String jmxName) throws UtilsException {
        try {
            if (jmxName == null) {
                throw new Exception("JmxName undefined");
            }
            if (jmxDomain == null) {
                jmxDomain = JMX_DOMAIN;
            }
            if (jmxType == null) {
                jmxType = JMX_TYPE;
            }
            if (gestoreRisorse == null) {
                CacheJMXUtils.initGestoreRisorseJMX(log);
            }
            gestoreRisorse.registerMBean(cache.getClass(), jmxDomain, jmxType, jmxName);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void unregister() {
        if (gestoreRisorse != null) {
            gestoreRisorse.unregisterMBeans();
        }
    }
}

