/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.cache;

import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.cache.CacheAlgorithm;
import it.link.pdd.tools.migrazione_govway.utils.cache.CacheResponse;
import it.link.pdd.tools.migrazione_govway.utils.resources.CollectionProperties;
import it.link.pdd.tools.migrazione_govway.utils.resources.PropertiesUtilities;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.jcs.JCS;
import org.apache.jcs.admin.CacheRegionInfo;
import org.apache.jcs.admin.CountingOnlyOutputStream;
import org.apache.jcs.admin.JCSAdminBean;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.memory.MemoryCache;
import org.slf4j.Logger;

public class Cache {
    private JCS cache = null;
    private JCSAdminBean cacheAdmin = null;
    private String cacheName = null;
    private boolean errorOccursCountingBytes = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initialize(Logger logConsole, Logger logCore, String cachePropertiesName, String rootDirectory, Properties objectProperties, String OPENSPCOOP2_LOCAL_HOME, String OPENSPCOOP2_CACHE_PROPERTIES, String OPENSPCOOP2_CACHE_LOCAL_PATH) {
        try {
            String value;
            String key;
            Enumeration<Object> ridefinito;
            Properties cacheProperties = new Properties();
            File loggerFile = new File(rootDirectory + cachePropertiesName);
            if (!loggerFile.exists()) {
                cacheProperties.load(Cache.class.getResourceAsStream("/" + cachePropertiesName));
            } else {
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(loggerFile);
                    cacheProperties.load(fin);
                }
                finally {
                    try {
                        if (fin != null) {
                            fin.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            CollectionProperties cachePropertiesRidefinito = PropertiesUtilities.searchLocalImplementation(OPENSPCOOP2_LOCAL_HOME, logConsole, OPENSPCOOP2_CACHE_PROPERTIES, OPENSPCOOP2_CACHE_LOCAL_PATH, rootDirectory);
            if (cachePropertiesRidefinito != null && cachePropertiesRidefinito.size() > 0) {
                ridefinito = cachePropertiesRidefinito.keys();
                while (ridefinito.hasMoreElements()) {
                    key = (String)ridefinito.nextElement();
                    value = cachePropertiesRidefinito.get(key);
                    if (cacheProperties.containsKey(key)) {
                        cacheProperties.remove(key);
                    }
                    cacheProperties.put(key, value);
                }
            }
            if (objectProperties != null && objectProperties.size() > 0) {
                ridefinito = objectProperties.keys();
                while (ridefinito.hasMoreElements()) {
                    key = (String)ridefinito.nextElement();
                    value = (String)objectProperties.get(key);
                    if (cacheProperties.containsKey(key)) {
                        cacheProperties.remove(key);
                    }
                    cacheProperties.put(key, value);
                }
            }
            JCS.setConfigProperties((Properties)cacheProperties);
            return true;
        }
        catch (Exception e) {
            logCore.error("Riscontrato errore durante l'inizializzazione del sistema di cache: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static String printStatistics(String separatorStat, String separatorCache) throws UtilsException {
        Cache cache = new Cache();
        return cache.printAllStats(separatorStat, separatorCache);
    }

    public static void printStatistics(OutputStream out, String separatorStat, String separatorCache) throws UtilsException {
        Cache cache = new Cache();
        cache.printAllStats(out, separatorStat, separatorCache);
    }

    private Cache() {
        this.cacheAdmin = new JCSAdminBean();
    }

    public Cache(String name) throws UtilsException {
        try {
            this.cacheAdmin = new JCSAdminBean();
            this.cacheName = name;
            this.cache = JCS.getInstance((String)name);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public int getCacheSize() {
        return this.cache.getCacheAttributes().getMaxObjects();
    }

    public void setCacheSize(int cacheSize) {
        ICompositeCacheAttributes attr = this.cache.getCacheAttributes();
        attr.setMaxObjects(cacheSize);
        this.cache.setCacheAttributes(attr);
    }

    public CacheAlgorithm getCacheAlgoritm() {
        return CacheAlgorithm.toEnum(this.cache.getCacheAttributes().getCacheName());
    }

    public void setCacheAlgoritm(CacheAlgorithm cacheAlgoritm) {
        ICompositeCacheAttributes attr = this.cache.getCacheAttributes();
        attr.setCacheName(cacheAlgoritm.getAlgorithm());
        this.cache.setCacheAttributes(attr);
    }

    public long getItemIdleTime() throws UtilsException {
        try {
            return this.cache.getDefaultElementAttributes().getIdleTime();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void setItemIdleTime(long itemIdleTimeCache) throws UtilsException {
        try {
            IElementAttributes el = this.cache.getDefaultElementAttributes();
            el.setIdleTime(itemIdleTimeCache);
            this.cache.setDefaultElementAttributes(el);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public long getItemLifeTime() throws UtilsException {
        try {
            return this.cache.getDefaultElementAttributes().getMaxLifeSeconds();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void setItemLifeTime(long itemLifeTimeCache) throws UtilsException {
        try {
            IElementAttributes el = this.cache.getDefaultElementAttributes();
            el.setMaxLifeSeconds(itemLifeTimeCache);
            this.cache.setDefaultElementAttributes(el);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void clear() throws UtilsException {
        if (this.cache != null) {
            try {
                this.cache.clear();
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
    }

    public Object get(String key) {
        return this.cache.get((Object)this.formatKeyCache(key));
    }

    public void remove(String key) throws UtilsException {
        try {
            this.cache.remove((Object)this.formatKeyCache(key));
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void put(String key, CacheResponse value) throws UtilsException {
        try {
            this.cache.put((Object)this.formatKeyCache(key), (Object)value);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void put(String key, Serializable value) throws UtilsException {
        try {
            this.cache.put((Object)this.formatKeyCache(key), (Object)value);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public int getItemCount() throws UtilsException {
        return this.getCacheRegionInfo().getCache().getSize();
    }

    public List<String> keys() throws UtilsException {
        try {
            ArrayList<String> keys = new ArrayList<String>();
            CacheRegionInfo record = this.getCacheRegionInfo();
            Object[] keysObject = record.getCache().getMemoryCache().getKeyArray();
            if (keysObject != null) {
                for (int i = 0; i < keysObject.length; ++i) {
                    keys.add((String)keysObject[i]);
                }
            }
            return keys;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public String printStats(String separator) throws UtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.printStats(bout, separator);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void printStats(OutputStream out, String separator) throws UtilsException {
        this.printStats(this.getCacheRegionInfo(), out, separator, true);
    }

    public String printAllStats(String separatorStat, String separatorCache) throws UtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.printAllStats(bout, separatorStat, separatorCache);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void printAllStats(OutputStream out, String separatorStat, String separatorCache) throws UtilsException {
        try {
            List<CacheRegionInfo> list = this.listCacheRegionInfo();
            for (CacheRegionInfo record : list) {
                this.printStats(record, out, separatorStat, false);
                out.write(separatorCache.getBytes());
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getByteCount(CompositeCache cache) throws Exception {
        this.errorOccursCountingBytes = false;
        MemoryCache memCache = cache.getMemoryCache();
        CountingOnlyOutputStream counter = new CountingOnlyOutputStream();
        ObjectOutputStream out = new ObjectOutputStream((OutputStream)counter);
        try {
            Object[] keys = memCache.getKeyArray();
            if (keys == null) {
                int n = 0;
                return n;
            }
            for (int i = 0; i < keys.length; ++i) {
                ICacheElement ce = cache.get((Serializable)((Object)((String)keys[i])));
                if (ce != null) {
                    Serializable object = ce.getVal();
                    if (object != null) {
                        out.writeObject(object);
                        continue;
                    }
                    this.errorOccursCountingBytes = true;
                    continue;
                }
                this.errorOccursCountingBytes = true;
            }
        }
        catch (Exception e) {
            System.err.println("Problem getting byte count (Modified by OpenSPCoop).  Likley cause is a non serilizable object." + e.getMessage());
            e.printStackTrace();
        }
        finally {
            out.flush();
            out.close();
            counter.flush();
            counter.close();
        }
        int count = counter.getCount();
        if (count < 4) {
            return 0;
        }
        return count - 4;
    }

    private void printStats(CacheRegionInfo region, OutputStream out, String separator, boolean thisCache) throws UtilsException {
        try {
            StringBuffer bf = new StringBuffer();
            int sizeAttuale = -1;
            for (int tentativi = 0; tentativi < 10; ++tentativi) {
                sizeAttuale = this.getByteCount(region.getCache());
                if (!this.errorOccursCountingBytes || !thisCache) break;
                region = this.getCacheRegionInfo();
            }
            bf.append("Nome:");
            bf.append(region.getCache().getCacheName());
            bf.append(" ");
            bf.append(separator);
            bf.append("Stato:");
            bf.append(region.getStatus());
            bf.append(" ");
            bf.append(separator);
            if (region.getCache().getCacheAttributes() != null) {
                bf.append("Algoritmo:");
                String cacheAlgoName = region.getCache().getCacheAttributes().getCacheName();
                CacheAlgorithm cacheEnum = CacheAlgorithm.toEnum(cacheAlgoName);
                if (cacheEnum != null) {
                    bf.append(cacheEnum.name());
                } else {
                    bf.append(cacheAlgoName);
                }
                bf.append(" ");
                bf.append(separator);
                bf.append("Dimensione:");
                bf.append(region.getCache().getCacheAttributes().getMaxObjects());
                bf.append(" ");
                bf.append(separator);
            }
            bf.append("ElementiInCache:");
            bf.append(region.getCache().getMemoryCache().getSize());
            bf.append(" ");
            bf.append(separator);
            bf.append("MemoriaOccupata:");
            if (this.errorOccursCountingBytes) {
                bf.append("[WARN !Error occurs counting bytes, re-try!]");
            }
            bf.append(Utilities.convertBytesToFormatString(sizeAttuale));
            bf.append(" ");
            bf.append(separator);
            if (region.getCache().getElementAttributes() != null) {
                bf.append("IdleTime:");
                long idleTime = region.getCache().getElementAttributes().getIdleTime();
                if (idleTime > 0L) {
                    bf.append(Utilities.convertSystemTimeIntoString_millisecondi(idleTime * 1000L, false));
                } else if (idleTime == 0L) {
                    bf.append("0");
                } else if (idleTime < 0L) {
                    bf.append("Infinito");
                }
                bf.append(" ");
                bf.append(separator);
                bf.append("LifeTime:");
                long lifeTime = region.getCache().getElementAttributes().getMaxLifeSeconds();
                if (lifeTime > 0L) {
                    bf.append(Utilities.convertSystemTimeIntoString_millisecondi(lifeTime * 1000L, false));
                } else if (lifeTime == 0L) {
                    bf.append("0");
                } else if (lifeTime < 0L) {
                    bf.append("Infinito");
                }
                bf.append(" ");
                bf.append(separator);
            }
            bf.append("PutCount:");
            bf.append(region.getCache().getUpdateCount());
            bf.append(" ");
            bf.append(separator);
            bf.append("HitCount(Aux):");
            bf.append(region.getCache().getHitCountAux());
            bf.append(" ");
            bf.append(separator);
            bf.append("HitCount(Ram):");
            bf.append(region.getCache().getHitCountRam());
            bf.append(" ");
            bf.append(separator);
            bf.append("MissCount(Expired):");
            bf.append(region.getCache().getMissCountExpired());
            bf.append(" ");
            bf.append(separator);
            bf.append("MissCount(NotFound):");
            bf.append(region.getCache().getMissCountNotFound());
            bf.append(" ");
            bf.append(separator);
            bf.append("RemoveCount:");
            bf.append(region.getCache().getRemoveCount());
            bf.append(" ");
            out.write(bf.toString().getBytes());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private CacheRegionInfo getCacheRegionInfo() throws UtilsException {
        try {
            List<CacheRegionInfo> list = this.listCacheRegionInfo();
            for (CacheRegionInfo record : list) {
                if (!this.cacheName.equals(record.getCache().getCacheName())) continue;
                return record;
            }
            throw new Exception("Not found");
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private List<CacheRegionInfo> listCacheRegionInfo() throws UtilsException {
        try {
            return this.cacheAdmin.buildCacheInfo();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private String formatKeyCache(String key) {
        StringBuffer bf = new StringBuffer(key);
        if (bf.toString().endsWith(":")) {
            bf.append("_");
        }
        return bf.toString();
    }

    public String toString() {
        StringBuffer bf = new StringBuffer();
        try {
            bf.append("CACHE SIZE[" + this.getCacheSize() + "] ITEM_COUNT[" + this.getItemCount() + "] ITEM_IDLE_TIME[" + this.getItemIdleTime() + "] ITEM_IDLE_LIFE[" + this.getItemLifeTime() + "] CACHE_ALGO[" + this.getCacheAlgoritm() + "] STATS{" + this.printStats("") + "}");
            return bf.toString();
        }
        catch (UtilsException e) {
            return "NonDisponibile";
        }
    }

    public String printKeys(String separator) throws UtilsException {
        StringBuffer bf = new StringBuffer();
        List<String> keys = this.keys();
        for (int i = 0; i < keys.size(); ++i) {
            String key = keys.get(i);
            if (i > 0) {
                bf.append(separator);
            }
            bf.append("Cache[" + i + "]=[" + key + "]");
        }
        return bf.toString();
    }
}

