/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.cache;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.cache.Cache;
import it.link.pdd.tools.migrazione_govway.utils.cache.CacheAlgorithm;
import it.link.pdd.tools.migrazione_govway.utils.cache.CacheResponse;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;

public abstract class AbstractCacheWrapper {
    private Cache cache = null;
    private Logger log = null;
    private String cacheName = null;

    public AbstractCacheWrapper(String cacheName, Logger log) throws UtilsException {
        this(cacheName, true, log, null, null, null, null);
    }

    public AbstractCacheWrapper(String cacheName, boolean initializeCache, Logger log) throws UtilsException {
        this(cacheName, initializeCache, log, null, null, null, null);
    }

    public AbstractCacheWrapper(String cacheName, Logger log, Integer cacheSize, CacheAlgorithm cacheAlgorithm, Integer itemIdleTimeSeconds, Integer itemLifeTimeSeconds) throws UtilsException {
        this(cacheName, true, log, cacheSize, cacheAlgorithm, itemIdleTimeSeconds, itemLifeTimeSeconds);
    }

    private AbstractCacheWrapper(String cacheName, boolean initializeCache, Logger log, Integer cacheSize, CacheAlgorithm cacheAlgorithm, Integer itemIdleTimeSeconds, Integer itemLifeTimeSeconds) throws UtilsException {
        if (cacheName == null) {
            throw new UtilsException("Cache name undefined");
        }
        this.cacheName = cacheName;
        if (log == null) {
            throw new UtilsException("Logger undefined");
        }
        this.log = log;
        if (initializeCache) {
            this.initCacheConfigurazione(cacheSize, cacheAlgorithm, itemIdleTimeSeconds, itemLifeTimeSeconds);
        }
    }

    public String getCacheName() {
        return this.cacheName;
    }

    private void initCacheConfigurazione(Integer cacheSize, CacheAlgorithm cacheAlgorithm, Integer itemIdleTimeSeconds, Integer itemLifeTimeSeconds) throws UtilsException {
        this.cache = new Cache(this.cacheName);
        String msg = null;
        if (cacheSize != null || cacheAlgorithm != null) {
            if (cacheSize != null) {
                int dimensione = -1;
                try {
                    dimensione = cacheSize;
                    msg = "Cache size (" + this.cacheName + "): " + dimensione;
                    this.log.debug(msg);
                    this.cache.setCacheSize(dimensione);
                }
                catch (Exception error) {
                    throw new UtilsException("Cache size parameter wrong (" + this.cacheName + "): " + error.getMessage());
                }
            }
            if (cacheAlgorithm != null) {
                msg = "Cache algorithm (" + this.cacheName + "): " + cacheAlgorithm.name();
                this.log.debug(msg);
                this.cache.setCacheAlgoritm(cacheAlgorithm);
            }
        }
        if (itemIdleTimeSeconds != null || itemLifeTimeSeconds != null) {
            if (itemIdleTimeSeconds != null) {
                int itemIdleTime = -1;
                try {
                    itemIdleTime = itemIdleTimeSeconds;
                    msg = "Cache 'IdleTime' attribute (" + this.cacheName + "): " + itemIdleTimeSeconds;
                    this.log.debug(msg);
                    this.cache.setItemIdleTime(itemIdleTime);
                }
                catch (Exception error) {
                    throw new UtilsException("Cache 'IdleTime' attribute wrong (" + this.cacheName + "): " + error.getMessage());
                }
            }
            if (itemLifeTimeSeconds != null) {
                int itemLifeSecond = -1;
                try {
                    itemLifeSecond = itemLifeTimeSeconds;
                    msg = "Cache 'LifeTime' attribute (" + this.cacheName + "): " + itemLifeSecond;
                    this.log.debug(msg);
                    this.cache.setItemLifeTime(itemLifeSecond);
                }
                catch (Exception error) {
                    throw new UtilsException("Cache 'LifeTime' attribute wrong (" + this.cacheName + "): " + error.getMessage());
                }
            }
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public boolean isCacheEnabled() {
        return this.cache != null;
    }

    public void resetCache() throws UtilsException {
        if (this.cache != null) {
            try {
                this.cache.clear();
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
    }

    public String printStatsCache(String separator) throws UtilsException {
        if (this.cache != null) {
            try {
                return this.cache.printStats(separator);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        throw new UtilsException("Cache disabled");
    }

    public void enableCache() throws UtilsException {
        if (this.cache != null) {
            throw new UtilsException("Cache already enabled");
        }
        try {
            this.cache = new Cache(this.cacheName);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void enableCache(Integer cacheSize, Boolean cacheAlgorithmLRU, Integer itemIdleTimeSeconds, Integer itemLifeTimeSeconds) throws UtilsException {
        CacheAlgorithm cacheAlgorithm = null;
        if (cacheAlgorithmLRU != null) {
            cacheAlgorithm = cacheAlgorithmLRU != false ? CacheAlgorithm.LRU : CacheAlgorithm.MRU;
        }
        this.enableCache(cacheSize, cacheAlgorithm, itemIdleTimeSeconds, itemLifeTimeSeconds);
    }

    public void enableCache(Integer cacheSize, CacheAlgorithm cacheAlgorithm, Integer itemIdleTimeSeconds, Integer itemLifeTimeSeconds) throws UtilsException {
        if (this.cache != null) {
            throw new UtilsException("Cache already enabled");
        }
        try {
            this.initCacheConfigurazione(cacheSize, cacheAlgorithm, itemIdleTimeSeconds, itemLifeTimeSeconds);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void disableCache() throws UtilsException {
        if (this.cache == null) {
            throw new UtilsException("Cache already disabled");
        }
        try {
            this.cache.clear();
            this.cache = null;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public String listKeysCache(String separator) throws UtilsException {
        if (this.cache != null) {
            try {
                return this.cache.printKeys(separator);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        throw new UtilsException("Cache disabled");
    }

    public String getObjectCache(String key) throws UtilsException {
        if (this.cache != null) {
            try {
                Object o = this.cache.get(key);
                if (o != null) {
                    return o.toString();
                }
                return "Object with key [" + key + "] not exists";
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        throw new UtilsException("Cache disabled");
    }

    public String removeObjectCache(String key) throws UtilsException {
        if (this.cache != null) {
            try {
                Object o = this.cache.get(key);
                if (o != null) {
                    this.cache.remove(key);
                    return "Object with key [" + key + "] deleted";
                }
                return "Object with key [" + key + "] not exists";
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        throw new UtilsException("Cache disabled");
    }

    public abstract Object getDriver(Object var1) throws UtilsException;

    public abstract boolean isCachableException(Throwable var1);

    public String getKeyCache(String keyCacheParam, String methodName) {
        return this.buildKeyCache(keyCacheParam, methodName);
    }

    private String buildKeyCache(String keyCacheParam, String methodName) {
        if (keyCacheParam != null && !"".equals(keyCacheParam)) {
            return methodName + "." + keyCacheParam;
        }
        return methodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void duplicateObjectCache(String oldKeyCacheParam, String oldMethodName, String newKeyCacheParam, String newMethodName, boolean debug, boolean throwExceptionIfNotExists) throws UtilsException {
        if (this.cache == null) {
            throw new UtilsException("Cache disabled");
        }
        Cache cache = this.cache;
        synchronized (cache) {
            String oldKey = this.buildKeyCache(oldKeyCacheParam, oldMethodName);
            CacheResponse response = (CacheResponse)this.cache.get(oldKey);
            if (response != null) {
                String newKey = this.buildKeyCache(newKeyCacheParam, newMethodName);
                this.cache.remove(newKey);
                this.cache.put(newKey, response);
                this.log.debug("@" + newKey + "@ Entry add");
            } else {
                if (debug) {
                    this.log.debug("@" + oldKey + "@ Entry not exists");
                }
                if (throwExceptionIfNotExists) {
                    throw new UtilsException("Entry with key [" + oldKey + "] not exists");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectCache(Object driverParam, boolean debug, String keyCacheParam, String methodName, Object ... arguments) throws Throwable {
        String keyCache;
        Object obj;
        Throwable notCachableException;
        Throwable cachableException;
        block41: {
            cachableException = null;
            notCachableException = null;
            obj = null;
            boolean throwException = false;
            if (methodName == null) {
                throw new UtilsException("MethodName undefined");
            }
            keyCache = null;
            if (this.cache == null) {
                if (debug) {
                    this.log.debug("@method:" + methodName + "@ (Cache Disabled) search object with driver...");
                }
                try {
                    obj = this.getObject(driverParam, debug, methodName, arguments);
                }
                catch (Throwable e) {
                    if (this.isCachableException(e)) {
                        cachableException = e;
                        break block41;
                    }
                    notCachableException = e;
                }
            } else {
                Cache e = this.cache;
                synchronized (e) {
                    try {
                        keyCache = this.buildKeyCache(keyCacheParam, methodName);
                        CacheResponse response = (CacheResponse)this.cache.get(keyCache);
                        if (response != null) {
                            if (response.getObject() != null) {
                                if (debug) {
                                    this.log.debug("@" + keyCache + "@ Object (type:" + response.getObject().getClass().getName() + ") (method:" + methodName + ") found in cache.");
                                }
                                return response.getObject();
                            }
                            if (response.isObjectNull()) {
                                if (debug) {
                                    this.log.debug("@" + keyCache + "@ Response null (method:" + methodName + ") found in cache.");
                                }
                                return null;
                            }
                            if (response.getException() != null) {
                                this.log.debug("@" + keyCache + "@ Exception (type:" + response.getException().getClass().getName() + ") (method:" + methodName + ") found in cache.");
                                throwException = true;
                                throw (Throwable)response.getException();
                            }
                            this.log.error("@" + keyCache + "@ Found entry in cache with key [" + keyCache + "] (method:" + methodName + ") without object and exception???");
                        }
                        if (debug) {
                            this.log.debug("@" + keyCache + "@ search object (method:" + methodName + ") with driver...");
                        }
                        boolean nullObject = false;
                        boolean cacheble = false;
                        try {
                            obj = this.getObject(driverParam, debug, methodName, arguments);
                            nullObject = true;
                            cacheble = true;
                        }
                        catch (Throwable e2) {
                            if (this.isCachableException(e2)) {
                                cachableException = e2;
                                cacheble = true;
                            }
                            notCachableException = e2;
                        }
                        if (cacheble) {
                            try {
                                CacheResponse responseCache = new CacheResponse();
                                if (cachableException != null) {
                                    if (debug) {
                                        this.log.debug("@" + keyCache + "@ Add Exception in cache");
                                    }
                                    responseCache.setException(cachableException);
                                } else if (obj != null) {
                                    if (debug) {
                                        this.log.debug("@" + keyCache + "@ Add Object in cache");
                                    }
                                    responseCache.setObject((Serializable)obj);
                                } else if (nullObject) {
                                    if (debug) {
                                        this.log.debug("@" + keyCache + "@ Add Null Response in cache");
                                    }
                                    responseCache.setObjectNull(true);
                                }
                                this.cache.put(keyCache, responseCache);
                            }
                            catch (UtilsException e3) {
                                this.log.error("@" + keyCache + "@ error occurs during insert in cache: " + e3.getMessage(), (Throwable)e3);
                            }
                        }
                    }
                    catch (Throwable e4) {
                        if (!throwException) {
                            this.log.error("@" + keyCache + "@ Error occurs: " + e4.getMessage(), e4);
                            throw new UtilsException(e4.getMessage(), e4);
                        }
                        cachableException = e4;
                    }
                }
            }
        }
        Object cacheMsg = "";
        cacheMsg = this.cache != null && keyCache != null ? "@key:" + keyCache + "@" : "@method:" + methodName + "@";
        if (cachableException != null) {
            if (debug) {
                this.log.debug((String)cacheMsg + " throw CachableException: " + cachableException.getClass().getName());
            }
            throw cachableException;
        }
        if (notCachableException != null) {
            if (debug) {
                this.log.debug((String)cacheMsg + " throw NotCachableException: " + notCachableException.getClass().getName());
            }
            throw notCachableException;
        }
        if (obj != null) {
            if (debug) {
                this.log.debug((String)cacheMsg + " return Object: " + obj.getClass().getName());
            }
            return obj;
        }
        if (debug) {
            this.log.debug((String)cacheMsg + " return null response");
        }
        return null;
    }

    private Object getObject(Object driverParam, boolean debug, String methodName, Object ... arguments) throws Throwable {
        Object obj;
        block16: {
            obj = null;
            try {
                Object driver = this.getDriver(driverParam);
                if (driver == null) {
                    throw new UtilsException("Driver undefined");
                }
                if (arguments.length == 0) {
                    Method method = driver.getClass().getMethod(methodName, new Class[0]);
                    obj = method.invoke(driver, new Object[0]);
                    break block16;
                }
                if (arguments.length == 1) {
                    Method method = driver.getClass().getMethod(methodName, arguments[0].getClass());
                    obj = method.invoke(driver, arguments[0]);
                    break block16;
                }
                if (arguments.length == 2) {
                    Method method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1]);
                    break block16;
                }
                if (arguments.length == 3) {
                    Method method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass(), arguments[2].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2]);
                    break block16;
                }
                if (arguments.length == 4) {
                    Method method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass(), arguments[2].getClass(), arguments[3].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3]);
                    break block16;
                }
                if (arguments.length == 5) {
                    Method method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass(), arguments[2].getClass(), arguments[3].getClass(), arguments[4].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
                    break block16;
                }
                if (arguments.length == 6) {
                    Method method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass(), arguments[2].getClass(), arguments[3].getClass(), arguments[4].getClass(), arguments[5].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
                    break block16;
                }
                if (arguments.length == 7) {
                    Method method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass(), arguments[2].getClass(), arguments[3].getClass(), arguments[4].getClass(), arguments[5].getClass(), arguments[6].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
                    break block16;
                }
                if (arguments.length == 8) {
                    Method method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass(), arguments[2].getClass(), arguments[3].getClass(), arguments[4].getClass(), arguments[5].getClass(), arguments[6].getClass(), arguments[7].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7]);
                    break block16;
                }
                if (arguments.length == 9) {
                    Method method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass(), arguments[2].getClass(), arguments[3].getClass(), arguments[4].getClass(), arguments[5].getClass(), arguments[6].getClass(), arguments[7].getClass(), arguments[8].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8]);
                    break block16;
                }
                if (arguments.length == 10) {
                    Method method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass(), arguments[2].getClass(), arguments[3].getClass(), arguments[4].getClass(), arguments[5].getClass(), arguments[6].getClass(), arguments[7].getClass(), arguments[8].getClass(), arguments[9].getClass());
                    obj = method.invoke(driver, arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9]);
                    break block16;
                }
                throw new Exception("More than 10 arguments unsupported");
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    throw e.getTargetException();
                }
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
        }
        return obj;
    }
}

