/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils.cache;

import it.link.pdd.tools.migrazione_govway.utils.cache.AbstractCacheWrapper;
import it.link.pdd.tools.migrazione_govway.utils.cache.Constants;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;

public abstract class AbstractCacheJmx
extends NotificationBroadcasterSupport
implements DynamicMBean {
    public static final String CACHE_NAME = "cacheName";

    public abstract AbstractCacheWrapper getCacheWrapper();

    public abstract String getJmxDescription();

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo o vuoto");
        }
        if (attributeName.equals("cache")) {
            return this.getCacheWrapper().isCacheEnabled();
        }
        if (attributeName.equals(CACHE_NAME)) {
            return this.getCacheWrapper().getCacheName();
        }
        throw new AttributeNotFoundException("Attribute " + attributeName + " not found");
    }

    @Override
    public AttributeList getAttributes(String[] attributesNames) {
        if (attributesNames == null) {
            throw new IllegalArgumentException("Attributes Names undefined");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            try {
                list.add(new Attribute(attributesNames[i], this.getAttribute(attributesNames[i])));
                continue;
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block9: {
            if (attribute == null) {
                throw new IllegalArgumentException("Attribute name undefined");
            }
            try {
                if (attribute.getName().equals("cache")) {
                    boolean v = (Boolean)attribute.getValue();
                    if (v) {
                        if (!this.getCacheWrapper().isCacheEnabled()) {
                            this.abilitaCache();
                        }
                    } else if (this.getCacheWrapper().isCacheEnabled()) {
                        this.disabilitaCache();
                    }
                    break block9;
                }
                throw new AttributeNotFoundException("Attributo " + attribute.getName() + " non trovato");
            }
            catch (ClassCastException ce) {
                throw new InvalidAttributeValueException("Type " + attribute.getValue().getClass() + " for attribute " + attribute.getName() + " is not valid");
            }
            catch (JMException j) {
                throw new MBeanException(j);
            }
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Lista degli attributi e' nulla");
        }
        AttributeList ret = new AttributeList();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                ret.add(attribute);
            }
            catch (JMException jMException) {}
        }
        return ret;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException("Operation undefined");
        }
        if (actionName.equals("resetCache")) {
            return this.resetCache();
        }
        if (actionName.equals("printStatsCache")) {
            return this.printStatCache();
        }
        if (actionName.equals("disableCache")) {
            return this.disabilitaCacheConEsito();
        }
        if (actionName.equals("enableCache")) {
            if (params.length != 4) {
                throw new MBeanException(new Exception("[enableCache] Parameter size uncorrect: " + params.length));
            }
            Integer param1 = null;
            if (params[0] != null && !"".equals(params[0]) && (param1 = (Integer)params[0]) < 0) {
                param1 = null;
            }
            Boolean param2 = null;
            if (params[1] != null && !"".equals(params[1])) {
                param2 = (Boolean)params[1];
            }
            Integer param3 = null;
            if (params[2] != null && !"".equals(params[2]) && (param3 = (Integer)params[2]) < 0) {
                param3 = null;
            }
            Integer param4 = null;
            if (params[3] != null && !"".equals(params[3]) && (param4 = (Integer)params[3]) < 0) {
                param4 = null;
            }
            return this.abilitaCache(param1, param2, param3, param4);
        }
        if (actionName.equals("listKeysCache")) {
            return this.listKeysCache();
        }
        if (actionName.equals("getObjectCache")) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[getObjectCache] Parameter size uncorrect: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.getObjectCache(param1);
        }
        if (actionName.equals("removeObjectCache")) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[removeObjectCache] Parameter size uncorrect: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.removeObjectCache(param1);
        }
        throw new UnsupportedOperationException("Operation " + actionName + " unknown");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        String className = this.getClass().getName();
        String description = this.getJmxDescription();
        MBeanAttributeInfo cacheAbilitataVAR = Constants.MBEAN_ATTRIBUTE_INFO_CACHE_ABILITATA;
        MBeanAttributeInfo registriServiziVAR = new MBeanAttributeInfo(CACHE_NAME, String[].class.getName(), "Elenco dei registri dei servizi utilizzati a RunTime dalla Porta di Dominio", true, false, false);
        MBeanOperationInfo resetCacheOP = Constants.MBEAN_OPERATION_RESET_CACHE;
        MBeanOperationInfo printStatCacheOP = Constants.MBEAN_OPERATION_PRINT_STATS_CACHE;
        MBeanOperationInfo disabilitaCacheOP = Constants.MBEAN_OPERATION_DISABILITA_CACHE;
        MBeanOperationInfo abilitaCacheParametriOP = Constants.MBEAN_OPERATION_ABILITA_CACHE_CON_PARAMETRI;
        MBeanOperationInfo listKeysCacheOP = Constants.MBEAN_OPERATION_LIST_KEYS_CACHE;
        MBeanOperationInfo getObjectCacheOP = Constants.MBEAN_OPERATION_GET_OBJECT_CACHE;
        MBeanOperationInfo removeObjectCacheOP = Constants.MBEAN_OPERATION_REMOVE_OBJECT_CACHE;
        MBeanConstructorInfo defaultConstructor = new MBeanConstructorInfo("Default Constructor", "New Instance of MBean", null);
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{cacheAbilitataVAR, registriServiziVAR};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{defaultConstructor};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{resetCacheOP, printStatCacheOP, disabilitaCacheOP, abilitaCacheParametriOP, listKeysCacheOP, getObjectCacheOP, removeObjectCacheOP};
        return new MBeanInfo(className, description, attributes, constructors, operations, null);
    }

    public String resetCache() {
        try {
            if (!this.getCacheWrapper().isCacheEnabled()) {
                throw new Exception("Cache disabled");
            }
            this.getCacheWrapper().resetCache();
            return "Operation 'resetCache' done";
        }
        catch (Throwable e) {
            this.getCacheWrapper().getLog().error("Operation failed: " + e.getMessage(), e);
            return "Operation failed: " + e.getMessage();
        }
    }

    public String printStatCache() {
        try {
            if (!this.getCacheWrapper().isCacheEnabled()) {
                throw new Exception("Cache non abilitata");
            }
            return this.getCacheWrapper().printStatsCache("\n");
        }
        catch (Throwable e) {
            this.getCacheWrapper().getLog().error("Operation failed: " + e.getMessage(), e);
            return "Operation failed: " + e.getMessage();
        }
    }

    public void abilitaCache() throws JMException {
        try {
            this.getCacheWrapper().enableCache();
        }
        catch (Throwable e) {
            this.getCacheWrapper().getLog().error(e.getMessage(), e);
        }
    }

    public String abilitaCache(Integer dimensioneCache, Boolean algoritmoCacheLRU, Integer itemIdleTime, Integer itemLifeSecond) {
        try {
            this.getCacheWrapper().enableCache(dimensioneCache, algoritmoCacheLRU, itemIdleTime, itemLifeSecond);
            return "Operation 'enableCache' done";
        }
        catch (Throwable e) {
            this.getCacheWrapper().getLog().error(e.getMessage(), e);
            return "Operation failed: " + e.getMessage();
        }
    }

    public void disabilitaCache() throws JMException {
        try {
            this.getCacheWrapper().disableCache();
        }
        catch (Throwable e) {
            this.getCacheWrapper().getLog().error(e.getMessage(), e);
            throw new JMException(e.getMessage());
        }
    }

    public String disabilitaCacheConEsito() {
        try {
            this.disabilitaCache();
            return "Operation 'disableCache' done";
        }
        catch (Throwable e) {
            this.getCacheWrapper().getLog().error(e.getMessage(), e);
            return "Operation failed: " + e.getMessage();
        }
    }

    public String listKeysCache() {
        try {
            if (!this.getCacheWrapper().isCacheEnabled()) {
                throw new Exception("Cache disabled");
            }
            return this.getCacheWrapper().listKeysCache("\n");
        }
        catch (Throwable e) {
            this.getCacheWrapper().getLog().error("Operation failed: " + e.getMessage(), e);
            return "Operation failed: " + e.getMessage();
        }
    }

    public String getObjectCache(String key) {
        try {
            if (!this.getCacheWrapper().isCacheEnabled()) {
                throw new Exception("Cache disabled");
            }
            return this.getCacheWrapper().getObjectCache(key);
        }
        catch (Throwable e) {
            this.getCacheWrapper().getLog().error("Operation failed: " + e.getMessage(), e);
            return "Operation failed: " + e.getMessage();
        }
    }

    public String removeObjectCache(String key) {
        try {
            if (!this.getCacheWrapper().isCacheEnabled()) {
                throw new Exception("Cache disabled");
            }
            return this.getCacheWrapper().removeObjectCache(key);
        }
        catch (Throwable e) {
            this.getCacheWrapper().getLog().error("Operation failed: " + e.getMessage(), e);
            return "Operation failed: " + e.getMessage();
        }
    }
}

