/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils;

import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.json.JsonConfigurationFactory;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationFactory;
import org.apache.logging.log4j.core.config.xml.XmlConfigurationFactory;
import org.apache.logging.log4j.core.config.yaml.YamlConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerWrapperFactory {
    public static Logger getLogger(Class<?> c) {
        return LoggerFactory.getLogger(c);
    }

    public static Logger getLogger(String name) {
        return LoggerFactory.getLogger((String)name);
    }

    public static org.apache.logging.log4j.Logger getLoggerImpl(Class<?> c) {
        return LogManager.getLogger(c);
    }

    public static org.apache.logging.log4j.Logger getLoggerImpl(String name) {
        return LogManager.getLogger((String)name);
    }

    public static void setPropertiesConfigurationFactory() {
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)new PropertiesConfigurationFactory());
    }

    public static void setJSonConfigurationFactory() {
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)new JsonConfigurationFactory());
    }

    public static void setXmlConfigurationFactory() {
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)new XmlConfigurationFactory());
    }

    public static void setYamlConfigurationFactory() {
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)new YamlConfigurationFactory());
    }

    private static LoggerContext getContext() {
        return (LoggerContext)LogManager.getContext((boolean)false);
    }

    private static LoggerContext getContext(boolean currentContext) {
        return (LoggerContext)LogManager.getContext((boolean)currentContext);
    }

    public static void setDefaultConsoleLogConfiguration(Level level) throws UtilsException {
        LoggerWrapperFactory.setDefaultLogConfiguration(level, true, "%p <%d{dd-MM-yyyy HH:mm:ss.SSS}> %C.%M(%L): %m %n %n", null, null);
    }

    public static void setDefaultConsoleLogConfiguration(Level level, String layout) throws UtilsException {
        LoggerWrapperFactory.setDefaultLogConfiguration(level, true, layout, null, null);
    }

    public static void setDefaultLogConfiguration(Level level, boolean console, String layoutConsole, File file, String layoutFile) throws UtilsException {
        if (layoutConsole == null) {
            layoutConsole = "%p <%d{dd-MM-yyyy HH:mm:ss.SSS}> %C.%M(%L): %m %n %n";
        }
        if (layoutFile == null) {
            layoutFile = "%p <%d{dd-MM-yyyy HH:mm:ss.SSS}> %C.%M(%L): %m %n %n";
        }
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setConfigurationName("ConsoleDefault");
        builder.setStatusLevel(Level.ERROR);
        if (console) {
            AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender("Stdout", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT);
            appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", layoutConsole));
            builder.add(appenderBuilder);
        }
        if (file != null) {
            LayoutComponentBuilder layoutBuilder = (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", layoutFile);
            ComponentBuilder triggeringPolicy = builder.newComponent("Policies").addComponent(builder.newComponent("CronTriggeringPolicy").addAttribute("schedule", "0 0 0 * * ?")).addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "100M"));
            AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("rolling", "RollingFile").addAttribute("fileName", file.getAbsolutePath())).addAttribute("filePattern", file.getAbsolutePath() + ".%i")).add(layoutBuilder).addComponent(triggeringPolicy);
            builder.add(appenderBuilder);
        }
        RootLoggerComponentBuilder rootLoggerBuilder = builder.newRootLogger(level);
        if (console) {
            rootLoggerBuilder.add(builder.newAppenderRef("Stdout"));
        }
        if (file != null) {
            rootLoggerBuilder.add(builder.newAppenderRef("rolling"));
        }
        builder.add(rootLoggerBuilder);
        Configurator.initialize((Configuration)((Configuration)builder.build()));
    }

    public static void setLogConfiguration(File file) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), file, false);
    }

    public static void setLogConfiguration(File file, boolean append) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), file, append);
    }

    private static void setLogConfiguration(LoggerContext context, File file, boolean append) throws UtilsException {
        block6: {
            String filePath = "fs";
            try {
                if (file == null) {
                    throw new Exception("Resource file undefined");
                }
                filePath = file.getAbsolutePath();
                if (file.exists()) {
                    if (append) {
                        LoggerWrapperFactory.appendConfiguration(context, file.toURI());
                    } else {
                        LoggerWrapperFactory.newConfiguration(context, file.toURI());
                    }
                    break block6;
                }
                throw new UtilsException("Resource not exists");
            }
            catch (Exception e) {
                throw new UtilsException("Setting Logging Configuration (resource [" + filePath + "]): " + e.getMessage(), e);
            }
        }
    }

    public static void setLogConfiguration(String name) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), name, false);
    }

    public static void setLogConfiguration(String name, boolean append) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), name, append);
    }

    private static void setLogConfiguration(LoggerContext context, String name, boolean append) throws UtilsException {
        block9: {
            try {
                if (name == null) {
                    throw new Exception("Resource name undefined");
                }
                File f = new File(name);
                if (f.exists()) {
                    if (append) {
                        LoggerWrapperFactory.appendConfiguration(context, f.toURI());
                    } else {
                        LoggerWrapperFactory.newConfiguration(context, f.toURI());
                    }
                    break block9;
                }
                Object newName = null;
                newName = name.trim().startsWith("/") ? name : "/" + name;
                URL url = Utilities.class.getResource((String)newName);
                if (url != null) {
                    if (append) {
                        LoggerWrapperFactory.appendConfiguration(context, url.toURI());
                    } else {
                        LoggerWrapperFactory.newConfiguration(context, url.toURI());
                    }
                    break block9;
                }
                throw new UtilsException("Resource [" + name + "] not found");
            }
            catch (Exception e) {
                throw new UtilsException("Setting Logging Configuration failed (resource [" + name + "]): " + e.getMessage(), e);
            }
        }
    }

    public static void setLogConfiguration(URL url) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), url, false);
    }

    public static void setLogConfiguration(URL url, boolean append) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), url, append);
    }

    private static void setLogConfiguration(LoggerContext context, URL url, boolean append) throws UtilsException {
        try {
            if (url == null) {
                throw new Exception("Resource URL undefined");
            }
            if (append) {
                LoggerWrapperFactory.appendConfiguration(context, url.toURI());
            } else {
                LoggerWrapperFactory.newConfiguration(context, url.toURI());
            }
        }
        catch (Exception e) {
            throw new UtilsException("Setting Logging Configuration failed (url [" + url + "]): " + e.getMessage(), e);
        }
    }

    public static void setLogConfiguration(URI uri) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), uri, false);
    }

    public static void setLogConfiguration(URI uri, boolean append) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), uri, append);
    }

    private static void setLogConfiguration(LoggerContext context, URI uri, boolean append) throws UtilsException {
        try {
            if (uri == null) {
                throw new Exception("Resource URI undefined");
            }
            if (append) {
                LoggerWrapperFactory.appendConfiguration(context, uri);
            } else {
                LoggerWrapperFactory.newConfiguration(context, uri);
            }
        }
        catch (Exception e) {
            throw new UtilsException("Setting Logging Configuration failed (uri [" + uri + "]): " + e.getMessage(), e);
        }
    }

    public static void setLogConfiguration(Properties props) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), props, false);
    }

    public static void setLogConfiguration(Properties props, boolean append) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), props, append);
    }

    private static void setLogConfiguration(LoggerContext context, Properties props, boolean append) throws UtilsException {
        File fTmp = null;
        FileOutputStream foutTmp = null;
        try {
            if (props == null) {
                throw new Exception("Resource Properties undefined");
            }
            fTmp = File.createTempFile("op2_log", ".properties");
            foutTmp = new FileOutputStream(fTmp);
            props.store(foutTmp, "Tmp Configuration");
            foutTmp.flush();
            foutTmp.close();
            foutTmp = null;
            if (append) {
                LoggerWrapperFactory.appendConfiguration(context, fTmp.toURI());
            } else {
                LoggerWrapperFactory.newConfiguration(context, fTmp.toURI());
            }
        }
        catch (Exception e) {
            throw new UtilsException("Setting Logging Configuration failed: " + e.getMessage(), e);
        }
        finally {
            try {
                if (foutTmp != null) {
                    foutTmp.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fTmp != null) {
                    fTmp.delete();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void newConfiguration(LoggerContext context, URI configUri) throws Exception {
        context.setConfigLocation(configUri);
    }

    private static synchronized void appendConfiguration(LoggerContext context, URI configUri) throws Exception {
        Map mapLoggers;
        Configuration actualConfiguration = context.getConfiguration();
        ConfigurationFactory configurationFactory = ConfigurationFactory.getInstance();
        Configuration appendConfiguration = configurationFactory.getConfiguration(new LoggerContext(actualConfiguration.getName()), actualConfiguration.getName(), configUri);
        appendConfiguration.initialize();
        Map mapAppenders = appendConfiguration.getAppenders();
        if (mapAppenders.size() > 0) {
            for (String appenderName : mapAppenders.keySet()) {
                Appender appender = (Appender)mapAppenders.get(appenderName);
                appender.start();
                actualConfiguration.addAppender(appender);
            }
        }
        if ((mapLoggers = appendConfiguration.getLoggers()).size() > 0) {
            for (String loggerName : mapLoggers.keySet()) {
                LoggerConfig logger = (LoggerConfig)mapLoggers.get(loggerName);
                actualConfiguration.addLogger(loggerName, logger);
            }
        }
    }
}

