/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.utils;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class DynamicStringReplace {
    public static void validate(String messaggioWithPlaceHolder) throws UtilsException {
        if (messaggioWithPlaceHolder != null && messaggioWithPlaceHolder.length() > 2) {
            int index1 = messaggioWithPlaceHolder.indexOf("{");
            int index2 = messaggioWithPlaceHolder.indexOf("}", index1 + 1);
            if (index1 < 0 || index2 < 0) {
                return;
            }
        }
        StringBuffer keyword = new StringBuffer();
        boolean separator = false;
        for (int i = 0; i < messaggioWithPlaceHolder.length(); ++i) {
            char ch = messaggioWithPlaceHolder.charAt(i);
            if ('{' == ch || '}' == ch) {
                if (!separator) {
                    separator = true;
                    continue;
                }
                String key = keyword.toString();
                if (!key.contains(":")) {
                    throw new UtilsException("Placeholder [{" + key + "}] resolution failed: wrong format, required {key:value}");
                }
                if (key.startsWith(":") || key.endsWith(":")) {
                    throw new UtilsException("Placeholder [{" + key + "}] resolution failed: wrong format, required {key:value}");
                }
                String tipo = key.substring(0, key.indexOf(":"));
                String value = key.substring(key.indexOf(":") + 1);
                if (tipo == null || "".equals(tipo.trim())) {
                    throw new UtilsException("Placeholder [{" + key + "}] resolution failed: wrong format, required {key:value}");
                }
                if (value == null || "".equals(value.trim())) {
                    throw new UtilsException("Placeholder [{" + key + "}] resolution failed: wrong format, required {key:value}");
                }
                keyword.delete(0, keyword.length());
                separator = false;
                continue;
            }
            if (!separator) continue;
            keyword.append(ch);
        }
    }

    public static String replace(String messaggioWithPlaceHolder, Map<String, Object> map) throws UtilsException {
        DynamicStringReplace.validate(messaggioWithPlaceHolder);
        if (messaggioWithPlaceHolder != null && messaggioWithPlaceHolder.length() > 2) {
            int index1 = messaggioWithPlaceHolder.indexOf("{");
            int index2 = messaggioWithPlaceHolder.indexOf("}", index1 + 1);
            if (index1 < 0 || index2 < 0) {
                return messaggioWithPlaceHolder;
            }
        }
        StringBuffer bf = new StringBuffer();
        StringBuffer keyword = new StringBuffer();
        boolean separator = false;
        for (int i = 0; i < messaggioWithPlaceHolder.length(); ++i) {
            char ch = messaggioWithPlaceHolder.charAt(i);
            if ('{' == ch || '}' == ch) {
                if (!separator) {
                    separator = true;
                    continue;
                }
                String key = keyword.toString();
                if (!key.contains(":")) {
                    throw new UtilsException("Placeholder [{" + key + "}] resolution failed: wrong format, required {key:value}");
                }
                if (key.startsWith(":") || key.endsWith(":")) {
                    throw new UtilsException("Placeholder [{" + key + "}] resolution failed: wrong format, required {key:value}");
                }
                String tipo = key.substring(0, key.indexOf(":"));
                String value = key.substring(key.indexOf(":") + 1);
                if (!map.containsKey(tipo)) {
                    throw new UtilsException("Placeholder [{" + key + "}] resolution failed: object with key [" + tipo + "] not found");
                }
                Object object = map.get(tipo);
                if (object == null) {
                    throw new UtilsException("Placeholder [{" + key + "}] resolution failed: object with key [" + tipo + "] is null");
                }
                String valoreRimpiazzato = DynamicStringReplace.getValue(key, tipo, value, object);
                if (valoreRimpiazzato == null) {
                    throw new UtilsException("Placeholder [{" + key + "}] resolution failed");
                }
                bf.append(valoreRimpiazzato);
                keyword.delete(0, keyword.length());
                separator = false;
                continue;
            }
            if (separator) {
                keyword.append(ch);
                continue;
            }
            bf.append(ch);
        }
        return bf.toString();
    }

    private static String getValue(String key, String tipo, String value, Object object) throws UtilsException {
        Date d = null;
        if (object instanceof Date) {
            d = (Date)object;
        } else if (object instanceof java.sql.Date) {
            d = (java.sql.Date)object;
        } else if (object instanceof Calendar) {
            Calendar c = (Calendar)object;
            d = c.getTime();
        }
        if (d != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(value);
            return sdf.format(d);
        }
        if (object instanceof List || object instanceof Map || object instanceof Object[]) {
            String position = value;
            String newValue = value;
            if (value.contains(".")) {
                position = value.substring(0, value.indexOf("."));
                try {
                    newValue = value.substring(value.indexOf(".") + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Object oInternal = null;
            if (object instanceof List || object instanceof Object[]) {
                int index = -1;
                try {
                    index = Integer.parseInt(position);
                }
                catch (Exception e) {
                    throw new UtilsException("Placeholder [{" + key + "}] resolution failed: object [" + object.getClass().getName() + "] with wrong position position [" + position + "] (not integer?): " + e.getMessage() + " )");
                }
                if (object instanceof List) {
                    List list = (List)object;
                    if (list.size() <= index) {
                        throw new UtilsException("Placeholder [{" + key + "}] resolution failed: object [" + object.getClass().getName() + "] with wrong position position " + index + " (list size:" + list.size() + ") )");
                    }
                    oInternal = list.get(index);
                } else if (object instanceof Object[]) {
                    Object[] arrayObj = (Object[])object;
                    if (arrayObj.length <= index) {
                        throw new UtilsException("Placeholder [{" + key + "}] resolution failed: object [" + object.getClass().getName() + "] with wrong position position " + index + " (array size:" + arrayObj.length + ") )");
                    }
                    oInternal = arrayObj[index];
                }
            } else if (object instanceof Map) {
                Map map = (Map)object;
                if (!map.containsKey(position)) {
                    throw new UtilsException("Placeholder [{" + key + "}] resolution failed: object [" + object.getClass().getName() + "] with wrong position [" + position + "] not exists as key in map )");
                }
                oInternal = map.get(position);
            }
            if (newValue.contains(".")) {
                if (oInternal == null) {
                    throw new UtilsException("Placeholder [{" + key + "}] resolution failed: object [" + object.getClass().getName() + "][" + position + "] return null object");
                }
                return DynamicStringReplace.readValueInObject(key, oInternal, newValue);
            }
            String finalValue = null;
            if (oInternal != null) {
                if (oInternal instanceof Date) {
                    SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMdd_HHmmssSSS");
                    finalValue = dateformat.format((Date)oInternal);
                } else {
                    if (oInternal instanceof byte[]) {
                        throw new UtilsException("Placeholder [{" + key + "}] resolution failed: object [" + object.getClass().getName() + "][" + position + "] return object with type [" + oInternal.getClass().getName() + "]");
                    }
                    finalValue = oInternal.toString();
                }
            } else {
                throw new UtilsException("Placeholder [{" + key + "}] resolution failed: object [" + object.getClass().getName() + "][" + position + "] return null object");
            }
            return finalValue;
        }
        return DynamicStringReplace.readValueInObject(key, object, value);
    }

    private static String readValueInObject(String key, Object o, String name) throws UtilsException {
        String fieldName = name;
        String position = null;
        if (name.contains(".")) {
            fieldName = name.substring(0, name.indexOf("."));
        }
        String methodName = new String(fieldName);
        if (fieldName.endsWith("]") && fieldName.contains("[")) {
            try {
                position = fieldName.substring(fieldName.indexOf("[") + 1, fieldName.length() - 1);
                methodName = fieldName.substring(0, fieldName.indexOf("["));
            }
            catch (Exception e) {
                throw new UtilsException("Placeholder [{" + key + "}] resolution failed: position error in field [" + fieldName + "]: " + e.getMessage(), e);
            }
        }
        String getMethod = "get" + ("" + methodName.charAt(0)).toUpperCase();
        if (methodName.length() > 1) {
            getMethod = getMethod + methodName.substring(1);
        }
        Method m = null;
        try {
            m = o.getClass().getMethod(getMethod, new Class[0]);
        }
        catch (Throwable e) {
            throw new UtilsException("Placeholder [{" + key + "}] resolution failed: method [" + o.getClass().getName() + "." + getMethod + "()] not found; " + e.getMessage(), e);
        }
        Object ret = null;
        try {
            ret = m.invoke(o, new Object[0]);
        }
        catch (Throwable e) {
            throw new UtilsException("Placeholder [{" + key + "}] resolution failed: invocation method [" + o.getClass().getName() + "." + getMethod + "()] failed; " + e.getMessage(), e);
        }
        if (ret != null && (ret instanceof List || ret instanceof Map || ret instanceof Object[])) {
            if (position == null) {
                throw new UtilsException("Placeholder [{" + key + "}] resolution failed: method [" + o.getClass().getName() + "." + getMethod + "()] return " + ret.getClass().getName() + " object without position");
            }
            if (ret instanceof List || ret instanceof Object[]) {
                int index = -1;
                try {
                    index = Integer.parseInt(position);
                }
                catch (Exception e) {
                    throw new UtilsException("Placeholder [{" + key + "}] resolution failed: method [" + o.getClass().getName() + "." + getMethod + "()] return " + ret.getClass().getName() + " object, wrong position value (not integer?): " + e.getMessage() + " )");
                }
                if (ret instanceof List) {
                    List list = (List)ret;
                    if (list.size() <= index) {
                        throw new UtilsException("Placeholder [{" + key + "}] resolution failed: method [" + o.getClass().getName() + "." + getMethod + "()] return " + ret.getClass().getName() + " object, wrong position value " + index + " (list size:" + list.size() + ") )");
                    }
                    ret = list.get(index);
                } else if (ret instanceof Object[]) {
                    Object[] arrayObj = (Object[])ret;
                    if (arrayObj.length <= index) {
                        throw new UtilsException("Placeholder [{" + key + "}] resolution failed: method [" + o.getClass().getName() + "." + getMethod + "()] return " + ret.getClass().getName() + " object, wrong position value " + index + " (array size:" + arrayObj.length + ") )");
                    }
                    ret = arrayObj[index];
                }
            } else if (ret instanceof Map) {
                Map map = (Map)ret;
                if (!map.containsKey(position)) {
                    throw new UtilsException("Placeholder [{" + key + "}] resolution failed: method [" + o.getClass().getName() + "." + getMethod + "()] return " + ret.getClass().getName() + " object, wrong position [" + position + "] not exists as key in map )");
                }
                ret = map.get(position);
            }
        }
        if (name.contains(".")) {
            if (ret == null) {
                throw new UtilsException("Placeholder [{" + key + "}] resolution failed: method [" + o.getClass().getName() + "." + getMethod + "()] return null object");
            }
            return DynamicStringReplace.readValueInObject(key, ret, name.substring((fieldName + ".").length(), name.length()));
        }
        String finalValue = null;
        if (ret != null) {
            if (ret instanceof Date) {
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMdd_HHmmssSSS");
                finalValue = dateformat.format((Date)ret);
            } else {
                if (ret instanceof byte[]) {
                    throw new UtilsException("Placeholder [{" + key + "}] resolution failed: method [" + o.getClass().getName() + "." + getMethod + "()] return object with type [" + ret.getClass().getName() + "]");
                }
                finalValue = ret.toString();
            }
        } else {
            throw new UtilsException("Placeholder [{" + key + "}] resolution failed: method [" + o.getClass().getName() + "." + getMethod + "()] return null object");
        }
        return finalValue;
    }
}

