/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.utils;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import it.link.pdd.tools.migrazione_govway.utils.resources.PropertiesReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.WSPasswordCallback;

public class ExternalPWCallback
implements CallbackHandler {
    private static String propertiesFilePath = "/etc/openspcoop2/wssPassword.properties";
    private static Properties wssProperties = null;
    private static String wssRefreshProps = "refresh";
    private static boolean wssRefresh = true;
    private static Date wssRead = null;
    private static int wssTime = 60000;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            String key;
            Properties p;
            WSPasswordCallback pc;
            if (callbacks[i] instanceof WSPasswordCallback) {
                pc = (WSPasswordCallback)callbacks[i];
                Properties pSource = null;
                try {
                    pSource = ExternalPWCallback.getProperties();
                }
                catch (Exception e) {
                    throw new UnsupportedCallbackException(callbacks[i], "Identifier [" + pc.getIdentifier() + "], occurs error (read password from properties file): " + e.getMessage());
                }
                PropertiesReader pr = new PropertiesReader(pSource, true);
                p = null;
                try {
                    p = pr.readProperties_convertEnvProperties("user.", true);
                }
                catch (Exception e) {
                    throw new UnsupportedCallbackException(callbacks[i], "Identifier [" + pc.getIdentifier() + "], occurs error (read password from properties file): " + e.getMessage());
                }
                key = pc.getIdentifier();
                if (!p.containsKey(key)) {
                    if (p.size() > 0) {
                        for (Object keyCheck : p.keySet()) {
                            String tmp;
                            if (!(keyCheck instanceof String) || !(tmp = (String)keyCheck).toLowerCase().equals(key)) continue;
                            key = tmp;
                        }
                    }
                    if (key == null) {
                        throw new UnsupportedCallbackException(callbacks[i], "Identifier [" + pc.getIdentifier() + "] unknown");
                    }
                }
            } else {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            String password = p.getProperty(key);
            pc.setPassword(password);
        }
    }

    public static synchronized void initialize() throws SecurityException {
        ExternalPWCallback.initialize(propertiesFilePath);
    }

    public static synchronized void initialize(String path) throws SecurityException {
        propertiesFilePath = path;
        if (wssProperties == null || ExternalPWCallback.isScaduto()) {
            FileInputStream fin = null;
            try {
                File f = new File(path);
                if (!f.exists()) {
                    throw new SecurityException("File properties [" + path + "] doesn't exists");
                }
                if (!f.canRead()) {
                    throw new SecurityException("File properties [" + path + "] cannot read");
                }
                fin = new FileInputStream(f);
                wssProperties = new Properties();
                wssProperties.load(fin);
                if (wssProperties.containsKey(wssRefreshProps)) {
                    String tmp = wssProperties.getProperty(wssRefreshProps);
                    wssRefresh = "true".equalsIgnoreCase(tmp.trim());
                }
                if (wssRefresh) {
                    wssRead = DateManager.getDate();
                }
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SecurityException("Errore durante la lettura del file properties [" + path + "]: " + e.getMessage(), e);
            }
            finally {
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Properties getProperties() throws SecurityException {
        if (wssProperties == null || ExternalPWCallback.isScaduto()) {
            ExternalPWCallback.initialize();
        }
        return wssProperties;
    }

    private static boolean isScaduto() {
        boolean scaduto = false;
        if (wssRefresh && wssRead != null) {
            long read = wssRead.getTime();
            Date now = DateManager.getDate();
            long diff = now.getTime() - read;
            if (diff > (long)wssTime) {
                scaduto = true;
            }
        }
        return scaduto;
    }
}

