/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.wss4j;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.AttachmentProcessingPart;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.regexp.RegularExpressionEngine;
import it.link.pdd.tools.migrazione_govway.utils.resources.InputStreamDataSource;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.UnsupportedDataTypeException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.message.Attachment;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSUtilities {
    public static void printWSResult(Logger log, List<?> results) {
        if (results != null) {
            for (Object object : results) {
                if (!(object instanceof WSHandlerResult)) continue;
                WSHandlerResult wsResult = (WSHandlerResult)object;
                log.debug("Actor [" + wsResult.getActor() + "]");
                List wsResultList = wsResult.getResults();
                if (wsResultList == null) continue;
                for (int i = 0; i < wsResultList.size(); ++i) {
                    log.debug("WSResult[" + i + "]=" + ((WSSecurityEngineResult)wsResultList.get(i)).toString());
                }
            }
        }
    }

    public static List<Attachment> readAttachments(List<String> cidAttachmentsForSecurity, OpenSPCoop2Message message) throws Exception {
        ArrayList<Attachment> listAttachments = null;
        if (cidAttachmentsForSecurity != null && cidAttachmentsForSecurity.size() > 0) {
            listAttachments = new ArrayList<Attachment>();
            for (String cid : cidAttachmentsForSecurity) {
                MimeHeaders mhs = new MimeHeaders();
                mhs.addHeader("Content-ID", cid);
                Iterator<?> itAttach = message.getAttachments(mhs);
                if (itAttach == null) {
                    throw new Exception("Attachment with Content-ID [" + cid + "] not found");
                }
                AttachmentPart ap = (AttachmentPart)itAttach.next();
                if (ap == null) {
                    throw new Exception("Attachment with Content-ID [" + cid + "] not found");
                }
                listAttachments.add(WSSUtilities.convertToCxfAttachment(ap));
            }
        }
        return listAttachments;
    }

    public static List<Attachment> readAttachments(AttachmentProcessingPart app, OpenSPCoop2Message message) throws Exception {
        Object listApDaTrattare;
        ArrayList<Attachment> listAttachments = null;
        if (app != null && (listApDaTrattare = app.getOutput(message)) != null && listApDaTrattare.size() > 0) {
            listAttachments = new ArrayList<Attachment>();
            for (int i = 0; i < listApDaTrattare.size(); ++i) {
                AttachmentPart ap = (AttachmentPart)listApDaTrattare.get(i);
                listAttachments.add(WSSUtilities.convertToCxfAttachment(ap));
            }
        }
        return listAttachments;
    }

    private static Attachment convertToCxfAttachment(AttachmentPart ap) throws Exception {
        DataHandler dh = ap.getDataHandler();
        DataHandler dhNEW = null;
        byte[] bufferArray = null;
        String s = null;
        if (dh.getContentType() != null && dh.getContentType().startsWith("text/plain")) {
            dhNEW = dh;
        } else if (RegularExpressionEngine.isMatch(dh.getContentType(), ".*\\/xml") || RegularExpressionEngine.isMatch(dh.getContentType(), ".*\\+xml")) {
            dhNEW = dh;
        } else {
            try {
                InputStreamDataSource isds = new InputStreamDataSource(ap.getContentId(), dh.getContentType(), dh.getInputStream());
                dhNEW = new DataHandler((DataSource)isds);
            }
            catch (UnsupportedDataTypeException edtx) {
                Object o = dh.getContent();
                if (o != null) {
                    if (o instanceof String) {
                        s = (String)o;
                        dhNEW = new DataHandler((Object)s, dh.getContentType());
                    }
                    if (o instanceof byte[]) {
                        bufferArray = (byte[])o;
                        InputStreamDataSource isds = new InputStreamDataSource(ap.getContentId(), dh.getContentType(), bufferArray);
                        dhNEW = new DataHandler((DataSource)isds);
                    }
                    if (o instanceof InputStream) {
                        InputStreamDataSource isds = new InputStreamDataSource(ap.getContentId(), dh.getContentType(), (InputStream)o);
                        dhNEW = new DataHandler((DataSource)isds);
                    }
                    throw new Exception("Attach [" + ap.getContentId() + "] [" + dh.getContentType() + "] with type not supported: " + o.getClass().getName(), edtx);
                }
                throw new Exception("Attach [" + ap.getContentId() + "] [" + dh.getContentType() + "] error: " + edtx.getMessage(), edtx);
            }
        }
        AttachmentImpl at = new AttachmentImpl(StringEscapeUtils.escapeXml((String)ap.getContentId()), dhNEW);
        return at;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateAttachments(List<Attachment> listAttachments, OpenSPCoop2Message message) throws Exception {
        if (listAttachments == null || listAttachments.size() <= 0) return;
        for (Attachment attachmentPart : listAttachments) {
            Object o;
            MimeHeaders mhs = new MimeHeaders();
            mhs.addHeader("Content-ID", StringEscapeUtils.unescapeXml((String)attachmentPart.getId()));
            AttachmentPart ap = (AttachmentPart)message.getAttachments(mhs).next();
            DataHandler dh = attachmentPart.getDataHandler();
            byte[] bufferArray = null;
            String s = null;
            if (dh.getContentType() != null && dh.getContentType().startsWith("text/plain")) {
                o = dh.getContent();
                if (o instanceof String) {
                    s = (String)o;
                    message.updateAttachmentPart(ap, s, dh.getContentType());
                    continue;
                }
                if (o instanceof byte[]) {
                    bufferArray = (byte[])o;
                    message.updateAttachmentPart(ap, bufferArray, dh.getContentType());
                    continue;
                }
                if (!(o instanceof InputStream)) throw new Exception("Attach-Plain [" + attachmentPart.getId() + "] [" + dh.getContentType() + "] with type not supported: " + o.getClass().getName());
                bufferArray = Utilities.getAsByteArray((InputStream)o);
                message.updateAttachmentPart(ap, bufferArray, dh.getContentType());
                continue;
            }
            if (RegularExpressionEngine.isMatch(dh.getContentType(), ".*\\/xml") || RegularExpressionEngine.isMatch(dh.getContentType(), ".*\\+xml")) {
                o = dh.getContent();
                boolean testXml = false;
                boolean updated = false;
                Element n = null;
                if (o instanceof String) {
                    s = (String)o;
                    message.updateAttachmentPart(ap, s, dh.getContentType());
                    updated = true;
                } else if (o instanceof byte[]) {
                    bufferArray = (byte[])o;
                    testXml = true;
                } else if (o instanceof InputStream) {
                    bufferArray = Utilities.getAsByteArray((InputStream)o);
                    testXml = true;
                } else if (!(o instanceof Node)) {
                    throw new Exception("Attach-XML [" + attachmentPart.getId() + "] [" + dh.getContentType() + "] with type not supported: " + o.getClass().getName());
                }
                if (testXml) {
                    try {
                        if (n == null) {
                            n = XMLUtils.getInstance().newElement(bufferArray);
                        }
                    }
                    catch (Exception e) {
                        message.updateAttachmentPart(ap, bufferArray, dh.getContentType());
                        updated = true;
                    }
                }
                if (updated) continue;
                DOMSource streamSource = new DOMSource(n);
                DataHandler newDH = new DataHandler((Object)streamSource, dh.getContentType());
                message.updateAttachmentPart(ap, newDH);
                continue;
            }
            try {
                InputStreamDataSource isds = new InputStreamDataSource(attachmentPart.getId(), dh.getContentType(), dh.getInputStream());
                DataHandler dhNEW = new DataHandler((DataSource)isds);
                message.updateAttachmentPart(ap, dhNEW);
            }
            catch (UnsupportedDataTypeException edtx) {
                InputStreamDataSource isds;
                Object o2 = dh.getContent();
                DataHandler dhNEW = null;
                if (o2 == null) throw new Exception("Attach [" + ap.getContentId() + "] [" + dh.getContentType() + "] error: " + edtx.getMessage(), edtx);
                if (o2 instanceof String) {
                    s = (String)o2;
                    dhNEW = new DataHandler((Object)s, dh.getContentType());
                } else if (o2 instanceof byte[]) {
                    bufferArray = (byte[])o2;
                    isds = new InputStreamDataSource(attachmentPart.getId(), dh.getContentType(), bufferArray);
                    dhNEW = new DataHandler((DataSource)isds);
                } else {
                    if (!(o2 instanceof InputStream)) throw new Exception("Attach [" + ap.getContentId() + "] [" + dh.getContentType() + "] with type not supported: " + o2.getClass().getName(), edtx);
                    isds = new InputStreamDataSource(attachmentPart.getId(), dh.getContentType(), (InputStream)o2);
                    dhNEW = new DataHandler((DataSource)isds);
                }
                message.updateAttachmentPart(ap, dhNEW);
            }
        }
    }
}

