/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.wss4j;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.IMessageSecuritySender;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityContext;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.saml.SAMLBuilderConfig;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.saml.SAMLCallbackHandler;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.AttachmentProcessingPart;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.AttachmentsConfigReaderUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.wss4j.WSSUtilities;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.wss4j.common.ext.WSSecurityException;

public class MessageSecuritySender_wss4j
implements IMessageSecuritySender {
    @Override
    public void process(MessageSecurityContext wssContext, OpenSPCoop2Message message) throws SecurityException {
        try {
            WSS4JOutInterceptor ohandler = new WSS4JOutInterceptor();
            WSS4JOutInterceptor.WSS4JOutInterceptorInternal handler = ohandler.createEndingInterceptor();
            SoapMessage msgCtx = new SoapMessage((Message)new MessageImpl());
            ExchangeImpl ex = new ExchangeImpl();
            ex.setInMessage((Message)msgCtx);
            msgCtx.setContent(SOAPMessage.class, (Object)message);
            ArrayList results = new ArrayList();
            msgCtx.put("RECV_RESULTS", results);
            AttachmentProcessingPart app = AttachmentsConfigReaderUtils.getSecurityOnAttachments(wssContext);
            this.setOutgoingProperties(wssContext, msgCtx);
            List<Attachment> listAttachments = null;
            if (app != null && (listAttachments = WSSUtilities.readAttachments(app, message)) != null && listAttachments.size() > 0) {
                msgCtx.setAttachments(listAttachments);
            }
            handler.handleMessage((Message)msgCtx);
            wssContext.getLog().debug("Print wssSender results...");
            WSSUtilities.printWSResult(wssContext.getLog(), results);
            WSSUtilities.updateAttachments(listAttachments, message);
        }
        catch (Exception e) {
            Throwable t;
            String msg = Utilities.getInnerNotEmptyMessageException(e).getMessage();
            Throwable innerExc = Utilities.getLastInnerException(e);
            String innerMsg = null;
            if (innerExc != null) {
                innerMsg = innerExc.getMessage();
            }
            Object messaggio = null;
            if (msg != null) {
                messaggio = new String(msg);
                if (innerMsg != null && !innerMsg.equals(msg)) {
                    messaggio = (String)messaggio + " ; " + innerMsg;
                }
            } else if (innerMsg != null) {
                messaggio = innerMsg;
            }
            if (Utilities.existsInnerException((Throwable)e, WSSecurityException.class) && (t = Utilities.getLastInnerException(e)) instanceof WSSecurityException) {
                messaggio = messaggio != null ? (String)messaggio + " ; " + t.getMessage() : t.getMessage();
            }
            SecurityException wssException = new SecurityException(e.getMessage(), e);
            wssException.setMsgErrore((String)messaggio);
            throw wssException;
        }
    }

    private void setOutgoingProperties(MessageSecurityContext wssContext, SoapMessage msgCtx) throws Exception {
        boolean mustUnderstand = false;
        Hashtable<String, Object> wssOutgoingProperties = wssContext.getOutgoingProperties();
        if (wssOutgoingProperties != null && wssOutgoingProperties.size() > 0) {
            Enumeration<String> e = wssOutgoingProperties.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                String value = (String)wssOutgoingProperties.get(key);
                if (!"encryptionUser".equals(key) || "useReqSigCert".equals(value)) {
                    // empty if block
                }
                if ("samlPropFile".equals(key)) {
                    SAMLBuilderConfig config = SAMLBuilderConfig.getSamlConfig(value);
                    SAMLCallbackHandler samlCallbackHandler = new SAMLCallbackHandler(config);
                    msgCtx.put("samlCallbackRef", (Object)samlCallbackHandler);
                    continue;
                }
                if ("encryptionParts".equals(key) || "signatureParts".equals(key)) {
                    msgCtx.put(key, (Object)this.normalizeWss4jParts(value));
                    continue;
                }
                msgCtx.put(key, (Object)value);
                if (!"mustUnderstand".equals(key)) continue;
                mustUnderstand = true;
            }
        }
        if (!mustUnderstand) {
            msgCtx.put("mustUnderstand", (Object)"false");
        }
        if (wssContext.getActor() != null) {
            msgCtx.put("actor", (Object)wssContext.getActor());
        }
    }

    private String normalizeWss4jParts(String parts) {
        StringBuffer bf = new StringBuffer();
        String[] split = parts.split(";");
        for (int i = 0; i < split.length; ++i) {
            String n;
            if (i > 0) {
                bf.append(";");
            }
            if ((n = split[i].trim()).contains("{Attach}")) {
                if (n.startsWith("{Element}")) {
                    bf.append("{Element}cid:Attachments");
                    continue;
                }
                bf.append("{Content}cid:Attachments");
                continue;
            }
            bf.append(n);
        }
        return bf.toString();
    }
}

