/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.wss4j;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.reference.Reference;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.IMessageSecurityReceiver;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityContext;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.SubErrorCodeSecurity;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.constants.SecurityConstants;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.engine.MessageUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.AttachmentProcessingPart;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.AttachmentsConfigReaderUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.wss4j.WSSUtilities;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;

public class MessageSecurityReceiver_wss4j
implements IMessageSecurityReceiver {
    private String certificate;

    @Override
    public void process(MessageSecurityContext wssContext, OpenSPCoop2Message message, Busta busta) throws SecurityException {
        try {
            WSS4JInInterceptor inHandler = new WSS4JInInterceptor();
            SoapMessage msgCtx = new SoapMessage((Message)new MessageImpl());
            ExchangeImpl ex = new ExchangeImpl();
            ex.setInMessage((Message)msgCtx);
            msgCtx.setContent(SOAPMessage.class, (Object)message);
            this.setIncomingProperties(wssContext, inHandler, msgCtx);
            AttachmentProcessingPart app = AttachmentsConfigReaderUtils.getSecurityOnAttachments(wssContext);
            List<Attachment> listAttachments = null;
            if (app != null) {
                if (!app.isAllAttachments()) {
                    List<String> cidAttachmentsForSecurity = AttachmentsConfigReaderUtils.getListCIDAttachmentsForSecurity(wssContext);
                    listAttachments = WSSUtilities.readAttachments(cidAttachmentsForSecurity, message);
                } else {
                    listAttachments = WSSUtilities.readAttachments(app, message);
                }
                if (listAttachments != null && listAttachments.size() > 0) {
                    msgCtx.setAttachments(listAttachments);
                }
            }
            inHandler.handleMessage(msgCtx);
            List results = (List)msgCtx.getContextualProperty("RECV_RESULTS");
            wssContext.getLog().debug("Print wssRecever results...");
            WSSUtilities.printWSResult(wssContext.getLog(), results);
            WSSUtilities.updateAttachments(listAttachments, message);
            this.certificate = this.getPrincipal(msgCtx, wssContext.getActor());
        }
        catch (Exception e) {
            SecurityException wssException = new SecurityException(e.getMessage(), e);
            String msg = Utilities.getInnerNotEmptyMessageException(e).getMessage();
            Throwable innerExc = Utilities.getLastInnerException(e);
            String innerMsg = null;
            if (innerExc != null) {
                innerMsg = innerExc.getMessage();
            }
            Object messaggio = null;
            if (msg != null) {
                messaggio = new String(msg);
                if (innerMsg != null && !innerMsg.equals(msg)) {
                    messaggio = (String)messaggio + " ; " + innerMsg;
                }
            } else if (innerMsg != null) {
                messaggio = innerMsg;
            }
            wssException.setMsgErrore((String)messaggio);
            boolean signature = false;
            boolean encrypt = false;
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(bout);
                e.printStackTrace(printStream);
                bout.flush();
                printStream.flush();
                bout.close();
                printStream.close();
                if (bout.toString().contains(".processor.SignatureProcessor")) {
                    signature = true;
                } else if (bout.toString().contains(".processor.SignatureConfirmationProcessor")) {
                    signature = true;
                } else if (bout.toString().contains(".processor.EncryptedKeyProcessor")) {
                    encrypt = true;
                } else if (bout.toString().contains(".processor.EncryptedDataProcessor")) {
                    encrypt = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (signature) {
                wssException.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA);
            } else if (encrypt) {
                wssException.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA_CIFRATURA_NON_VALIDA);
            } else if (Utilities.existsInnerMessageException(e, "The signature or decryption was invalid", true)) {
                wssException.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA);
            } else {
                wssException.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA);
            }
            throw wssException;
        }
    }

    @Override
    public String getCertificate() throws SecurityException {
        return this.certificate;
    }

    private void setIncomingProperties(MessageSecurityContext wssContext, WSS4JInInterceptor interceptor, SoapMessage msgCtx) {
        Hashtable<String, Object> wssIncomingProperties = wssContext.getIncomingProperties();
        if (wssIncomingProperties != null && wssIncomingProperties.size() > 0) {
            Enumeration<String> e = wssIncomingProperties.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                String value = (String)wssIncomingProperties.get(key);
                msgCtx.put(key, (Object)value);
                interceptor.setProperty(key, value);
            }
        }
        if (wssContext.getActor() != null) {
            interceptor.setProperty("actor", wssContext.getActor());
            msgCtx.put("actor", (Object)wssContext.getActor());
        }
    }

    private String getPrincipal(SoapMessage msgCtx, String actor) {
        String principal = null;
        List results = (List)msgCtx.get((Object)"RECV_RESULTS");
        for (int i = 0; results != null && i < results.size(); ++i) {
            int actionGet;
            WSSecurityEngineResult eResult;
            int j;
            List hResults;
            WSHandlerResult hResult = (WSHandlerResult)results.get(i);
            if (actor != null) {
                if (hResult.getActor().compareTo(actor) != 0) continue;
                hResults = hResult.getResults();
                for (j = 0; j < hResults.size(); ++j) {
                    eResult = (WSSecurityEngineResult)hResults.get(j);
                    actionGet = (Integer)eResult.get((Object)"action");
                    if (actionGet != 2 && actionGet != 1 && actionGet != 16) continue;
                    principal = ((Principal)eResult.get((Object)"principal")).getName();
                }
                continue;
            }
            hResults = hResult.getResults();
            for (j = 0; j < hResults.size(); ++j) {
                eResult = (WSSecurityEngineResult)hResults.get(j);
                actionGet = (Integer)eResult.get((Object)"action");
                if (actionGet != 2 && actionGet != 1 && actionGet != 16) continue;
                principal = ((Principal)eResult.get((Object)"principal")).getName();
            }
        }
        return principal;
    }

    @Override
    public List<Reference> getDirtyElements(MessageSecurityContext messageSecurityContext, OpenSPCoop2Message message) throws SecurityException {
        return it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.engine.WSSUtilities.getDirtyElements(messageSecurityContext, message);
    }

    @Override
    public Map<QName, QName> checkEncryptSignatureParts(MessageSecurityContext messageSecurityContext, List<Reference> elementsToClean, OpenSPCoop2Message message, List<SubErrorCodeSecurity> codiciErrore) throws SecurityException {
        return MessageUtilities.checkEncryptSignatureParts(messageSecurityContext, elementsToClean, message, codiciErrore, SecurityConstants.QNAME_WSS_ELEMENT_SECURITY);
    }

    @Override
    public void checkEncryptionPartElements(Map<QName, QName> notResolved, OpenSPCoop2Message message, List<SubErrorCodeSecurity> erroriRilevati) throws SecurityException {
        MessageUtilities.checkEncryptionPartElements(notResolved, message, erroriRilevati);
    }

    @Override
    public void cleanDirtyElements(MessageSecurityContext messageSecurityContext, OpenSPCoop2Message message, List<Reference> elementsToClean, boolean detachHeaderWSSecurity, boolean removeAllIdRef) throws SecurityException {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.engine.WSSUtilities.cleanDirtyElements(messageSecurityContext, message, elementsToClean, detachHeaderWSSecurity, removeAllIdRef);
    }
}

