/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.wss4j;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.IMessageSecurityContext;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityContext;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.WsuIdAllocator;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.slf4j.Logger;

public class MessageSecurityContext_wss4j
implements IMessageSecurityContext {
    private Logger log = null;
    private static org.apache.wss4j.dom.WsuIdAllocator wsuIdAllocator = null;
    private static String prefixWsuId = null;

    @Override
    public void init(MessageSecurityContext wssContext) throws SecurityException {
        this.log = wssContext.getLog();
        try {
            MessageSecurityContext_wss4j.initWsuIdAllocator(wssContext.getPrefixWsuId(), this.log);
        }
        catch (Exception e) {
            this.log.error("Inizializzazione wsu id allocator non riuscita: " + e.getMessage(), (Throwable)e);
            throw new SecurityException(e.getMessage(), e);
        }
    }

    private static synchronized void initWsuIdAllocator(String prefixWsuIdParam, Logger log) throws Exception {
        if (wsuIdAllocator == null) {
            WSSConfig config = WSSConfig.getNewInstance();
            prefixWsuId = prefixWsuIdParam;
            if (prefixWsuIdParam == null || "".equals(prefixWsuIdParam)) {
                wsuIdAllocator = config.getIdAllocator();
            } else {
                wsuIdAllocator = new WsuIdAllocator(prefixWsuIdParam);
                config.setIdAllocator(wsuIdAllocator);
            }
            log.info("WsuIdAllocator=" + config.getIdAllocator().getClass().getName());
        } else {
            if (prefixWsuId == null) {
                throw new Exception("WsuIdAllocator istanziato con la classe [" + wsuIdAllocator.getClass().getName() + "] e variabile prefixWsuId non istanziata??");
            }
            if (!prefixWsuId.equals(prefixWsuIdParam)) {
                throw new Exception("WsuIdAllocator gia' istanziato con la classe [" + wsuIdAllocator.getClass().getName() + "] e variabile prefixWsuId uguale al valore [" + prefixWsuId + "]. Nuovo valore [" + prefixWsuIdParam + "] non impostabile.");
            }
        }
    }
}

