/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.MerlinKeystore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.MerlinTruststore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.MultiKeystore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.SymmetricKeystore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.cache.GestoreKeystoreCache;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityContext;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.EncryptionBean;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.SignatureBean;
import java.security.KeyStore;

public class KeystoreUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EncryptionBean getSenderEncryptionBean(MessageSecurityContext messageSecurityContext) throws Exception {
        KeyStore encryptionKS = null;
        KeyStore encryptionTrustStoreKS = null;
        boolean encryptionSymmetric = false;
        String aliasEncryptUser = null;
        String aliasEncryptPassword = null;
        aliasEncryptUser = (String)messageSecurityContext.getOutgoingProperties().get("encryptionUser");
        if (aliasEncryptUser == null && (aliasEncryptUser = (String)messageSecurityContext.getOutgoingProperties().get("user")) == null) {
            throw new Exception("encryptionUser/user non fornita");
        }
        Object encryptionSymmetricObject = messageSecurityContext.getOutgoingProperties().get("encryptionSymmetricKey");
        if (encryptionSymmetricObject != null) {
            encryptionSymmetric = "true".equals(encryptionSymmetricObject);
        }
        String encryptionTrustStore = (String)messageSecurityContext.getOutgoingProperties().get("encryptionTrustStorePropFile");
        String encryptionStore = (String)messageSecurityContext.getOutgoingProperties().get("encryptionPropFile");
        String multiEncryptionStore = (String)messageSecurityContext.getOutgoingProperties().get("encryptionMultiPropFile");
        String encryptionSymmetricKeyValue = null;
        if (encryptionSymmetric) {
            encryptionSymmetricKeyValue = (String)messageSecurityContext.getOutgoingProperties().get("encryptionSymmetricKeyValue");
        }
        if (encryptionTrustStore != null) {
            MerlinTruststore merlinTruststore = GestoreKeystoreCache.getMerlinTruststore(encryptionTrustStore);
            encryptionTrustStoreKS = merlinTruststore.getTrustStore();
        }
        if (encryptionStore != null) {
            aliasEncryptPassword = (String)messageSecurityContext.getOutgoingProperties().get("encryptionPassword");
            if (aliasEncryptPassword == null) {
                throw new Exception("encryptionPassword non fornita");
            }
            MerlinKeystore merlinKeystore = GestoreKeystoreCache.getMerlinKeystore(encryptionStore, aliasEncryptPassword);
            encryptionKS = merlinKeystore.getKeyStore();
        } else if (multiEncryptionStore != null) {
            MultiKeystore multiKeystore = GestoreKeystoreCache.getMultiKeystore(multiEncryptionStore);
            if ("#MultiPropUseFruitoreAsAlias#".equals(aliasEncryptUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getNome() != null) {
                String fruitore = messageSecurityContext.getIdFruitore().getNome();
                encryptionKS = multiKeystore.getKeyStore(fruitore);
                aliasEncryptUser = multiKeystore.getKeyAlias(fruitore);
                aliasEncryptPassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUseErogatoreAsAlias#".equals(aliasEncryptUser) && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome() != null) {
                String erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome();
                encryptionKS = multiKeystore.getKeyStore(erogatore);
                aliasEncryptUser = multiKeystore.getKeyAlias(erogatore);
                aliasEncryptPassword = multiKeystore.getKeyPassword(erogatore);
            } else if ("#MultiPropUseFruitoreErogatoreAsAlias#".equals(aliasEncryptUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getNome() != null && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome() != null) {
                String fruitore = messageSecurityContext.getIdFruitore().getNome();
                String erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome();
                String aliasFR_ER = fruitore + "-" + erogatore;
                String aliasER_FR = erogatore + "-" + fruitore;
                if (multiKeystore.existsAlias(aliasFR_ER)) {
                    encryptionKS = multiKeystore.getKeyStore(aliasFR_ER);
                    aliasEncryptUser = multiKeystore.getKeyAlias(aliasFR_ER);
                    aliasEncryptPassword = multiKeystore.getKeyPassword(aliasFR_ER);
                } else {
                    if (!multiKeystore.existsAlias(aliasER_FR)) throw new Exception("Alias [" + aliasFR_ER + "] o [" + aliasER_FR + "] non trovato nella configurazione MultiKeystore");
                    encryptionKS = multiKeystore.getKeyStore(aliasER_FR);
                    aliasEncryptUser = multiKeystore.getKeyAlias(aliasER_FR);
                    aliasEncryptPassword = multiKeystore.getKeyPassword(aliasER_FR);
                }
            } else if ("#MultiPropUsePddFruitoreAsAlias#".equals(aliasEncryptUser) && messageSecurityContext.getPddFruitore() != null) {
                String fruitore = messageSecurityContext.getPddFruitore();
                encryptionKS = multiKeystore.getKeyStore(fruitore);
                aliasEncryptUser = multiKeystore.getKeyAlias(fruitore);
                aliasEncryptPassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUsePddErogatoreAsAlias#".equals(aliasEncryptUser) && messageSecurityContext.getPddErogatore() != null) {
                String erogatore = messageSecurityContext.getPddErogatore();
                encryptionKS = multiKeystore.getKeyStore(erogatore);
                aliasEncryptUser = multiKeystore.getKeyAlias(erogatore);
                aliasEncryptPassword = multiKeystore.getKeyPassword(erogatore);
            } else if ("#MultiPropUseIdentificativoPortaFruitoreAsAlias#".equals(aliasEncryptUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getCodicePorta() != null) {
                String fruitore = messageSecurityContext.getIdFruitore().getCodicePorta();
                encryptionKS = multiKeystore.getKeyStore(fruitore);
                aliasEncryptUser = multiKeystore.getKeyAlias(fruitore);
                aliasEncryptPassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUseIdentificativoPortaErogatoreAsAlias#".equals(aliasEncryptUser) && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getCodicePorta() != null) {
                String erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getCodicePorta();
                encryptionKS = multiKeystore.getKeyStore(erogatore);
                aliasEncryptUser = multiKeystore.getKeyAlias(erogatore);
                aliasEncryptPassword = multiKeystore.getKeyPassword(erogatore);
            } else {
                encryptionKS = multiKeystore.getKeyStore(aliasEncryptUser);
                aliasEncryptPassword = multiKeystore.getKeyPassword(aliasEncryptUser);
                aliasEncryptUser = multiKeystore.getKeyAlias(aliasEncryptUser);
            }
        } else {
            if (encryptionSymmetricKeyValue == null) throw new Exception("Nessuna modalita' di recupero del Keystore per la funzionalita' di Encryption indicata");
            Object encryptionSymmetricAlgoritm = messageSecurityContext.getOutgoingProperties().get("encryptionSymAlgorithm");
            if (encryptionSymmetricAlgoritm == null) {
                throw new Exception("E' stata indicata una funzionalita' di encrypt con chiave simmetrica fornita direttamente nelle proprieta' [encryptionSymmetricKeyValue=" + encryptionSymmetricKeyValue + "], ma non e' stato indicato l'algoritmo associato tramite la proprieta' encryptionSymAlgorithm");
            }
            SymmetricKeystore symmetricKeystore = GestoreKeystoreCache.getSymmetricKeystore(aliasEncryptUser, encryptionSymmetricKeyValue, (String)encryptionSymmetricAlgoritm);
            encryptionKS = symmetricKeystore.getKeyStore();
            aliasEncryptPassword = symmetricKeystore.getPasswordKey();
        }
        EncryptionBean bean = new EncryptionBean();
        bean.setKeystore(encryptionKS);
        bean.setTruststore(encryptionTrustStoreKS);
        bean.setUser(aliasEncryptUser);
        bean.setPassword(aliasEncryptPassword);
        bean.setEncryptionSimmetric(encryptionSymmetric);
        return bean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EncryptionBean getReceiverEncryptionBean(MessageSecurityContext messageSecurityContext) throws Exception {
        KeyStore decryptionKS = null;
        KeyStore decryptionTrustStoreKS = null;
        String aliasDecryptUser = null;
        String aliasDecryptPassword = null;
        boolean decryptionSymmetric = false;
        aliasDecryptUser = (String)messageSecurityContext.getIncomingProperties().get("decryptionUser");
        if (aliasDecryptUser == null && (aliasDecryptUser = (String)messageSecurityContext.getIncomingProperties().get("user")) == null) {
            throw new Exception("decryptionUser/user non fornita");
        }
        Object decryptionSymmetricObject = messageSecurityContext.getIncomingProperties().get("decryptionSymmetricKey");
        if (decryptionSymmetricObject != null) {
            decryptionSymmetric = "true".equals(decryptionSymmetricObject);
        }
        String decryptionTrustStore = (String)messageSecurityContext.getIncomingProperties().get("decryptionTrustStorePropFile");
        String decryptionStore = (String)messageSecurityContext.getIncomingProperties().get("decryptionPropFile");
        String multiDecryptionStore = (String)messageSecurityContext.getIncomingProperties().get("decryptionMultiPropFile");
        String decryptionSymmetricKeyValue = null;
        if (decryptionSymmetric) {
            decryptionSymmetricKeyValue = (String)messageSecurityContext.getIncomingProperties().get("decryptionSymmetricKeyValue");
        }
        if (decryptionTrustStore != null) {
            MerlinTruststore merlinTruststore = GestoreKeystoreCache.getMerlinTruststore(decryptionTrustStore);
            decryptionTrustStoreKS = merlinTruststore.getTrustStore();
        }
        if (decryptionStore != null) {
            aliasDecryptPassword = (String)messageSecurityContext.getIncomingProperties().get("decryptionPassword");
            if (aliasDecryptPassword == null) {
                throw new Exception("decryptionPassword non fornita");
            }
            MerlinKeystore merlinKeystore = GestoreKeystoreCache.getMerlinKeystore(decryptionStore, aliasDecryptPassword);
            decryptionKS = merlinKeystore.getKeyStore();
        } else if (multiDecryptionStore != null) {
            MultiKeystore multiKeystore = GestoreKeystoreCache.getMultiKeystore(multiDecryptionStore);
            if ("#MultiPropUseFruitoreAsAlias#".equals(aliasDecryptUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getNome() != null) {
                String fruitore = messageSecurityContext.getIdFruitore().getNome();
                decryptionKS = multiKeystore.getKeyStore(fruitore);
                aliasDecryptUser = multiKeystore.getKeyAlias(fruitore);
                aliasDecryptPassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUseErogatoreAsAlias#".equals(aliasDecryptUser) && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome() != null) {
                String erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome();
                decryptionKS = multiKeystore.getKeyStore(erogatore);
                aliasDecryptUser = multiKeystore.getKeyAlias(erogatore);
                aliasDecryptPassword = multiKeystore.getKeyPassword(erogatore);
            } else if ("#MultiPropUseFruitoreErogatoreAsAlias#".equals(aliasDecryptUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getNome() != null && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome() != null) {
                String fruitore = messageSecurityContext.getIdFruitore().getNome();
                String erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome();
                String aliasFR_ER = fruitore + "-" + erogatore;
                String aliasER_FR = erogatore + "-" + fruitore;
                if (multiKeystore.existsAlias(aliasFR_ER)) {
                    decryptionKS = multiKeystore.getKeyStore(aliasFR_ER);
                    aliasDecryptUser = multiKeystore.getKeyAlias(aliasFR_ER);
                    aliasDecryptPassword = multiKeystore.getKeyPassword(aliasFR_ER);
                } else {
                    if (!multiKeystore.existsAlias(aliasER_FR)) throw new Exception("Alias [" + aliasFR_ER + "] o [" + aliasER_FR + "] non trovato nella configurazione MultiKeystore");
                    decryptionKS = multiKeystore.getKeyStore(aliasER_FR);
                    aliasDecryptUser = multiKeystore.getKeyAlias(aliasER_FR);
                    aliasDecryptPassword = multiKeystore.getKeyPassword(aliasER_FR);
                }
            } else if ("#MultiPropUsePddFruitoreAsAlias#".equals(aliasDecryptUser) && messageSecurityContext.getPddFruitore() != null) {
                String fruitore = messageSecurityContext.getPddFruitore();
                decryptionKS = multiKeystore.getKeyStore(fruitore);
                aliasDecryptUser = multiKeystore.getKeyAlias(fruitore);
                aliasDecryptPassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUsePddErogatoreAsAlias#".equals(aliasDecryptUser) && messageSecurityContext.getPddErogatore() != null) {
                String erogatore = messageSecurityContext.getPddErogatore();
                decryptionKS = multiKeystore.getKeyStore(erogatore);
                aliasDecryptUser = multiKeystore.getKeyAlias(erogatore);
                aliasDecryptPassword = multiKeystore.getKeyPassword(erogatore);
            } else if ("#MultiPropUseIdentificativoPortaFruitoreAsAlias#".equals(aliasDecryptUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getCodicePorta() != null) {
                String fruitore = messageSecurityContext.getIdFruitore().getCodicePorta();
                decryptionKS = multiKeystore.getKeyStore(fruitore);
                aliasDecryptUser = multiKeystore.getKeyAlias(fruitore);
                aliasDecryptPassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUseIdentificativoPortaErogatoreAsAlias#".equals(aliasDecryptUser) && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getCodicePorta() != null) {
                String erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getCodicePorta();
                decryptionKS = multiKeystore.getKeyStore(erogatore);
                aliasDecryptUser = multiKeystore.getKeyAlias(erogatore);
                aliasDecryptPassword = multiKeystore.getKeyPassword(erogatore);
            } else {
                decryptionKS = multiKeystore.getKeyStore(aliasDecryptUser);
                aliasDecryptPassword = multiKeystore.getKeyPassword(aliasDecryptUser);
                aliasDecryptUser = multiKeystore.getKeyAlias(aliasDecryptUser);
            }
        } else {
            if (decryptionSymmetricKeyValue == null) throw new Exception("Nessuna modalita' di recupero del Keystore per la funzionalita' di Encryption indicata");
            Object decryptionSymmetricAlgoritm = messageSecurityContext.getIncomingProperties().get("decryptionSymAlgorithm");
            if (decryptionSymmetricAlgoritm == null) {
                throw new Exception("E' stata indicata una funzionalita' di encrypt con chiave simmetrica fornita direttamente nelle proprieta' [decryptionSymmetricKeyValue=" + decryptionSymmetricKeyValue + "], ma non e' stato indicato l'algoritmo associato tramite la proprieta' decryptionSymAlgorithm");
            }
            SymmetricKeystore symmetricKeystore = GestoreKeystoreCache.getSymmetricKeystore(aliasDecryptUser, decryptionSymmetricKeyValue, (String)decryptionSymmetricAlgoritm);
            decryptionKS = symmetricKeystore.getKeyStore();
            aliasDecryptPassword = symmetricKeystore.getPasswordKey();
        }
        EncryptionBean bean = new EncryptionBean();
        bean.setKeystore(decryptionKS);
        bean.setTruststore(decryptionTrustStoreKS);
        bean.setUser(aliasDecryptUser);
        bean.setPassword(aliasDecryptPassword);
        bean.setEncryptionSimmetric(decryptionSymmetric);
        return bean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SignatureBean getSenderSignatureBean(MessageSecurityContext messageSecurityContext) throws Exception {
        KeyStore signatureKS = null;
        KeyStore signatureTrustStoreKS = null;
        String aliasSignatureUser = null;
        String aliasSignaturePassword = null;
        aliasSignatureUser = (String)messageSecurityContext.getOutgoingProperties().get("signatureUser");
        if (aliasSignatureUser == null && (aliasSignatureUser = (String)messageSecurityContext.getOutgoingProperties().get("user")) == null) {
            throw new Exception("signatureUser/user non fornita");
        }
        String signatureTrustStore = (String)messageSecurityContext.getOutgoingProperties().get("signatureTrustStorePropFile");
        String signatureStore = (String)messageSecurityContext.getOutgoingProperties().get("signaturePropFile");
        String multiSignatureStore = (String)messageSecurityContext.getOutgoingProperties().get("signatureMultiPropFile");
        if (signatureTrustStore != null) {
            MerlinTruststore merlinTruststore = GestoreKeystoreCache.getMerlinTruststore(signatureTrustStore);
            signatureTrustStoreKS = merlinTruststore.getTrustStore();
        }
        if (signatureStore != null) {
            aliasSignaturePassword = (String)messageSecurityContext.getOutgoingProperties().get("signaturePassword");
            if (aliasSignaturePassword == null) {
                throw new Exception("signaturePassword non fornita");
            }
            MerlinKeystore merlinKeystore = GestoreKeystoreCache.getMerlinKeystore(signatureStore, aliasSignaturePassword);
            signatureKS = merlinKeystore.getKeyStore();
        } else {
            if (multiSignatureStore == null) throw new Exception("Nessuna modalita' di recupero del Keystore per la funzionalita' di Signature indicata");
            MultiKeystore multiKeystore = GestoreKeystoreCache.getMultiKeystore(multiSignatureStore);
            if ("#MultiPropUseFruitoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getNome() != null) {
                String fruitore = messageSecurityContext.getIdFruitore().getNome();
                signatureKS = multiKeystore.getKeyStore(fruitore);
                aliasSignatureUser = multiKeystore.getKeyAlias(fruitore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUseErogatoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome() != null) {
                String erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome();
                signatureKS = multiKeystore.getKeyStore(erogatore);
                aliasSignatureUser = multiKeystore.getKeyAlias(erogatore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(erogatore);
            } else if ("#MultiPropUseFruitoreErogatoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getNome() != null && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome() != null) {
                String fruitore = messageSecurityContext.getIdFruitore().getNome();
                String erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome();
                String aliasFR_ER = fruitore + "-" + erogatore;
                String aliasER_FR = erogatore + "-" + fruitore;
                if (multiKeystore.existsAlias(aliasFR_ER)) {
                    signatureKS = multiKeystore.getKeyStore(aliasFR_ER);
                    aliasSignatureUser = multiKeystore.getKeyAlias(aliasFR_ER);
                    aliasSignaturePassword = multiKeystore.getKeyPassword(aliasFR_ER);
                } else {
                    if (!multiKeystore.existsAlias(aliasER_FR)) throw new Exception("Alias [" + aliasFR_ER + "] o [" + aliasER_FR + "] non trovato nella configurazione MultiKeystore");
                    signatureKS = multiKeystore.getKeyStore(aliasER_FR);
                    aliasSignatureUser = multiKeystore.getKeyAlias(aliasER_FR);
                    aliasSignaturePassword = multiKeystore.getKeyPassword(aliasER_FR);
                }
            } else if ("#MultiPropUsePddFruitoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getPddFruitore() != null) {
                String fruitore = messageSecurityContext.getPddFruitore();
                signatureKS = multiKeystore.getKeyStore(fruitore);
                aliasSignatureUser = multiKeystore.getKeyAlias(fruitore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUsePddErogatoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getPddErogatore() != null) {
                String erogatore = messageSecurityContext.getPddErogatore();
                signatureKS = multiKeystore.getKeyStore(erogatore);
                aliasSignatureUser = multiKeystore.getKeyAlias(erogatore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(erogatore);
            } else if ("#MultiPropUseIdentificativoPortaFruitoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getCodicePorta() != null) {
                String fruitore = messageSecurityContext.getIdFruitore().getCodicePorta();
                signatureKS = multiKeystore.getKeyStore(fruitore);
                aliasSignatureUser = multiKeystore.getKeyAlias(fruitore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUseIdentificativoPortaErogatoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getCodicePorta() != null) {
                String erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getCodicePorta();
                signatureKS = multiKeystore.getKeyStore(erogatore);
                aliasSignatureUser = multiKeystore.getKeyAlias(erogatore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(erogatore);
            } else {
                signatureKS = multiKeystore.getKeyStore(aliasSignatureUser);
                aliasSignaturePassword = multiKeystore.getKeyPassword(aliasSignatureUser);
                aliasSignatureUser = multiKeystore.getKeyAlias(aliasSignatureUser);
            }
        }
        SignatureBean bean = new SignatureBean();
        bean.setKeystore(signatureKS);
        bean.setTruststore(signatureTrustStoreKS);
        bean.setUser(aliasSignatureUser);
        bean.setPassword(aliasSignaturePassword);
        return bean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SignatureBean getReceiverSignatureBean(MessageSecurityContext messageSecurityContext) throws Exception {
        KeyStore signatureKS = null;
        KeyStore signatureTrustStoreKS = null;
        String aliasSignatureUser = null;
        String aliasSignaturePassword = null;
        String crlPath = null;
        aliasSignatureUser = (String)messageSecurityContext.getIncomingProperties().get("signatureUser");
        if (aliasSignatureUser == null && (aliasSignatureUser = (String)messageSecurityContext.getIncomingProperties().get("user")) == null) {
            throw new Exception("signatureUser/user non fornita");
        }
        crlPath = (String)messageSecurityContext.getIncomingProperties().get("signatureCRL");
        String signatureTrustStore = (String)messageSecurityContext.getIncomingProperties().get("signatureTrustStorePropFile");
        String signatureStore = (String)messageSecurityContext.getIncomingProperties().get("signaturePropFile");
        String multiSignatureStore = (String)messageSecurityContext.getIncomingProperties().get("signatureMultiPropFile");
        if (signatureTrustStore != null) {
            MerlinTruststore merlinTruststore = GestoreKeystoreCache.getMerlinTruststore(signatureTrustStore);
            signatureTrustStoreKS = merlinTruststore.getTrustStore();
        }
        if (signatureStore != null) {
            aliasSignaturePassword = (String)messageSecurityContext.getIncomingProperties().get("signaturePassword");
            if (aliasSignaturePassword == null) {
                throw new Exception("signaturePassword non fornita");
            }
            MerlinKeystore merlinKeystore = GestoreKeystoreCache.getMerlinKeystore(signatureStore, aliasSignaturePassword);
            signatureKS = merlinKeystore.getKeyStore();
        } else {
            if (multiSignatureStore == null) throw new Exception("Nessuna modalita' di recupero del Keystore per la funzionalita' di Signature indicata");
            MultiKeystore multiKeystore = GestoreKeystoreCache.getMultiKeystore(multiSignatureStore);
            if ("#MultiPropUseFruitoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getNome() != null) {
                String fruitore = messageSecurityContext.getIdFruitore().getNome();
                signatureKS = multiKeystore.getKeyStore(fruitore);
                aliasSignatureUser = multiKeystore.getKeyAlias(fruitore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUseErogatoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome() != null) {
                String erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome();
                signatureKS = multiKeystore.getKeyStore(erogatore);
                aliasSignatureUser = multiKeystore.getKeyAlias(erogatore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(erogatore);
            } else if ("#MultiPropUseFruitoreErogatoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getNome() != null && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome() != null) {
                String fruitore = messageSecurityContext.getIdFruitore().getNome();
                String erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome();
                String aliasFR_ER = fruitore + "-" + erogatore;
                String aliasER_FR = erogatore + "-" + fruitore;
                if (multiKeystore.existsAlias(aliasFR_ER)) {
                    signatureKS = multiKeystore.getKeyStore(aliasFR_ER);
                    aliasSignatureUser = multiKeystore.getKeyAlias(aliasFR_ER);
                    aliasSignaturePassword = multiKeystore.getKeyPassword(aliasFR_ER);
                } else {
                    if (!multiKeystore.existsAlias(aliasER_FR)) throw new Exception("Alias [" + aliasFR_ER + "] o [" + aliasER_FR + "] non trovato nella configurazione MultiKeystore");
                    signatureKS = multiKeystore.getKeyStore(aliasER_FR);
                    aliasSignatureUser = multiKeystore.getKeyAlias(aliasER_FR);
                    aliasSignaturePassword = multiKeystore.getKeyPassword(aliasER_FR);
                }
            } else if ("#MultiPropUsePddFruitoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getPddFruitore() != null) {
                String fruitore = messageSecurityContext.getPddFruitore();
                signatureKS = multiKeystore.getKeyStore(fruitore);
                aliasSignatureUser = multiKeystore.getKeyAlias(fruitore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUsePddErogatoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getPddErogatore() != null) {
                String erogatore = messageSecurityContext.getPddErogatore();
                signatureKS = multiKeystore.getKeyStore(erogatore);
                aliasSignatureUser = multiKeystore.getKeyAlias(erogatore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(erogatore);
            } else if ("#MultiPropUseIdentificativoPortaFruitoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getCodicePorta() != null) {
                String fruitore = messageSecurityContext.getIdFruitore().getCodicePorta();
                signatureKS = multiKeystore.getKeyStore(fruitore);
                aliasSignatureUser = multiKeystore.getKeyAlias(fruitore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUseIdentificativoPortaErogatoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getCodicePorta() != null) {
                String erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getCodicePorta();
                signatureKS = multiKeystore.getKeyStore(erogatore);
                aliasSignatureUser = multiKeystore.getKeyAlias(erogatore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(erogatore);
            } else {
                signatureKS = multiKeystore.getKeyStore(aliasSignatureUser);
                aliasSignaturePassword = multiKeystore.getKeyPassword(aliasSignatureUser);
                aliasSignatureUser = multiKeystore.getKeyAlias(aliasSignatureUser);
            }
        }
        SignatureBean bean = new SignatureBean();
        bean.setKeystore(signatureKS);
        bean.setTruststore(signatureTrustStoreKS);
        bean.setUser(aliasSignatureUser);
        bean.setPassword(aliasSignaturePassword);
        bean.setCrlPath(crlPath);
        return bean;
    }
}

