/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.reference.AttachmentReference;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.reference.Reference;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityContext;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.AttachmentProcessingPart;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.ProcessingPart;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.ProcessingPartUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class AttachmentsConfigReaderUtils {
    public static List<String> getListCIDAttachmentsForSecurity(MessageSecurityContext wssContext) throws Exception {
        ArrayList<String> cidSecurity = new ArrayList<String>();
        if (wssContext.getReferences() != null && wssContext.getReferences().size() > 0) {
            for (Reference reference : wssContext.getReferences()) {
                if (!(reference instanceof AttachmentReference)) continue;
                AttachmentReference ar = (AttachmentReference)reference;
                cidSecurity.add(ar.getReference());
            }
        }
        return cidSecurity;
    }

    public static AttachmentProcessingPart getSecurityOnAttachments(MessageSecurityContext wssContext) throws Exception {
        AttachmentProcessingPart ap = null;
        Hashtable<String, Object> wssProperties = null;
        wssProperties = wssContext.isFunctionAsClient() ? wssContext.getOutgoingProperties() : wssContext.getIncomingProperties();
        if (wssProperties != null && wssProperties.size() > 0) {
            if (wssProperties.containsKey("encryptionParts")) {
                String value = (String)wssProperties.get("encryptionParts");
                List<ProcessingPart<?, ?>> listProcessingParts = ProcessingPartUtils.getEncryptionInstance().getProcessingParts(value);
                AttachmentProcessingPart apFound = AttachmentsConfigReaderUtils.findAttachmentProcessingPart(listProcessingParts, ap, "encryptionParts");
                if (ap == null) {
                    ap = apFound;
                }
            } else if (wssProperties.containsKey("signatureParts")) {
                String value = (String)wssProperties.get("signatureParts");
                List<ProcessingPart<?, ?>> listProcessingParts = ProcessingPartUtils.getEncryptionInstance().getProcessingParts(value);
                AttachmentProcessingPart apFound = AttachmentsConfigReaderUtils.findAttachmentProcessingPart(listProcessingParts, ap, "signatureParts");
                if (ap == null) {
                    ap = apFound;
                }
            }
        }
        return ap;
    }

    public static AttachmentProcessingPart findAttachmentProcessingPart(List<ProcessingPart<?, ?>> listProcessingParts, AttachmentProcessingPart ap, String parts) throws Exception {
        AttachmentProcessingPart apFound = null;
        boolean found = false;
        for (ProcessingPart<?, ?> processingPart : listProcessingParts) {
            if (!(processingPart instanceof AttachmentProcessingPart)) continue;
            if (found) {
                throw new Exception("Only one configuration for attachments is allowed in " + parts);
            }
            apFound = (AttachmentProcessingPart)processingPart;
            if (ap != null) {
                if (ap.isAllAttachments()) {
                    if (!apFound.isAllAttachments()) {
                        throw new Exception("The configuration of signature and encryption for the attachments must be the same (found difference in encryptionParts and signatureParts)");
                    }
                } else {
                    int apIntValue = (Integer)ap.getPart();
                    if (apFound.isAllAttachments() || apIntValue != (Integer)apFound.getPart()) {
                        throw new Exception("The configuration of signature and encryption for the attachments must be the same (found difference in encryptionParts and signatureParts)");
                    }
                }
            }
            found = true;
        }
        return apFound;
    }
}

