/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SoapUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import org.adroitlogic.soapbox.CryptoUtil;
import org.adroitlogic.soapbox.MessageSecurityContext;
import org.adroitlogic.soapbox.SecurityConfig;
import org.adroitlogic.soapbox.SecurityRequest;
import org.apache.wss4j.common.token.DOMX509Data;
import org.apache.wss4j.common.token.DOMX509IssuerSerial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSSUtils {
    public static void initWSSecurityHeader(OpenSPCoop2Message message, String actor, boolean mustUnderstand) throws SOAPException {
        Iterator it;
        if (message.getSOAPHeader() == null) {
            message.getSOAPPart().getEnvelope().addHeader();
        }
        if ((it = message.getSOAPHeader().getChildElements(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"))).hasNext()) {
            return;
        }
        QName name = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        SOAPHeaderElement headerwss = message.newSOAPHeaderElement(message.getSOAPHeader(), name);
        headerwss.setActor(actor);
        headerwss.setMustUnderstand(mustUnderstand);
        headerwss.setParentElement((SOAPElement)message.getSOAPHeader());
        message.addHeaderElement(message.getSOAPHeader(), headerwss);
    }

    public static SOAPHeaderElement getWSSecurityHeader(OpenSPCoop2Message message, String actor, boolean mustUnderstand) throws SOAPException {
        if (message.getSOAPHeader() == null) {
            message.getSOAPPart().getEnvelope().addHeader();
        }
        Iterator it = message.getSOAPHeader().getChildElements(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
        while (it.hasNext()) {
            SOAPHeaderElement hdr = (SOAPHeaderElement)it.next();
            String actorCheck = SoapUtils.getSoapActor(hdr, message.getVersioneSoap());
            boolean mustUnderstandFound = hdr.getMustUnderstand();
            if (mustUnderstand != mustUnderstandFound || (actor == null ? actorCheck != null : !actor.equals(actorCheck))) continue;
            return hdr;
        }
        throw new SOAPException("NotFound");
    }

    public static Element getWSSecurityHeader(Document doc, String actor, boolean mustUnderstand) throws SecurityException {
        String ns = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
        String localName = "Security";
        NodeList nl = doc.getDocumentElement().getElementsByTagNameNS(ns, localName);
        if (nl == null || nl.getLength() <= 0) {
            throw new SecurityException("Header WSS not found");
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element) || !localName.equals(n.getLocalName()) || !ns.equals(n.getNamespaceURI())) continue;
            String actorFound = null;
            boolean mustUnderstandFound = false;
            NamedNodeMap attributes = n.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node a = attributes.item(j);
                String localNameAttribute = a.getLocalName();
                String namespaceAttribute = a.getNamespaceURI();
                String valueAttribute = a.getNodeValue();
                if ("actor".equals(localNameAttribute) && "http://schemas.xmlsoap.org/soap/envelope/".equals(namespaceAttribute)) {
                    actorFound = valueAttribute;
                    continue;
                }
                if (!"mustUnderstand".equals(localNameAttribute) || !"http://schemas.xmlsoap.org/soap/envelope/".equals(namespaceAttribute)) continue;
                mustUnderstandFound = "1".equals(valueAttribute);
            }
            if (mustUnderstand != mustUnderstandFound || (actor == null ? actorFound != null : !actor.equals(actorFound))) continue;
            return (Element)n;
        }
        throw new SecurityException("Header WSS not found");
    }

    public static Element createKeyInfoElement(Document doc, SecurityRequest secReq, MessageSecurityContext msgSecCtx, SecurityConfig secConfig) {
        Element keyInfoElem = CryptoUtil.createKeyInfoElement((Document)doc, (SecurityRequest)secReq, (MessageSecurityContext)msgSecCtx, (SecurityConfig)secConfig);
        switch (secReq.getKeyIdentifierType()) {
            case ISSUER_SERIAL: {
                String alias = secReq.getCertAlias();
                X509Certificate[] certs = secConfig.getCertificatesByAlias(alias);
                String issuer = certs[0].getIssuerX500Principal().getName();
                BigInteger serialNumber = certs[0].getSerialNumber();
                DOMX509IssuerSerial domIssuerSerial = new DOMX509IssuerSerial(doc, issuer, serialNumber);
                DOMX509Data domX509Data = new DOMX509Data(doc, domIssuerSerial);
                keyInfoElem.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference").item(0).appendChild(domX509Data.getElement());
            }
        }
        return keyInfoElem;
    }
}

