/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox;

import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.adroitlogic.soapbox.CryptoUtil;
import org.adroitlogic.soapbox.InvalidMessageDataException;
import org.adroitlogic.soapbox.MessageSecurityContext;
import org.adroitlogic.soapbox.Processor;
import org.adroitlogic.soapbox.SecurityConfig;
import org.apache.commons.lang.time.FastDateFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TimestampMessageProcessor
implements Processor {
    private final FastDateFormat zulu = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", (TimeZone)TimeZone.getTimeZone("UTC"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(SecurityConfig secConfig, MessageSecurityContext msgSecCtx) {
        Document doc = msgSecCtx.getDocument();
        Element wsseSecurityElem = CryptoUtil.getWSSecurityHeader((Document)doc);
        if (CryptoUtil.getFirstChildOrNull((Element)wsseSecurityElem, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", (String)"Timestamp") != null) {
            throw new InvalidMessageDataException("Message is already timestamped");
        }
        Element timestampElem = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        CryptoUtil.setWsuId((Element)timestampElem, (String)CryptoUtil.getRandomId());
        Element createdElem = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        Element expiresElem = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
        long ttl = msgSecCtx.getTimestampRequest().getTimeForExpiryMillis();
        Calendar currentTime = null;
        GregorianCalendar expiryTime = null;
        try {
            currentTime = DateManager.getCalendar();
        }
        catch (UtilsException e) {
            currentTime = new GregorianCalendar();
            currentTime.setTimeInMillis(new Date().getTime());
        }
        expiryTime = new GregorianCalendar();
        expiryTime.setTimeInMillis(currentTime.getTimeInMillis() + ttl);
        FastDateFormat e = this.zulu;
        synchronized (e) {
            createdElem.setTextContent(this.zulu.format(currentTime.getTime()));
            expiresElem.setTextContent(this.zulu.format(expiryTime.getTime()));
        }
        timestampElem.appendChild(createdElem);
        timestampElem.appendChild(expiresElem);
        Element firstChild = CryptoUtil.getFirstElementChild((Element)wsseSecurityElem);
        if (firstChild != null) {
            wsseSecurityElem.insertBefore(timestampElem, firstChild);
        } else {
            wsseSecurityElem.appendChild(timestampElem);
        }
    }
}

