/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.signature.XMLSecEnvelopeIdResolver;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.MessageSecurityContext_soapbox;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.WSSUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPElement;
import org.adroitlogic.soapbox.CryptoUtil;
import org.adroitlogic.soapbox.InvalidMessageDataException;
import org.adroitlogic.soapbox.MessageSecurityContext;
import org.adroitlogic.soapbox.Processor;
import org.adroitlogic.soapbox.SecurityConfig;
import org.adroitlogic.soapbox.SecurityFailureException;
import org.adroitlogic.soapbox.SecurityRequest;
import org.adroitlogic.soapbox.SignatureRequest;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.apache.xml.security.utils.ElementProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SignPartialMessageProcessor
implements Processor {
    public static final QName TIMESTAMP = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp");
    private boolean useXMLSec = true;
    private AbstractXMLUtils xmlUtils = XMLUtils.getInstance();
    protected List<QName> signQNames = new ArrayList<QName>();
    protected List<Boolean> elementsSignatureContent;
    protected List<AttachmentPart> signAttachments = new ArrayList<AttachmentPart>();
    protected OpenSPCoop2Message message;
    protected String actor;
    protected boolean mustUnderstand;

    public boolean isUseXMLSec() {
        return this.useXMLSec;
    }

    public void setUseXMLSec(boolean useXMLSec) {
        this.useXMLSec = useXMLSec;
    }

    public void setMessage(OpenSPCoop2Message message) {
        this.message = message;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public void setMustUnderstand(boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
    }

    public SignPartialMessageProcessor() {
        this.elementsSignatureContent = new ArrayList<Boolean>();
    }

    public void addElementToSign(QName element, boolean content) {
        this.signQNames.add(element);
        this.elementsSignatureContent.add(content);
    }

    public void addAttachmentsToSign(AttachmentPart part, boolean content) {
        this.signAttachments.add(part);
    }

    /*
     * Unable to fully structure code
     */
    public void process(SecurityConfig secConfig, MessageSecurityContext msgSecCtx) {
        block28: {
            signReq = msgSecCtx.getSignatureRequest();
            wsseSecurityElem = null;
            try {
                wsseSecurityElem = WSSUtils.getWSSecurityHeader(msgSecCtx.getDocument(), this.actor, this.mustUnderstand);
            }
            catch (Exception e) {
                throw new SecurityFailureException(e.getMessage(), (Throwable)e);
            }
            if (CryptoUtil.getFirstChildOrNull((Element)wsseSecurityElem, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature") != null) {
                throw new InvalidMessageDataException("Message is already signed");
            }
            certs = secConfig.getCertificatesByAlias(signReq.getCertAlias());
            sigAlgoURI = signReq.getSignatureAlgoURI();
            if (sigAlgoURI == null) {
                if ("DSA".equalsIgnoreCase(certs[0].getPublicKey().getAlgorithm())) {
                    if (this.useXMLSec) {
                        sigAlgoURI = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
                    }
                } else if ("RSA".equalsIgnoreCase(certs[0].getPublicKey().getAlgorithm())) {
                    if (this.useXMLSec) {
                        sigAlgoURI = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                    }
                } else {
                    throw new SecurityFailureException("Signature algorithm not specified, and cannot be auto detected");
                }
            }
            doc = msgSecCtx.getDocument();
            env = doc.getDocumentElement();
            sigXMLSec = null;
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(signReq.getC14nAlgoURI())) {
                canonicalizationMethodElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
                canonicalizationMethodElem.setAttribute("Algorithm", signReq.getC14nAlgoURI());
                try {
                    if (!this.useXMLSec) ** GOTO lbl43
                    signatureAlgorithm = new SignatureAlgorithm(doc, sigAlgoURI);
                    sigXMLSec = new XMLSignature(doc, null, signatureAlgorithm.getElement(), canonicalizationMethodElem);
                    sigXMLSec.setId(SignPartialMessageProcessor.getSignId());
                }
                catch (Exception e) {
                    throw new SecurityFailureException("Error signing document with credentials of alias : " + signReq.getCertAlias() + " using algorithm : " + sigAlgoURI + " and c14n with : " + signReq.getC14nAlgoURI(), (Throwable)e);
                }
            } else {
                try {
                    if (this.useXMLSec) {
                        sigXMLSec = new XMLSignature(doc, null, sigAlgoURI, signReq.getC14nAlgoURI());
                        sigXMLSec.setId(SignPartialMessageProcessor.getSignId());
                    }
                }
                catch (Exception e) {
                    throw new SecurityFailureException("Error signing document with credentials of alias : " + signReq.getCertAlias() + " using algorithm : " + sigAlgoURI + " and c14n with : " + signReq.getC14nAlgoURI(), (Throwable)e);
                }
            }
lbl43:
            // 3 sources

            if (this.signQNames.isEmpty() && this.signAttachments.isEmpty()) {
                this.signQNames.add(new QName(env.getNamespaceURI(), "Body"));
                this.elementsSignatureContent.add(false);
                this.signQNames.add(SignPartialMessageProcessor.TIMESTAMP);
                this.elementsSignatureContent.add(false);
            }
            signElements = new ArrayList<Element>();
            signTypeElements = new ArrayList<Boolean>();
            for (i = 0; i < this.signQNames.size(); ++i) {
                name = this.signQNames.get(i);
                signElements.add(CryptoUtil.getFirstChild((Element)env, (String)name.getNamespaceURI(), (String)name.getLocalPart()));
                signTypeElements.add(this.elementsSignatureContent.get(i));
            }
            this.signElements(signElements, signTypeElements, signReq, sigXMLSec);
            if (this.useXMLSec) {
                sigXMLSec.addResourceResolver(XMLSecEnvelopeIdResolver.getInstance(this.message));
            }
            this.signAttachments(this.signAttachments, signReq, sigXMLSec);
            useSignatureHeaderBlock = false;
            signatureElem = null;
            if (useSignatureHeaderBlock) {
                try {
                    if (this.useXMLSec) {
                        throw new Exception("Not implemented for XMLSec IMPL");
                    }
                    break block28;
                }
                catch (Exception e) {
                    throw new SecurityFailureException("Error signing document using alias : " + signReq.getCertAlias(), (Throwable)e);
                }
            }
            try {
                if (this.useXMLSec) {
                    signatureElem = this.convertToSoapElement((ElementProxy)sigXMLSec);
                    if (signReq.isWsiBPCompliant()) {
                        prefixes = new HashSet<String>();
                        prefixes.addAll(this.getInclusivePrefixes((Element)signatureElem, false));
                        canonicalizationMethodElem = (Element)signatureElem.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod").item(0);
                        inclusiveNamespaces = new InclusiveNamespaces(doc, prefixes);
                        canonicalizationMethodElem.appendChild(inclusiveNamespaces.getElement());
                    }
                    sigXMLSec.sign((Key)secConfig.getPrivateKeyByAlias(signReq.getCertAlias()));
                    signatureElem = this.convertToSoapElement((ElementProxy)sigXMLSec);
                }
            }
            catch (Exception e) {
                throw new SecurityFailureException("Error signing document using alias : " + signReq.getCertAlias(), (Throwable)e);
            }
        }
        this.addKeyInfo((Element)signatureElem, doc, signReq, msgSecCtx, secConfig, wsseSecurityElem);
    }

    protected void addKeyInfo(Element signatureElem, Document doc, SignatureRequest signReq, MessageSecurityContext msgSecCtx, SecurityConfig secConfig, Element wsseSecurityElem) {
        signatureElem.appendChild(WSSUtils.createKeyInfoElement(doc, (SecurityRequest)signReq, msgSecCtx, secConfig));
        Element firstChild = CryptoUtil.getFirstElementChild((Element)wsseSecurityElem);
        if (firstChild != null) {
            wsseSecurityElem.insertBefore(signatureElem, firstChild);
        } else {
            wsseSecurityElem.appendChild(signatureElem);
        }
        NodeList nl = wsseSecurityElem.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "BinarySecurityToken");
        for (int i = 0; i < nl.getLength(); ++i) {
            wsseSecurityElem.insertBefore(nl.item(i), signatureElem);
        }
    }

    private SOAPElement convertToSoapElement(ElementProxy proxy) {
        Element elem = proxy.getElement();
        if (elem instanceof SOAPElement) {
            return (SOAPElement)elem;
        }
        return (SOAPElement)proxy.getDocument().importNode(elem, true);
    }

    public List<String> getInclusivePrefixes(Element target, boolean excludeVisible) {
        Node attribute;
        int i;
        NamedNodeMap attributes;
        ArrayList<String> result = new ArrayList<String>();
        Node parent = target;
        while (parent.getParentNode() != null && 9 != parent.getParentNode().getNodeType()) {
            parent = parent.getParentNode();
            attributes = parent.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                attribute = attributes.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(attribute.getNamespaceURI())) continue;
                if ("xmlns".equals(attribute.getNodeName())) {
                    result.add("#default");
                    continue;
                }
                result.add(attribute.getLocalName());
            }
        }
        if (excludeVisible) {
            attributes = target.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                attribute = attributes.item(i);
                if ("http://www.w3.org/2000/xmlns/".equals(attribute.getNamespaceURI())) {
                    if ("xmlns".equals(attribute.getNodeName())) {
                        result.remove("#default");
                    } else {
                        result.remove(attribute.getLocalName());
                    }
                }
                if (attribute.getPrefix() == null) continue;
                result.remove(attribute.getPrefix());
            }
            if (target.getPrefix() == null) {
                result.remove("#default");
            } else {
                result.remove(target.getPrefix());
            }
        }
        return result;
    }

    protected void signAttachments(List<AttachmentPart> part, SignatureRequest signReq, XMLSignature sigXMLSec) {
        try {
            if (this.signAttachments == null || this.signAttachments.size() <= 0) {
                return;
            }
            for (AttachmentPart p : this.signAttachments) {
                Object uri = p.getContentId();
                uri = uri != null ? (((String)uri).startsWith("<") ? "cid:" + ((String)uri).substring(1, ((String)uri).length() - 1) : "cid:" + (String)uri) : p.getContentLocation();
                if (sigXMLSec == null) continue;
                Transforms transforms = new Transforms(this.message.getSOAPHeader().getOwnerDocument());
                transforms.addTransform("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform");
                String contentType = p.getContentType();
                if ("text/xml".equals(contentType) && signReq.isWsiBPCompliant()) {
                    byte[] raw = p.getRawContentBytes();
                    Element signElement = this.xmlUtils.newElement(raw);
                    transforms.item(0).getElement().appendChild(new InclusiveNamespaces(this.message.getSOAPHeader().getOwnerDocument(), CryptoUtil.getInclusivePrefixes((Element)signElement, (boolean)true)).getElement());
                }
                sigXMLSec.addDocument((String)uri, transforms, signReq.getDigestAlgoURI());
            }
        }
        catch (Exception e) {
            throw new SecurityFailureException("Error signing attachments", (Throwable)e);
        }
    }

    private void signElements(List<Element> signList, List<Boolean> signTypeList, SignatureRequest signReq, XMLSignature sigXMLSec) {
        for (int i = 0; i < signList.size(); ++i) {
            Element signElement = signList.get(i);
            Boolean content = signTypeList.get(i);
            String signId = null;
            try {
                signId = signElement.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                if (signId == null || signId.length() == 0) {
                    signId = signElement.getAttribute("Id");
                }
                if (signId == null || signId.length() == 0) {
                    signId = SignPartialMessageProcessor.getSignId();
                    CryptoUtil.setWsuId((Element)signElement, (String)signId);
                }
                if (sigXMLSec == null) continue;
                Transforms transforms = new Transforms(signElement.getOwnerDocument());
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                if (signReq.isWsiBPCompliant()) {
                    transforms.item(0).getElement().appendChild(new InclusiveNamespaces(signElement.getOwnerDocument(), CryptoUtil.getInclusivePrefixes((Element)signElement, (boolean)true)).getElement());
                }
                sigXMLSec.addDocument("#" + signId, transforms, signReq.getDigestAlgoURI());
                continue;
            }
            catch (Exception e) {
                throw new SecurityFailureException("Error processing signature for element : {" + signElement.getNamespaceURI() + "}" + signElement.getLocalName() + " with Id : " + signId, (Throwable)e);
            }
        }
    }

    public static String getSignId() {
        return MessageSecurityContext_soapbox.getWsuIdAllocator().createId(CryptoUtil.getRandomId(), null);
    }
}

