/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.CRLCertstore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.cache.GestoreKeystoreCache;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;

public class SecurityConfig
extends org.adroitlogic.soapbox.SecurityConfig {
    private boolean symmetricSharedKey = false;
    private KeyStore identityStore = null;
    private final WeakHashMap<X509Certificate[], Boolean> validCerts = new WeakHashMap();
    private final CertPathValidator certPathValidator;
    private final CertificateFactory certFactory;
    private final PKIXParameters validatorParams;

    public boolean isSymmetricSharedKey() {
        return this.symmetricSharedKey;
    }

    public void setSymmetricSharedKey(boolean symmetricSharedKey) {
        this.symmetricSharedKey = symmetricSharedKey;
    }

    public SecurityConfig(KeyStore identityStore, KeyStore trustStore, Map<String, String> keyPasswords) throws KeyStoreException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, CertificateException {
        this(identityStore, trustStore, keyPasswords, null);
    }

    public SecurityConfig(KeyStore identityStore, KeyStore trustStore, Map<String, String> keyPasswords, String crlPath) throws KeyStoreException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, CertificateException {
        super(identityStore, trustStore, keyPasswords);
        this.identityStore = identityStore;
        this.validatorParams = new PKIXParameters(trustStore);
        this.validatorParams.setRevocationEnabled(false);
        this.certPathValidator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
        this.certFactory = CertificateFactory.getInstance("X.509");
        if (crlPath != null) {
            try {
                CRLCertstore crlCertstore = GestoreKeystoreCache.getCRLCertstore(crlPath);
                this.validatorParams.addCertStore(crlCertstore.getCertStore());
                this.validatorParams.setRevocationEnabled(true);
                this.validatorParams.setDate(DateManager.getDate());
            }
            catch (Exception e) {
                throw new CertificateException(e.getMessage(), e);
            }
        }
    }

    public Key getSymmetricKey(String alias) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String password = this.getKeyPassword(alias);
        Key key = this.identityStore.getKey(alias, password.toCharArray());
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateX509Certificate(X509Certificate[] certs) throws SecurityException {
        Boolean validity = this.validCerts.get(certs);
        if (validity == null) {
            SecurityConfig securityConfig = this;
            synchronized (securityConfig) {
                StringBuffer bf = new StringBuffer();
                if (certs != null) {
                    for (int i = 0; i < certs.length; ++i) {
                        if (i > 0) {
                            bf.append(" ");
                        }
                        bf.append("(Certificate[" + i + "]: DN=" + certs[i].getSubjectDN().toString() + ")");
                    }
                }
                bf.append(" Does not validate against the trusted CA certificates ");
                try {
                    this.certPathValidator.validate(this.certFactory.generateCertPath(Arrays.asList(certs)), this.validatorParams);
                    this.validCerts.put(certs, Boolean.TRUE);
                }
                catch (CertificateNotYetValidException e) {
                    this.validCerts.put(certs, Boolean.FALSE);
                    throw new SecurityException(bf.toString() + "[Certificate is not yet valid] - " + e.getMessage());
                }
                catch (CertificateExpiredException e) {
                    this.validCerts.put(certs, Boolean.FALSE);
                    throw new SecurityException(bf.toString() + "[Certificate has expired] - " + e.getMessage());
                }
                catch (Exception e) {
                    this.validCerts.put(certs, Boolean.FALSE);
                    throw new SecurityException(bf.toString() + "[Errore generico] - " + e.getMessage());
                }
            }
        }
        throw new SecurityException("Certificate not found in validCerts");
    }
}

