/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox;

import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.adroitlogic.soapbox.CryptoUtil;
import org.adroitlogic.soapbox.InvalidMessageDataException;
import org.adroitlogic.soapbox.MessageSecurityContext;
import org.adroitlogic.soapbox.Processor;
import org.adroitlogic.soapbox.SecurityConfig;
import org.adroitlogic.soapbox.SecurityFailureException;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class ProcessTimestampedMessage
implements Processor {
    private static final Logger logger = LoggerWrapperFactory.getLogger(ProcessTimestampedMessage.class);
    private final SimpleDateFormat zuluMillisecondsPrecision = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public ProcessTimestampedMessage() {
        this.zuluMillisecondsPrecision.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.zulu.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(SecurityConfig secConfig, MessageSecurityContext msgSecCtx) {
        Calendar rightNow;
        Element elem = CryptoUtil.getSecurityProcessorElement((Element)msgSecCtx.getDocument().getDocumentElement(), (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", (String)"Timestamp");
        if (elem == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Message is not timestamped - skipping ProcessTimestampedMessage");
            }
            throw new SecurityFailureException("WS-Security failure - Message is not timestamped");
        }
        String createdTime = CryptoUtil.getFirstChild((Element)elem, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", (String)"Created").getTextContent();
        String expiryTime = CryptoUtil.getFirstChild((Element)elem, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", (String)"Expires").getTextContent();
        Long futureTimeToLive = (Long)msgSecCtx.getProperty("futureTimeToLive");
        boolean isStrict = (Boolean)msgSecCtx.getProperty("timestampStrict");
        GregorianCalendar valid = null;
        boolean precisionInSeconds = false;
        GregorianCalendar created = new GregorianCalendar();
        GregorianCalendar expiry = new GregorianCalendar();
        valid = new GregorianCalendar();
        try {
            SimpleDateFormat simpleDateFormat = this.zuluMillisecondsPrecision;
            synchronized (simpleDateFormat) {
                created.setTime(this.zuluMillisecondsPrecision.parse(createdTime));
            }
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat simpleDateFormat = this.zulu;
                synchronized (simpleDateFormat) {
                    created.setTime(this.zulu.parse(createdTime));
                }
                precisionInSeconds = true;
            }
            catch (ParseException e1) {
                throw new InvalidMessageDataException("Invalid timestamp data. Created : " + createdTime + " Expected in Zulu format : " + e1.getMessage());
            }
        }
        valid.setTimeInMillis(created.getTime().getTime() - futureTimeToLive);
        SimpleDateFormat format = precisionInSeconds ? this.zulu : this.zuluMillisecondsPrecision;
        try {
            SimpleDateFormat e1 = format;
            synchronized (e1) {
                expiry.setTime(format.parse(expiryTime));
            }
        }
        catch (ParseException e) {
            throw new InvalidMessageDataException("Invalid timestamp data.  Expiry : " + expiryTime + " Expected in Zulu format : " + e.getMessage());
        }
        try {
            rightNow = DateManager.getCalendar();
        }
        catch (UtilsException e) {
            rightNow = new GregorianCalendar();
            rightNow.setTimeInMillis(new Date().getTime());
        }
        if (expiry.before(created)) {
            if (isStrict) {
                throw new SecurityFailureException("Message expiry : " + expiryTime + " before created time : " + createdTime);
            }
            if (logger.isInfoEnabled()) {
                logger.warn("Message expiry : " + expiryTime + " before created time : " + createdTime);
            }
        } else {
            if (rightNow.before(valid)) {
                SimpleDateFormat simpleDateFormat = format;
                synchronized (simpleDateFormat) {
                    String msg = "Message is not yet valid. Created timestamp is : " + createdTime + "  Current system time : " + format.format(rightNow.getTime()) + " Future time to live set to " + futureTimeToLive / 1000L + " seconds";
                    if (isStrict) {
                        throw new SecurityFailureException(msg);
                    }
                    if (logger.isInfoEnabled()) {
                        logger.warn(msg);
                    }
                }
            }
            if (rightNow.after(expiry)) {
                SimpleDateFormat simpleDateFormat = format;
                synchronized (simpleDateFormat) {
                    String msg = "Message has expired at : " + expiryTime + " Current system time : " + format.format(rightNow.getTime());
                    if (isStrict) {
                        throw new SecurityFailureException(msg);
                    }
                    if (logger.isInfoEnabled()) {
                        logger.warn(msg);
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                SimpleDateFormat simpleDateFormat = format;
                synchronized (simpleDateFormat) {
                    logger.debug("Timestamp verified and valid at : " + format.format(rightNow.getTime()));
                }
            }
        }
    }
}

