/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.signature.XMLSecEnvelopeIdResolver;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.SecurityConfig;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.WSSUtils;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import java.security.cert.X509Certificate;
import org.adroitlogic.soapbox.CryptoUtil;
import org.adroitlogic.soapbox.MessageSecurityContext;
import org.adroitlogic.soapbox.Processor;
import org.adroitlogic.soapbox.SecurityFailureException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class ProcessSignedMessage
implements Processor {
    private boolean useXMLSec = true;
    private OpenSPCoop2Message message;
    private String actor;
    private boolean mustUnderstand;
    private X509Certificate[] certificates = null;
    private static final Logger logger = LoggerWrapperFactory.getLogger(ProcessSignedMessage.class);

    public boolean isUseXMLSec() {
        return this.useXMLSec;
    }

    public void setUseXMLSec(boolean useXMLSec) {
        this.useXMLSec = useXMLSec;
    }

    public void setMessage(OpenSPCoop2Message message) {
        this.message = message;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public void setMustUnderstand(boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
    }

    public X509Certificate[] getCertificates() {
        return this.certificates;
    }

    public void process(org.adroitlogic.soapbox.SecurityConfig secConfig, MessageSecurityContext msgSecCtx) {
        Element wsseSecurityElem = null;
        try {
            wsseSecurityElem = WSSUtils.getWSSecurityHeader(msgSecCtx.getDocument(), this.actor, this.mustUnderstand);
        }
        catch (Exception e) {
            throw new SecurityFailureException(e.getMessage(), (Throwable)e);
        }
        Element elemSignature = CryptoUtil.getSecurityProcessorElement((Element)wsseSecurityElem, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        if (elemSignature == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Message is not signed - skipping ProcessSignedMessage");
            }
            throw new SecurityFailureException("WS-Security failure - Message is not signed");
        }
        XMLSignature sigXMLSec = null;
        try {
            if (this.useXMLSec) {
                sigXMLSec = new XMLSignature(elemSignature, null);
            }
        }
        catch (Exception e) {
            throw new SecurityFailureException("No signature or error in processing signature in document", (Throwable)e);
        }
        if (this.useXMLSec) {
            sigXMLSec.addResourceResolver(XMLSecEnvelopeIdResolver.getInstance(this.message));
        }
        X509Certificate[] certs = null;
        if (this.useXMLSec) {
            KeyInfo keyInfo = sigXMLSec.getKeyInfo();
            if (keyInfo != null && keyInfo.containsKeyValue()) {
                throw new UnsupportedOperationException("Verification of signatures from PublicKeys not yet supported");
            }
            if (keyInfo != null) {
                certs = CryptoUtil.getCertificatesFromSecurityTokenReference((org.adroitlogic.soapbox.SecurityConfig)secConfig, (MessageSecurityContext)msgSecCtx, (Element)CryptoUtil.getFirstChild((Element)elemSignature, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", (String)"SecurityTokenReference"));
            } else {
                throw new SecurityFailureException("No key information for signature was found");
            }
        }
        this.certificates = certs;
        if (certs != null && certs.length != 0) {
            for (int i = 0; i < certs.length; ++i) {
                try {
                    certs[i].checkValidity();
                    continue;
                }
                catch (Exception e) {
                    throw new SecurityFailureException("Certificate used for signature with DN : " + certs[i].getSubjectDN().toString() + " is not valid", (Throwable)e);
                }
            }
            try {
                ((SecurityConfig)secConfig).validateX509Certificate(certs);
            }
            catch (Exception e) {
                throw new SecurityFailureException("Certificate used for signature with DN : " + certs[0].getSubjectDN().toString() + " or its issuer/s is/are not valid", (Throwable)e);
            }
            try {
                boolean signValid = false;
                if (this.useXMLSec) {
                    signValid = sigXMLSec.checkSignatureValue(certs[0]);
                }
                if (!signValid) {
                    throw new SecurityFailureException("Signature verification failed");
                }
                msgSecCtx.setProperty("ultra.sb.sig.client_certs", (Object)certs);
            }
            catch (Exception e) {
                throw new SecurityFailureException("Signature verification failed", (Throwable)e);
            }
        }
        throw new SecurityFailureException("Certificate for signature was not found");
        if (logger.isDebugEnabled()) {
            logger.debug("Signature verified successfully");
        }
    }
}

