/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.EncryptedDataHeaderBlock;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.SecurityConfig;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.WSSUtils;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.adroitlogic.soapbox.CryptoSupport;
import org.adroitlogic.soapbox.CryptoUtil;
import org.adroitlogic.soapbox.EncryptionRequest;
import org.adroitlogic.soapbox.InvalidMessageDataException;
import org.adroitlogic.soapbox.MessageSecurityContext;
import org.adroitlogic.soapbox.Processor;
import org.adroitlogic.soapbox.SecurityFailureException;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProcessPartialEncryptedMessage
implements Processor {
    protected OpenSPCoop2Message message;
    protected String actor;
    protected boolean mustUnderstand;
    public static final Logger logger = LoggerWrapperFactory.getLogger(ProcessPartialEncryptedMessage.class);

    public void setMessage(OpenSPCoop2Message message) {
        this.message = message;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public void setMustUnderstand(boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
    }

    public void process(org.adroitlogic.soapbox.SecurityConfig secConfig, MessageSecurityContext msgSecCtx) {
        byte[] decryptedEphemeralKey;
        Cipher cipher;
        Element elem;
        block13: {
            Element wsseSecurityElem = null;
            try {
                wsseSecurityElem = WSSUtils.getWSSecurityHeader(msgSecCtx.getDocument(), this.actor, this.mustUnderstand);
            }
            catch (Exception e) {
                throw new SecurityFailureException(e.getMessage(), (Throwable)e);
            }
            elem = CryptoUtil.getSecurityProcessorElement((Element)wsseSecurityElem, (String)"http://www.w3.org/2001/04/xmlenc#", (String)"EncryptedKey");
            if (elem == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Message is not encrypted - skipping ProcessEncryptedMessage");
                }
                throw new SecurityFailureException("WS-Security failure - Message is not encrypted");
            }
            cipher = null;
            decryptedEphemeralKey = null;
            try {
                SecurityConfig secContextOpenSPCoop = (SecurityConfig)secConfig;
                String algorithm = CryptoUtil.getFirstChild((Element)elem, (String)"http://www.w3.org/2001/04/xmlenc#", (String)"EncryptionMethod").getAttribute("Algorithm");
                cipher = CryptoSupport.getInstance().getCipherInstance(algorithm);
                if (logger.isDebugEnabled()) {
                    logger.debug("Processing EncryptedKey element - encryption method : " + cipher.getAlgorithm());
                }
                byte[] encryptedEphemeralKey = CryptoUtil.decodeBase64EncodedText((Element)CryptoUtil.getFirstChild((Element)CryptoUtil.getFirstChild((Element)elem, (String)"http://www.w3.org/2001/04/xmlenc#", (String)"CipherData"), (String)"http://www.w3.org/2001/04/xmlenc#", (String)"CipherValue"));
                if (secContextOpenSPCoop.isSymmetricSharedKey()) {
                    EncryptionRequest encReq = msgSecCtx.getEncryptionRequest();
                    Key key = secContextOpenSPCoop.getSymmetricKey(encReq.getCertAlias());
                    cipher.init(4, key);
                    String keyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithm);
                    decryptedEphemeralKey = cipher.unwrap(encryptedEphemeralKey, keyAlgorithm, 3).getEncoded();
                    break block13;
                }
                PrivateKey privateKey = CryptoUtil.getPrivateKeyFromSecurityTokenReference((org.adroitlogic.soapbox.SecurityConfig)secConfig, (MessageSecurityContext)msgSecCtx, (Element)CryptoUtil.getFirstChild((Element)CryptoUtil.getFirstChild((Element)elem, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"KeyInfo"), (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", (String)"SecurityTokenReference"));
                cipher.init(2, privateKey);
                decryptedEphemeralKey = cipher.doFinal(encryptedEphemeralKey);
            }
            catch (Exception e) {
                try {
                    throw new SecurityFailureException("Error decrypting ephemeral key", (Throwable)e);
                }
                catch (Throwable throwable) {
                    CryptoSupport.getInstance().returnCipherInstance(cipher);
                    throw throwable;
                }
            }
        }
        CryptoSupport.getInstance().returnCipherInstance(cipher);
        Element refListElem = CryptoUtil.getFirstChildOrNull((Element)elem, (String)"http://www.w3.org/2001/04/xmlenc#", (String)"ReferenceList");
        NodeList nl = refListElem.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "DataReference");
        if (nl == null) {
            throw new InvalidMessageDataException("No DataReference elements that are signed");
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Element dataRefElem = (Element)nl.item(i);
            String wsuId = dataRefElem.getAttribute("URI");
            if (wsuId.charAt(0) == '#') {
                wsuId = wsuId.substring(1);
            }
            this.decryptDataReference(msgSecCtx, wsuId, decryptedEphemeralKey);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decryptDataReference(MessageSecurityContext msgSecCtx, String wsuId, byte[] decryptedeEphemeralKey) {
        Document doc = msgSecCtx.getDocument();
        Element refElem = CryptoUtil.findElementById((Node)doc, (String)wsuId, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        if (refElem == null) {
            refElem = CryptoUtil.findElementById((Node)doc, (String)wsuId, null);
        }
        if (refElem == null) return;
        Element encData = CryptoUtil.getFirstChild((Element)refElem, (String)"http://www.w3.org/2001/04/xmlenc#", (String)"EncryptedData");
        String encAlgo = CryptoUtil.getFirstChild((Element)encData, (String)"http://www.w3.org/2001/04/xmlenc#", (String)"EncryptionMethod").getAttribute("Algorithm");
        SecretKeySpec symmetricKey = new SecretKeySpec(decryptedeEphemeralKey, JCEMapper.getJCEKeyAlgorithmFromURI((String)encAlgo));
        String type = encData.getAttribute("Type");
        if (type.equals("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Complete") || type.equals("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Only")) {
            try {
                Class<?> edhb = Class.forName(this.message.getEncryptedDataHeaderBlockClass());
                Constructor<?> constructor = edhb.getConstructor(SOAPElement.class);
                EncryptedDataHeaderBlock xencEncryptedData = (EncryptedDataHeaderBlock)constructor.newInstance((SOAPElement)encData);
                String uri = xencEncryptedData.getCipherReference(false, null).getAttribute("URI");
                AttachmentPart part = (AttachmentPart)msgSecCtx.getProperty(uri.substring(4));
                if (part == null) return;
                ProcessPartialEncryptedMessage.decryptAttachment(part, xencEncryptedData, symmetricKey, type);
                return;
            }
            catch (Exception e) {
                throw new InvalidMessageDataException("Failed to decrypt attachment referenced by element with WSU-ID : " + wsuId, (Throwable)e);
            }
        }
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = CryptoSupport.getInstance().getXMLCipher(encAlgo);
            xmlCipher.init(2, (Key)symmetricKey);
            xmlCipher.doFinal(doc, encData);
            return;
        }
        catch (XMLEncryptionException e) {
            throw new InvalidMessageDataException("Unsupported algorithm for decryption : " + encAlgo, (Throwable)e);
        }
        catch (Exception e) {
            throw new InvalidMessageDataException("Failed to decrypt element with WSU-ID : " + wsuId, (Throwable)e);
        }
        finally {
            CryptoSupport.getInstance().returnXMLCipherInstance(encAlgo, xmlCipher);
        }
    }

    public static AttachmentPart decryptAttachment(AttachmentPart part, EncryptedDataHeaderBlock edhb, SecretKey key, String type) throws XWSSecurityException, IOException, SOAPException, MessagingException, Base64DecodingException {
        String mimeType = edhb.getMimeType();
        Element dsTransform = (Element)edhb.getTransforms().next();
        if (!(dsTransform.getAttribute("Algorithm").equals("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Only-Transform") || dsTransform.getAttribute("Algorithm").equals("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Complete-Transform") || dsTransform.getAttribute("Algorithm").equals("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Ciphertext-Transform"))) {
            throw new XWSSecurityException("Unexpected ds:Transform, " + dsTransform.getAttribute("Algorithm"));
        }
        Cipher decryptor = null;
        byte[] cipherOutput = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            part.getDataHandler().writeTo((OutputStream)baos);
            byte[] cipherInput = baos.toByteArray();
            decryptor = CryptoSupport.getInstance().getCipherInstance(edhb.getEncryptionMethodURI());
            int ivLen = decryptor.getBlockSize();
            byte[] ivBytes = new byte[ivLen];
            System.arraycopy(cipherInput, 0, ivBytes, 0, ivLen);
            IvParameterSpec iv = new IvParameterSpec(ivBytes);
            decryptor.init(2, (Key)key, iv);
            cipherOutput = decryptor.doFinal(cipherInput, ivLen, cipherInput.length - ivLen);
        }
        catch (Exception e) {
            try {
                throw new XWSSecurityException((Throwable)e);
            }
            catch (Throwable throwable) {
                CryptoSupport.getInstance().returnCipherInstance(decryptor);
                throw throwable;
            }
        }
        CryptoSupport.getInstance().returnCipherInstance(decryptor);
        if (type.equals("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Only") || type.equals("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Ciphertext-Transform")) {
            part.setContentType(mimeType);
            String[] cLength = part.getMimeHeader("Content-Length");
            if (cLength != null && !cLength[0].equals("")) {
                part.setMimeHeader("Content-Length", Integer.toString(cipherOutput.length));
            }
            part.removeMimeHeader("Content-Transfer-Encoding");
            part.clearContent();
            part.setDataHandler(new DataHandler((DataSource)new _DS(Base64.decode((byte[])cipherOutput), mimeType)));
        } else {
            MimeBodyPart decryptedAttachment = new MimeBodyPart((InputStream)new ByteArrayInputStream(cipherOutput));
            String uri = edhb.getCipherReference(false, null).getAttribute("URI");
            String dcId = decryptedAttachment.getContentID();
            if (dcId == null || !uri.substring(4).equals(dcId.substring(1, dcId.length() - 1))) {
                throw new XWSSecurityException("Content-Ids in encrypted and decrypted attachments donot match");
            }
            part.removeAllMimeHeaders();
            Enumeration h_enum = decryptedAttachment.getAllHeaders();
            while (h_enum.hasMoreElements()) {
                Header hdr = (Header)h_enum.nextElement();
                String hname = hdr.getName();
                String hvale = hdr.getValue();
                part.setMimeHeader(hname, hvale);
            }
            part.clearContent();
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            decryptedAttachment.getDataHandler().writeTo((OutputStream)bs);
            part.setDataHandler(new DataHandler((DataSource)new _DS(Base64.decode((byte[])bs.toByteArray()), mimeType)));
        }
        return part;
    }

    private static class _DS
    implements DataSource {
        byte[] content = null;
        String contentType = null;

        _DS(byte[] content, String contentType) {
            this.content = content;
            this.contentType = contentType;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.content);
        }

        public OutputStream getOutputStream() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.content, 0, this.content.length);
            return baos;
        }

        public String getName() {
            return "_DS";
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

