/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.IMessageSecuritySender;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityContext;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.EncryptPartialMessageProcessor;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.SecurityConfig;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.SignPartialMessageProcessor;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.TimestampMessageProcessor;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.WSSUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.AttachmentProcessingPart;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.ElementProcessingPart;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.EncryptionBean;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.KeystoreUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.ProcessingPart;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.ProcessingPartUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.SignatureBean;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.adroitlogic.soapbox.ElementNotFoundException;
import org.adroitlogic.soapbox.SecurityRequest;
import org.adroitlogic.ultraesb.api.Message;
import org.adroitlogic.ultraesb.core.MessageImpl;
import org.w3c.dom.Document;

public class MessageSecuritySender_soapbox
implements IMessageSecuritySender {
    private AbstractXMLUtils xmlUtils = XMLUtils.getInstance();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(MessageSecurityContext messageSecurityContext, OpenSPCoop2Message message) throws SecurityException {
        try {
            boolean encrypt = false;
            boolean signature = false;
            boolean timestamp = false;
            String[] actions = ((String)messageSecurityContext.getOutgoingProperties().get("action")).split(" ");
            for (int i = 0; i < actions.length; ++i) {
                if ("Encrypt".equals(actions[i].trim())) {
                    encrypt = true;
                    continue;
                }
                if ("Signature".equals(actions[i].trim())) {
                    signature = true;
                    continue;
                }
                if (!"Timestamp".equals(actions[i].trim())) continue;
                timestamp = true;
            }
            SOAPPart sp = message.getSOAPPart();
            org.adroitlogic.soapbox.MessageSecurityContext msgSecCtx = new org.adroitlogic.soapbox.MessageSecurityContext((Document)sp, (Message)new MessageImpl(true, null, "http"));
            Object mustUnderstandObject = messageSecurityContext.getOutgoingProperties().get("mustUnderstand");
            boolean mustUnderstand = false;
            if (mustUnderstandObject != null) {
                mustUnderstand = "true".equals(mustUnderstandObject);
            }
            WSSUtils.initWSSecurityHeader(message, messageSecurityContext.getActor(), mustUnderstand);
            TimestampMessageProcessor timestampProc = null;
            if (timestamp) {
                timestampProc = new TimestampMessageProcessor();
            }
            EncryptPartialMessageProcessor encMsgProc = null;
            if (encrypt) {
                encMsgProc = new EncryptPartialMessageProcessor();
                encMsgProc.setMessage(message);
                encMsgProc.setActor(messageSecurityContext.getActor());
                encMsgProc.setMustUnderstand(mustUnderstand);
                Object encryptionParts = messageSecurityContext.getOutgoingProperties().get("encryptionParts");
                List<ProcessingPart<?, ?>> lstEncryptionParts = null;
                if (encryptionParts != null) {
                    lstEncryptionParts = ProcessingPartUtils.getEncryptionInstance().getProcessingParts((String)encryptionParts);
                }
                boolean allPresente = false;
                boolean allComplete = false;
                ArrayList<AttachmentProcessingPart> lstAttachments = new ArrayList<AttachmentProcessingPart>();
                for (ProcessingPart<?, ?> part : lstEncryptionParts) {
                    if (part instanceof AttachmentProcessingPart) {
                        AttachmentProcessingPart attProcessingPart = (AttachmentProcessingPart)part;
                        if (attProcessingPart.isAllAttachments()) {
                            allPresente = true;
                            allComplete = !attProcessingPart.isContent();
                            continue;
                        }
                        lstAttachments.add(attProcessingPart);
                        continue;
                    }
                    if (!(part instanceof ElementProcessingPart)) continue;
                    ElementProcessingPart elProcessingPart = (ElementProcessingPart)part;
                    encMsgProc.addElementToEncrypt((QName)elProcessingPart.getPart(), elProcessingPart.isContent());
                }
                if (allPresente || lstAttachments.size() > 0) {
                    Iterator<?> it = message.getAttachments();
                    if (!it.hasNext()) {
                        throw new Exception("Property encryptionParts contiene la richiesta di cifrare attachments, ma il messaggio non ne contiene");
                    }
                    int indexAllegatoEncrypt = 1;
                    while (it.hasNext()) {
                        AttachmentPart ap = (AttachmentPart)it.next();
                        if (allPresente) {
                            encMsgProc.addAttachmentToEncrypt(ap, !allComplete);
                            continue;
                        }
                        boolean found = false;
                        for (int i = 0; i < lstAttachments.size() && !found; ++i) {
                            if (!((Integer)((AttachmentProcessingPart)lstAttachments.get(i)).getPart()).equals(indexAllegatoEncrypt)) continue;
                            encMsgProc.addAttachmentToEncrypt(ap, !((AttachmentProcessingPart)lstAttachments.get(i)).isContent());
                            found = true;
                        }
                        ++indexAllegatoEncrypt;
                    }
                }
            }
            SignPartialMessageProcessor signMsgProc = null;
            if (signature) {
                signMsgProc = (SignPartialMessageProcessor)Class.forName(message.getSignPartialMessageProcessorClass()).getConstructor(new Class[0]).newInstance(new Object[0]);
                signMsgProc.setMessage(message);
                signMsgProc.setActor(messageSecurityContext.getActor());
                signMsgProc.setMustUnderstand(mustUnderstand);
                signMsgProc.setUseXMLSec(messageSecurityContext.isUseXMLSec());
                Object signatureParts = messageSecurityContext.getOutgoingProperties().get("signatureParts");
                List<ProcessingPart<?, ?>> lstSignatureParts = null;
                if (signatureParts != null) {
                    lstSignatureParts = ProcessingPartUtils.getSignatureInstance().getProcessingParts((String)signatureParts);
                }
                boolean allPresente = false;
                boolean allComplete = false;
                ArrayList<AttachmentProcessingPart> lstAttachments = new ArrayList<AttachmentProcessingPart>();
                for (ProcessingPart<?, ?> part : lstSignatureParts) {
                    if (part instanceof AttachmentProcessingPart) {
                        AttachmentProcessingPart attProcessingPart = (AttachmentProcessingPart)part;
                        if (attProcessingPart.isAllAttachments()) {
                            allPresente = true;
                            allComplete = !attProcessingPart.isContent();
                            continue;
                        }
                        lstAttachments.add(attProcessingPart);
                        continue;
                    }
                    if (!(part instanceof ElementProcessingPart)) continue;
                    ElementProcessingPart elProcessingPart = (ElementProcessingPart)part;
                    signMsgProc.addElementToSign((QName)elProcessingPart.getPart(), elProcessingPart.isContent());
                }
                if (allPresente || lstAttachments.size() > 0) {
                    Iterator<?> it = message.getAttachments();
                    if (!it.hasNext()) {
                        throw new Exception("Property signatureParts contiene la richiesta di cifrare attachments, ma il messaggio non ne contiene");
                    }
                    int indexAllegatoEncrypt = 1;
                    while (it.hasNext()) {
                        AttachmentPart ap = (AttachmentPart)it.next();
                        if (allPresente) {
                            signMsgProc.addAttachmentsToSign(ap, !allComplete);
                            continue;
                        }
                        boolean found = false;
                        for (int i = 0; i < lstAttachments.size() && !found; ++i) {
                            if (!((Integer)((AttachmentProcessingPart)lstAttachments.get(i)).getPart()).equals(indexAllegatoEncrypt)) continue;
                            signMsgProc.addAttachmentsToSign(ap, !((AttachmentProcessingPart)lstAttachments.get(i)).isContent());
                            found = true;
                        }
                        ++indexAllegatoEncrypt;
                    }
                }
            }
            KeyStore encryptionKS = null;
            KeyStore encryptionTrustStoreKS = null;
            boolean encryptionSymmetric = false;
            String aliasEncryptUser = null;
            String aliasEncryptPassword = null;
            if (encrypt) {
                EncryptionBean bean = KeystoreUtils.getSenderEncryptionBean(messageSecurityContext);
                encryptionKS = bean.getKeystore();
                encryptionTrustStoreKS = bean.getTruststore();
                encryptionSymmetric = bean.isEncryptionSimmetric();
                aliasEncryptUser = bean.getUser();
                aliasEncryptPassword = bean.getPassword();
            }
            KeyStore signatureKS = null;
            KeyStore signatureTrustStoreKS = null;
            String aliasSignatureUser = null;
            String aliasSignaturePassword = null;
            if (signature) {
                SignatureBean bean = KeystoreUtils.getSenderSignatureBean(messageSecurityContext);
                signatureKS = bean.getKeystore();
                signatureTrustStoreKS = bean.getTruststore();
                aliasSignatureUser = bean.getUser();
                aliasSignaturePassword = bean.getPassword();
            }
            if (timestamp) {
                boolean precisionBoolean;
                Object ttlObject = messageSecurityContext.getOutgoingProperties().get("timeToLive");
                if (ttlObject == null) {
                    ttlObject = "300";
                }
                String ttl = (String)ttlObject;
                long ttlLong = -1L;
                try {
                    ttlLong = Long.parseLong(ttl);
                }
                catch (Exception e) {
                    throw new Exception("Indicazione timeToLive non corretta: " + e.getMessage());
                }
                msgSecCtx.getTimestampRequest().setTimeForExpiryMillis(ttlLong * 1000L);
                Object precisionObject = messageSecurityContext.getOutgoingProperties().get("precisionInMilliseconds");
                if (precisionObject == null) {
                    precisionObject = "true";
                }
                String precision = (String)precisionObject;
                try {
                    precisionBoolean = Boolean.parseBoolean(precision);
                }
                catch (Exception e) {
                    throw new Exception("Indicazione precisionInMilliseconds non corretta: " + e.getMessage());
                }
                msgSecCtx.setProperty("precisionInMilliseconds", (Object)precisionBoolean);
            }
            SecurityConfig securityConfig_encryption = null;
            if (encrypt) {
                Object encryptionKeyIdentifier;
                Object encryptionKeySizeObject = messageSecurityContext.getOutgoingProperties().get("encryptionKeySize");
                int encryptionKeySize = -1;
                if (encryptionKeySizeObject != null) {
                    encryptionKeySize = Integer.parseInt((String)encryptionKeySizeObject);
                }
                Object encryptionSymmetricAlgoritm = messageSecurityContext.getOutgoingProperties().get("encryptionSymAlgorithm");
                Object encryptionKeyTransport = messageSecurityContext.getOutgoingProperties().get("encryptionKeyTransportAlgorithm");
                if (encryptionKeySize > 0) {
                    msgSecCtx.getEncryptionRequest().setKeySize(encryptionKeySize);
                }
                if (encryptionSymmetricAlgoritm != null) {
                    msgSecCtx.getEncryptionRequest().setSymmetricKeyAlgoURI((String)encryptionSymmetricAlgoritm);
                }
                if (encryptionKeyTransport != null) {
                    msgSecCtx.getEncryptionRequest().setEncryptionAlgoURI((String)encryptionKeyTransport);
                }
                if ((encryptionKeyIdentifier = messageSecurityContext.getOutgoingProperties().get("encryptionKeyIdentifier")) != null) {
                    if ("DirectReference".equals(encryptionKeyIdentifier)) {
                        msgSecCtx.getEncryptionRequest().setKeyIdentifierType(SecurityRequest.KeyIdentifierType.BST_DIRECT_REFERENCE);
                    } else if ("IssuerSerial".equals(encryptionKeyIdentifier)) {
                        msgSecCtx.getEncryptionRequest().setKeyIdentifierType(SecurityRequest.KeyIdentifierType.ISSUER_SERIAL);
                    } else if ("SKIKeyIdentifier".equals(encryptionKeyIdentifier)) {
                        msgSecCtx.getEncryptionRequest().setKeyIdentifierType(SecurityRequest.KeyIdentifierType.SKI_KEY_IDENTIFIER);
                    } else if ("Thumbprint".equals(encryptionKeyIdentifier)) {
                        msgSecCtx.getEncryptionRequest().setKeyIdentifierType(SecurityRequest.KeyIdentifierType.THUMBPRINT_IDENTIFIER);
                    } else {
                        if (!"X509KeyIdentifier".equals(encryptionKeyIdentifier)) throw new Exception("encryptionKeyIdentifier not supported [" + encryptionKeyIdentifier + "]");
                        msgSecCtx.getEncryptionRequest().setKeyIdentifierType(SecurityRequest.KeyIdentifierType.X509_KEY_IDENTIFIER);
                    }
                } else {
                    msgSecCtx.getEncryptionRequest().setKeyIdentifierType(SecurityRequest.KeyIdentifierType.BST_DIRECT_REFERENCE);
                }
                msgSecCtx.getEncryptionRequest().setCertAlias(aliasEncryptUser);
                HashMap<String, String> passwordMap_encryption = new HashMap<String, String>();
                passwordMap_encryption.put(aliasEncryptUser, aliasEncryptPassword);
                if (encryptionTrustStoreKS == null) {
                    encryptionTrustStoreKS = encryptionKS;
                }
                securityConfig_encryption = new SecurityConfig(encryptionKS, encryptionTrustStoreKS, passwordMap_encryption);
                securityConfig_encryption.setSymmetricSharedKey(encryptionSymmetric);
            }
            SecurityConfig securityConfig_signature = null;
            if (signature) {
                Object c14nAlgoURI = messageSecurityContext.getOutgoingProperties().get("signatureC14nAlgorithm");
                Object digestAlgoURI = messageSecurityContext.getOutgoingProperties().get("signatureDigestAlgorithm");
                Object signatureAlgoURI = messageSecurityContext.getOutgoingProperties().get("signatureAlgorithm");
                Object wsiBPCompliant = messageSecurityContext.getOutgoingProperties().get("isBSPCompliant");
                Object signatureKeyIdentifier = messageSecurityContext.getOutgoingProperties().get("signatureKeyIdentifier");
                if (c14nAlgoURI != null) {
                    msgSecCtx.getSignatureRequest().setC14nAlgoURI((String)c14nAlgoURI);
                }
                if (digestAlgoURI != null) {
                    msgSecCtx.getSignatureRequest().setDigestAlgoURI((String)digestAlgoURI);
                }
                if (wsiBPCompliant != null) {
                    try {
                        msgSecCtx.getSignatureRequest().setWsiBPCompliant(Boolean.parseBoolean((String)wsiBPCompliant));
                    }
                    catch (Exception e) {
                        throw new Exception("isBSPCompliant con valore non valido (atteso true/false): [" + wsiBPCompliant + "]");
                    }
                } else {
                    msgSecCtx.getSignatureRequest().setWsiBPCompliant(true);
                }
                if (signatureAlgoURI == null) {
                    throw new Exception("signatureAlgorithm non fornito");
                }
                msgSecCtx.getSignatureRequest().setSignatureAlgoURI((String)signatureAlgoURI);
                if (signatureKeyIdentifier != null) {
                    if ("DirectReference".equals(signatureKeyIdentifier)) {
                        msgSecCtx.getSignatureRequest().setKeyIdentifierType(SecurityRequest.KeyIdentifierType.BST_DIRECT_REFERENCE);
                    } else if ("IssuerSerial".equals(signatureKeyIdentifier)) {
                        msgSecCtx.getSignatureRequest().setKeyIdentifierType(SecurityRequest.KeyIdentifierType.ISSUER_SERIAL);
                    } else if ("SKIKeyIdentifier".equals(signatureKeyIdentifier)) {
                        msgSecCtx.getSignatureRequest().setKeyIdentifierType(SecurityRequest.KeyIdentifierType.SKI_KEY_IDENTIFIER);
                    } else if ("Thumbprint".equals(signatureKeyIdentifier)) {
                        msgSecCtx.getSignatureRequest().setKeyIdentifierType(SecurityRequest.KeyIdentifierType.THUMBPRINT_IDENTIFIER);
                    } else {
                        if (!"X509KeyIdentifier".equals(signatureKeyIdentifier)) throw new Exception("signatureKeyIdentifier not supported [" + signatureKeyIdentifier + "]");
                        msgSecCtx.getSignatureRequest().setKeyIdentifierType(SecurityRequest.KeyIdentifierType.X509_KEY_IDENTIFIER);
                    }
                } else {
                    msgSecCtx.getSignatureRequest().setKeyIdentifierType(SecurityRequest.KeyIdentifierType.BST_DIRECT_REFERENCE);
                }
                msgSecCtx.getSignatureRequest().setCertAlias(aliasSignatureUser);
                HashMap<String, String> passwordMap_signature = new HashMap<String, String>();
                passwordMap_signature.put(aliasSignatureUser, aliasSignaturePassword);
                if (signatureTrustStoreKS == null) {
                    signatureTrustStoreKS = signatureKS;
                }
                securityConfig_signature = new SecurityConfig(signatureKS, signatureTrustStoreKS, passwordMap_signature);
            }
            actions = ((String)messageSecurityContext.getOutgoingProperties().get("action")).split(" ");
            boolean actionSignatureOrEncryptDo = false;
            for (int i = 0; i < actions.length; ++i) {
                if ("Encrypt".equals(actions[i].trim())) {
                    if (actionSignatureOrEncryptDo) {
                        // empty if block
                    }
                    encMsgProc.process(securityConfig_encryption, msgSecCtx);
                    actionSignatureOrEncryptDo = true;
                    continue;
                }
                if ("Signature".equals(actions[i].trim())) {
                    if (actionSignatureOrEncryptDo) {
                        byte[] xmlCifrato = this.xmlUtils.toByteArray(msgSecCtx.getDocument().getDocumentElement());
                        message.getSOAPPart().setContent((Source)new DOMSource(this.xmlUtils.newElement(xmlCifrato)));
                        signMsgProc.setMessage(message);
                    }
                    signMsgProc.process(securityConfig_signature, msgSecCtx);
                    actionSignatureOrEncryptDo = true;
                    continue;
                }
                if (!"Timestamp".equals(actions[i].trim())) continue;
                if (securityConfig_signature != null) {
                    timestampProc.process(securityConfig_signature, msgSecCtx);
                    continue;
                }
                if (securityConfig_encryption != null) {
                    timestampProc.process(securityConfig_encryption, msgSecCtx);
                    continue;
                }
                timestampProc.process(null, msgSecCtx);
            }
            return;
        }
        catch (Exception e) {
            Throwable t;
            String msg = Utilities.getInnerNotEmptyMessageException(e).getMessage();
            Throwable innerExc = Utilities.getLastInnerException(e);
            String innerMsg = null;
            if (innerExc != null) {
                innerMsg = innerExc.getMessage();
            }
            Object messaggio = null;
            if (msg != null) {
                messaggio = new String(msg);
                if (innerMsg != null && !innerMsg.equals(msg)) {
                    messaggio = (String)messaggio + " ; " + innerMsg;
                }
            } else if (innerMsg != null) {
                messaggio = innerMsg;
            }
            if (Utilities.existsInnerException((Throwable)e, ElementNotFoundException.class) && (t = Utilities.getLastInnerException(e)) instanceof ElementNotFoundException) {
                String notFoundMessage = t.getMessage();
                messaggio = t.getMessage().substring(0, notFoundMessage.indexOf("not found as a child of"));
                messaggio = (String)messaggio + "not found as a child of SoapEnvelope";
            }
            SecurityException wssException = new SecurityException(e.getMessage(), e);
            wssException.setMsgErrore((String)messaggio);
            throw wssException;
        }
    }
}

