/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.reference.Reference;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.IMessageSecurityReceiver;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityContext;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.SubErrorCodeSecurity;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.constants.SecurityConstants;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.engine.MessageUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.engine.WSSUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.ProcessPartialEncryptedMessage;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.ProcessSignedMessage;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.ProcessTimestampedMessage;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.SecurityConfig;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.EncryptionBean;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.KeystoreUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.utils.SignatureBean;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPPart;
import org.adroitlogic.ultraesb.api.Message;
import org.adroitlogic.ultraesb.core.MessageImpl;
import org.w3c.dom.Document;

public class MessageSecurityReceiver_soapbox
implements IMessageSecurityReceiver {
    private X509Certificate[] certificates = null;

    @Override
    public void process(MessageSecurityContext messageSecurityContext, OpenSPCoop2Message message, Busta busta) throws SecurityException {
        try {
            boolean decrypt = false;
            boolean signature = false;
            boolean timestamp = false;
            String[] actions = ((String)messageSecurityContext.getIncomingProperties().get("action")).split(" ");
            for (int i = 0; i < actions.length; ++i) {
                if ("Encrypt".equals(actions[i].trim())) {
                    decrypt = true;
                    continue;
                }
                if ("Signature".equals(actions[i].trim())) {
                    signature = true;
                    continue;
                }
                if (!"Timestamp".equals(actions[i].trim())) continue;
                timestamp = true;
            }
            SOAPPart sp = message.getSOAPPart();
            Object mustUnderstandObject = messageSecurityContext.getIncomingProperties().get("mustUnderstand");
            boolean mustUnderstand = false;
            if (mustUnderstandObject != null) {
                mustUnderstand = "true".equals(mustUnderstandObject);
            }
            org.adroitlogic.soapbox.MessageSecurityContext msgSecCtx = new org.adroitlogic.soapbox.MessageSecurityContext((Document)sp, (Message)new MessageImpl(true, null, "http"));
            Iterator<?> it = message.getAttachments();
            if (it != null) {
                while (it.hasNext()) {
                    AttachmentPart part = (AttachmentPart)it.next();
                    String contentId = part.getContentId();
                    if (contentId.startsWith("<")) {
                        contentId = contentId.substring(1);
                    }
                    if (contentId.endsWith(">")) {
                        contentId = contentId.substring(0, contentId.length() - 1);
                    }
                    msgSecCtx.setProperty(contentId, (Object)part);
                }
            }
            ProcessTimestampedMessage verifyTimestampedProc = null;
            if (timestamp) {
                verifyTimestampedProc = new ProcessTimestampedMessage();
                Object futureTtlObject = messageSecurityContext.getIncomingProperties().get("futureTimeToLive");
                if (futureTtlObject == null) {
                    futureTtlObject = "60";
                }
                String ttl = (String)futureTtlObject;
                long futureTtlLong = -1L;
                try {
                    futureTtlLong = Long.parseLong(ttl);
                }
                catch (Exception e) {
                    throw new Exception("Indicazione futureTimeToLive non corretta: " + e.getMessage());
                }
                msgSecCtx.setProperty("futureTimeToLive", (Object)(futureTtlLong * 1000L));
                Object strictObject = messageSecurityContext.getIncomingProperties().get("timestampStrict");
                if (strictObject == null) {
                    strictObject = "true";
                }
                String strict = (String)strictObject;
                boolean strictBoolean = false;
                try {
                    strictBoolean = Boolean.parseBoolean(strict);
                }
                catch (Exception e) {
                    throw new Exception("Indicazione timestampStrict non corretta: " + e.getMessage());
                }
                msgSecCtx.setProperty("timestampStrict", (Object)strictBoolean);
            }
            ProcessPartialEncryptedMessage decryptMsgProc = null;
            if (decrypt) {
                decryptMsgProc = (ProcessPartialEncryptedMessage)Class.forName(message.getProcessPartialEncryptedMessageClass()).getConstructor(new Class[0]).newInstance(new Object[0]);
                decryptMsgProc.setMessage(message);
                decryptMsgProc.setActor(messageSecurityContext.getActor());
                decryptMsgProc.setMustUnderstand(mustUnderstand);
            }
            ProcessSignedMessage signMsgProc = null;
            if (signature) {
                signMsgProc = new ProcessSignedMessage();
                signMsgProc.setMessage(message);
                signMsgProc.setActor(messageSecurityContext.getActor());
                signMsgProc.setMustUnderstand(mustUnderstand);
                signMsgProc.setUseXMLSec(messageSecurityContext.isUseXMLSec());
            }
            KeyStore decryptionKS = null;
            KeyStore decryptionTrustStoreKS = null;
            String aliasDecryptUser = null;
            String aliasDecryptPassword = null;
            boolean decryptionSymmetric = false;
            if (decrypt) {
                EncryptionBean bean = KeystoreUtils.getReceiverEncryptionBean(messageSecurityContext);
                decryptionKS = bean.getKeystore();
                decryptionTrustStoreKS = bean.getTruststore();
                decryptionSymmetric = bean.isEncryptionSimmetric();
                aliasDecryptUser = bean.getUser();
                aliasDecryptPassword = bean.getPassword();
            }
            KeyStore signatureKS = null;
            KeyStore signatureTrustStoreKS = null;
            String aliasSignatureUser = null;
            String aliasSignaturePassword = null;
            String crlPath = null;
            if (signature) {
                SignatureBean bean = KeystoreUtils.getReceiverSignatureBean(messageSecurityContext);
                signatureKS = bean.getKeystore();
                signatureTrustStoreKS = bean.getTruststore();
                aliasSignatureUser = bean.getUser();
                aliasSignaturePassword = bean.getPassword();
                crlPath = bean.getCrlPath();
            }
            SecurityConfig securityConfig_decryption = null;
            if (decrypt) {
                msgSecCtx.getEncryptionRequest().setCertAlias(aliasDecryptUser);
                HashMap<String, String> passwordMap_decryption = new HashMap<String, String>();
                passwordMap_decryption.put(aliasDecryptUser, aliasDecryptPassword);
                if (decryptionTrustStoreKS == null) {
                    decryptionTrustStoreKS = decryptionKS;
                }
                securityConfig_decryption = new SecurityConfig(decryptionKS, decryptionTrustStoreKS, passwordMap_decryption);
                securityConfig_decryption.setSymmetricSharedKey(decryptionSymmetric);
            }
            SecurityConfig securityConfig_signature = null;
            if (signature) {
                HashMap<String, String> passwordMap_signature = new HashMap<String, String>();
                passwordMap_signature.put(aliasSignatureUser, aliasSignaturePassword);
                if (signatureTrustStoreKS == null) {
                    signatureTrustStoreKS = signatureKS;
                }
                securityConfig_signature = new SecurityConfig(signatureKS, signatureTrustStoreKS, passwordMap_signature, crlPath);
            }
            actions = ((String)messageSecurityContext.getIncomingProperties().get("action")).split(" ");
            for (int i = actions.length - 1; i >= 0; --i) {
                if ("Encrypt".equals(actions[i].trim())) {
                    decryptMsgProc.process(securityConfig_decryption, msgSecCtx);
                    continue;
                }
                if ("Signature".equals(actions[i].trim())) {
                    signMsgProc.process(securityConfig_signature, msgSecCtx);
                    this.certificates = signMsgProc.getCertificates();
                    continue;
                }
                if (!"Timestamp".equals(actions[i].trim())) continue;
                if (securityConfig_signature != null) {
                    verifyTimestampedProc.process(securityConfig_signature, msgSecCtx);
                    continue;
                }
                if (securityConfig_decryption != null) {
                    verifyTimestampedProc.process(securityConfig_decryption, msgSecCtx);
                    continue;
                }
                verifyTimestampedProc.process(null, msgSecCtx);
            }
        }
        catch (Exception e) {
            SecurityException wssException = new SecurityException(e.getMessage(), e);
            String msg = Utilities.getInnerNotEmptyMessageException(e).getMessage();
            Throwable innerExc = Utilities.getLastInnerException(e);
            String innerMsg = null;
            if (innerExc != null) {
                innerMsg = innerExc.getMessage();
            }
            Object messaggio = null;
            if (msg != null) {
                messaggio = new String(msg);
                if (innerMsg != null && !innerMsg.equals(msg)) {
                    messaggio = (String)messaggio + " ; " + innerMsg;
                }
            } else if (innerMsg != null) {
                messaggio = innerMsg;
            }
            wssException.setMsgErrore((String)messaggio);
            boolean signature = false;
            boolean encrypt = false;
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(bout);
                e.printStackTrace(printStream);
                bout.flush();
                printStream.flush();
                bout.close();
                printStream.close();
                if (bout.toString().contains("ProcessSignedMessage")) {
                    signature = true;
                } else if (bout.toString().contains("Signature verification failed")) {
                    signature = true;
                } else if (bout.toString().contains("Message is not signed")) {
                    signature = true;
                } else if (bout.toString().contains("ProcessPartialEncryptedMessage")) {
                    encrypt = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (signature) {
                wssException.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA);
            } else if (encrypt) {
                wssException.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA_CIFRATURA_NON_VALIDA);
            } else {
                wssException.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA);
            }
            throw wssException;
        }
    }

    private void refreshAttachments(OpenSPCoop2Message openspcoop2Message) throws SOAPException {
        AttachmentPart ap;
        Iterator<?> itAp = openspcoop2Message.getAttachments();
        Vector<AttachmentPart> v = new Vector<AttachmentPart>();
        while (itAp.hasNext()) {
            ap = (AttachmentPart)itAp.next();
            v.add(ap);
        }
        openspcoop2Message.removeAllAttachments();
        while (v.size() > 0) {
            ap = (AttachmentPart)v.remove(0);
            AttachmentPart apNew = openspcoop2Message.createAttachmentPart();
            apNew.setDataHandler(ap.getDataHandler());
            Iterator itMhs = ap.getAllMimeHeaders();
            while (itMhs.hasNext()) {
                MimeHeader mh = (MimeHeader)itMhs.next();
                if ("Content-Transfer-Encoding".equals(mh.getName())) continue;
                apNew.addMimeHeader(mh.getName(), mh.getValue());
            }
            openspcoop2Message.addAttachmentPart(apNew);
        }
    }

    @Override
    public String getCertificate() throws SecurityException {
        if (this.certificates != null && this.certificates.length > 0) {
            return this.certificates[0].getSubjectX500Principal().toString();
        }
        return null;
    }

    @Override
    public List<Reference> getDirtyElements(MessageSecurityContext messageSecurityContext, OpenSPCoop2Message message) throws SecurityException {
        return WSSUtilities.getDirtyElements(messageSecurityContext, message);
    }

    @Override
    public Map<QName, QName> checkEncryptSignatureParts(MessageSecurityContext messageSecurityContext, List<Reference> elementsToClean, OpenSPCoop2Message message, List<SubErrorCodeSecurity> codiciErrore) throws SecurityException {
        return MessageUtilities.checkEncryptSignatureParts(messageSecurityContext, elementsToClean, message, codiciErrore, SecurityConstants.QNAME_WSS_ELEMENT_SECURITY);
    }

    @Override
    public void checkEncryptionPartElements(Map<QName, QName> notResolved, OpenSPCoop2Message message, List<SubErrorCodeSecurity> erroriRilevati) throws SecurityException {
        MessageUtilities.checkEncryptionPartElements(notResolved, message, erroriRilevati);
    }

    @Override
    public void cleanDirtyElements(MessageSecurityContext messageSecurityContext, OpenSPCoop2Message message, List<Reference> elementsToClean, boolean detachHeaderWSSecurity, boolean removeAllIdRef) throws SecurityException {
        WSSUtilities.cleanDirtyElements(messageSecurityContext, message, elementsToClean, detachHeaderWSSecurity, removeAllIdRef);
    }
}

