/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.MessageUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageParseResult;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.reference.Reference;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityContextParameters;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.SubErrorCodeSecurity;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.constants.SecurityConstants;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.engine.MessageSecurityContext_impl;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.engine.MessageUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.EncryptPartialMessageProcessor;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.MessageSecurityContext_soapbox;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.ProcessPartialEncryptedMessage;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.ProcessSignedMessage;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.ProcessTimestampedMessage;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.SecurityConfig;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.SignPartialMessageProcessor;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.TimestampMessageProcessor;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.WSSUtils;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.adroitlogic.soapbox.MessageSecurityContext;
import org.adroitlogic.soapbox.SecurityRequest;
import org.adroitlogic.ultraesb.api.Message;
import org.adroitlogic.ultraesb.core.MessageImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EngineTest {
    private static final String TEST_MSG_1 = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">\n<soapenv:Body>\n<something xmlns=\"http://test.openspcoop.org/esempio\"><ciao>CIAOCONTENT</ciao></something>\n<other>OTHERCONTENT</other></soapenv:Body>\n</soapenv:Envelope>";
    private static final String TEST_ATTACH_XML = "<testAllegato>GIOVANNI</testAllegato>";

    public static void main(String[] args) {
        try {
            ByteArrayInputStream messageInput = new ByteArrayInputStream(TEST_MSG_1.getBytes());
            QName ciaoName = new QName("http://test.openspcoop.org/esempio", "ciao");
            QName otherName = new QName("other");
            QName body = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body");
            OpenSPCoop2MessageParseResult pr = OpenSPCoop2MessageFactory.getMessageFactory().createMessage(messageInput, null, false, null, null, true, "/tmp", "1024");
            OpenSPCoop2Message openspcoop2Message = pr.getMessage_throwParseException();
            AttachmentPart attachmentPart = openspcoop2Message.createAttachmentPart();
            attachmentPart.setContentId("<ID-11111-TEXT-PLAIN-1111>");
            attachmentPart.setMimeHeader("Content-Type", "text/plain");
            attachmentPart.setContent((Object)"prova", "text/plain");
            openspcoop2Message.addAttachmentPart(attachmentPart);
            AttachmentPart attachmentPart2 = openspcoop2Message.createAttachmentPart();
            attachmentPart2.setContentId("<ID-2222-TEXT-XML-22222>");
            attachmentPart2.setMimeHeader("Content-Type", "text/xml");
            attachmentPart2.setContent((Object)TEST_ATTACH_XML, "text/xml");
            openspcoop2Message.addAttachmentPart(attachmentPart2);
            System.out.println("-- MESSAGGIO INIZIALE --\n\n");
            System.out.println(MessageUtils.dumpMessage(openspcoop2Message, true));
            String actorWSS = "http://openspcoop.org/wss";
            boolean mustUnderstand = true;
            WSSUtils.initWSSecurityHeader(openspcoop2Message, actorWSS, mustUnderstand);
            MessageSecurityContextParameters wssContextParameters = new MessageSecurityContextParameters();
            wssContextParameters.setUseActorDefaultIfNotDefined(true);
            wssContextParameters.setActorDefault("prova");
            wssContextParameters.setLog(LoggerWrapperFactory.getLogger(EngineTest.class));
            wssContextParameters.setFunctionAsClient(true);
            wssContextParameters.setPrefixWsuId("prefix");
            MessageSecurityContext_impl wssContext = new MessageSecurityContext_impl(wssContextParameters);
            try {
                MessageSecurityContext_soapbox s = new MessageSecurityContext_soapbox();
                s.init(wssContext);
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
            EncryptPartialMessageProcessor encMsgProc = new EncryptPartialMessageProcessor();
            encMsgProc.setActor(actorWSS);
            encMsgProc.setMustUnderstand(mustUnderstand);
            encMsgProc.setMessage(openspcoop2Message);
            encMsgProc.addElementToEncrypt(ciaoName, true);
            encMsgProc.addElementToEncrypt(otherName, false);
            encMsgProc.addAttachmentToEncrypt(attachmentPart, true);
            encMsgProc.addAttachmentToEncrypt(attachmentPart2, true);
            TimestampMessageProcessor timestampProc = new TimestampMessageProcessor();
            SOAPPart sp = openspcoop2Message.getSOAPPart();
            MessageSecurityContext pdMsgSecCtx = new MessageSecurityContext((Document)sp);
            HashMap<String, String> pdPasswordMap = new HashMap<String, String>();
            pdPasswordMap.put("pd", "certpd");
            pdPasswordMap.put("symmetric", "changeit");
            KeyStore pdKsAsymmetric = KeyStore.getInstance(KeyStore.getDefaultType());
            pdKsAsymmetric.load(new FileInputStream("/var/openspcoop2/keys/pd.jks"), "keypd".toCharArray());
            SecurityConfig pdSecConfigAsymmetric = new SecurityConfig(pdKsAsymmetric, pdKsAsymmetric, pdPasswordMap);
            KeyStore pdKsSymmetric = KeyStore.getInstance("JCEKS");
            pdKsSymmetric.load(new FileInputStream("/var/openspcoop2/keys/symmetricStore.jks"), "changeit".toCharArray());
            SecurityConfig pdSecConfigSymmetric = new SecurityConfig(pdKsSymmetric, pdKsSymmetric, pdPasswordMap);
            pdSecConfigSymmetric.setSymmetricSharedKey(true);
            timestampProc.process(pdSecConfigSymmetric, pdMsgSecCtx);
            pdMsgSecCtx.getEncryptionRequest().setCertAlias("symmetric");
            pdMsgSecCtx.getEncryptionRequest().setEncryptionAlgoURI("http://www.w3.org/2001/04/xmlenc#kw-tripledes");
            pdMsgSecCtx.getEncryptionRequest().setSymmetricKeyAlgoURI("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            pdMsgSecCtx.getEncryptionRequest().setKeySize(168);
            encMsgProc.process(pdSecConfigSymmetric, pdMsgSecCtx);
            openspcoop2Message.getSOAPPart().setContent((Source)new DOMSource((Node)openspcoop2Message.getSOAPPart().getEnvelope()));
            SignPartialMessageProcessor signMsgProc = (SignPartialMessageProcessor)Class.forName(openspcoop2Message.getSignPartialMessageProcessorClass()).getConstructor(new Class[0]).newInstance(new Object[0]);
            signMsgProc.setActor(actorWSS);
            signMsgProc.setMustUnderstand(mustUnderstand);
            signMsgProc.setMessage(openspcoop2Message);
            signMsgProc.addElementToSign(body, true);
            Iterator<?> itAttach = openspcoop2Message.getAttachments();
            signMsgProc.addAttachmentsToSign((AttachmentPart)itAttach.next(), true);
            signMsgProc.addAttachmentsToSign((AttachmentPart)itAttach.next(), true);
            pdMsgSecCtx.getSignatureRequest().setCertAlias("pd");
            pdMsgSecCtx.getSignatureRequest().setKeyIdentifierType(SecurityRequest.KeyIdentifierType.ISSUER_SERIAL);
            pdMsgSecCtx.getSignatureRequest().setC14nAlgoURI("http://www.w3.org/2001/10/xml-exc-c14n#");
            pdMsgSecCtx.getSignatureRequest().setDigestAlgoURI("http://www.w3.org/2000/09/xmldsig#sha1");
            pdMsgSecCtx.getSignatureRequest().setWsiBPCompliant(true);
            signMsgProc.process(pdSecConfigAsymmetric, pdMsgSecCtx);
            System.out.println("-- MESSAGGIO DOPO AVER APPLICATO LA SICUREZZA --\n\n");
            System.out.println(MessageUtils.dumpMessage(openspcoop2Message, true));
            FileOutputStream fout2 = new FileOutputStream("/tmp/SENT");
            openspcoop2Message.writeTo(fout2, true);
            fout2.flush();
            fout2.close();
            String contentType = openspcoop2Message.getContentType();
            System.out.println("ContentType [" + contentType + "]");
            FileInputStream is2 = new FileInputStream("/tmp/SENT");
            pr = OpenSPCoop2MessageFactory.getMessageFactory().createMessage(is2, null, false, contentType, null, true, "/tmp", "1024");
            openspcoop2Message = pr.getMessage_throwParseException();
            ProcessPartialEncryptedMessage decryptMsgProc = (ProcessPartialEncryptedMessage)Class.forName(openspcoop2Message.getProcessPartialEncryptedMessageClass()).getConstructor(new Class[0]).newInstance(new Object[0]);
            decryptMsgProc.setActor(actorWSS);
            decryptMsgProc.setMustUnderstand(mustUnderstand);
            decryptMsgProc.setMessage(openspcoop2Message);
            ProcessSignedMessage verifySignMsgProc = new ProcessSignedMessage();
            verifySignMsgProc.setActor(actorWSS);
            verifySignMsgProc.setMustUnderstand(mustUnderstand);
            verifySignMsgProc.setMessage(openspcoop2Message);
            ProcessTimestampedMessage verifyTimestampedProc = new ProcessTimestampedMessage();
            MessageSecurityContext paMsgSecCtx = new MessageSecurityContext((Document)openspcoop2Message.getSOAPPart(), (Message)new MessageImpl(true, null, "http"));
            Iterator<?> it = openspcoop2Message.getAttachments();
            while (it.hasNext()) {
                AttachmentPart part = (AttachmentPart)it.next();
                String contentId = part.getContentId();
                if (contentId.startsWith("<")) {
                    contentId = contentId.substring(1);
                }
                if (contentId.endsWith(">")) {
                    contentId = contentId.substring(0, contentId.length() - 1);
                }
                paMsgSecCtx.setProperty(contentId, (Object)part);
            }
            HashMap<String, String> paPasswordMap = new HashMap<String, String>();
            paPasswordMap.put("pa", "certpa");
            paPasswordMap.put("symmetric", "changeit");
            KeyStore paKsAsymmetric = KeyStore.getInstance(KeyStore.getDefaultType());
            paKsAsymmetric.load(new FileInputStream("/var/openspcoop2/keys/pa.jks"), "keypa".toCharArray());
            SecurityConfig paSecConfigAsymmetric = new SecurityConfig(paKsAsymmetric, paKsAsymmetric, paPasswordMap);
            KeyStore paKsSymmetric = KeyStore.getInstance("JCEKS");
            paKsSymmetric.load(new FileInputStream("/var/openspcoop2/keys/symmetricStore.jks"), "changeit".toCharArray());
            SecurityConfig paSecConfigSymmetric = new SecurityConfig(paKsSymmetric, paKsSymmetric, paPasswordMap);
            paSecConfigSymmetric.setSymmetricSharedKey(true);
            paMsgSecCtx.getEncryptionRequest().setCertAlias("symmetric");
            List<Reference> elementsToClean = openspcoop2Message.getWSSDirtyElements(actorWSS, mustUnderstand);
            Hashtable<String, Object> wssProperties = new Hashtable<String, Object>();
            wssProperties.put("encryptionParts", "{Content}{http://test.openspcoop.org/esempio}ciao;{Element}{}other;{Content}{Attach}{*}");
            wssProperties.put("signatureParts", "{Content}{http://schemas.xmlsoap.org/soap/envelope/}Body;{Content}{Attach}{*}");
            wssContext.setIncomingProperties(wssProperties);
            ArrayList<SubErrorCodeSecurity> listaErroriRiscontrati = new ArrayList<SubErrorCodeSecurity>();
            Map<QName, QName> notResolvedMap = MessageUtilities.checkEncryptSignatureParts(wssContext, elementsToClean, openspcoop2Message, listaErroriRiscontrati, SecurityConstants.QNAME_WSS_ELEMENT_SECURITY);
            if (listaErroriRiscontrati.size() > 0) {
                for (SubErrorCodeSecurity subCodice : listaErroriRiscontrati) {
                    System.out.println("SubCodice: " + subCodice.getMsgErrore());
                    System.out.println("SubCodice Tipo: " + subCodice.getTipo());
                    System.out.println("SubCodice Name:" + subCodice.getName());
                    System.out.println("SubCodice Namespace:" + subCodice.getNamespace());
                    System.out.println("SubCodice Subcodice:" + subCodice.getSubCodice());
                }
                throw new Exception("Riscontrati " + listaErroriRiscontrati.size() + "nel processamento");
            }
            verifySignMsgProc.process(paSecConfigAsymmetric, paMsgSecCtx);
            decryptMsgProc.process(paSecConfigSymmetric, paMsgSecCtx);
            verifyTimestampedProc.process(paSecConfigSymmetric, paMsgSecCtx);
            MessageUtilities.checkEncryptionPartElements(notResolvedMap, openspcoop2Message, listaErroriRiscontrati);
            if (listaErroriRiscontrati.size() > 0) {
                for (SubErrorCodeSecurity subCodice : listaErroriRiscontrati) {
                    System.out.println("SubCodice: " + subCodice.getMsgErrore());
                    System.out.println("SubCodice Tipo: " + subCodice.getTipo());
                    System.out.println("SubCodice Name:" + subCodice.getName());
                    System.out.println("SubCodice Namespace:" + subCodice.getNamespace());
                    System.out.println("SubCodice Subcodice:" + subCodice.getSubCodice());
                }
                throw new Exception("Riscontrati " + listaErroriRiscontrati.size() + "nel processamento");
            }
            openspcoop2Message.cleanWSSDirtyElements(actorWSS, mustUnderstand, elementsToClean, true, false);
            System.out.println("-- MESSAGGIO DOPO AVER ELIMINATO LA SICUREZZA --\n\n");
            System.out.println(MessageUtils.dumpMessage(openspcoop2Message, true));
            System.out.println("OUT");
            openspcoop2Message.writeTo(System.out, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

