/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox;

import com.sun.xml.wss.core.EncryptedDataHeaderBlock;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.SecurityConfig;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.SymmetricCryptoUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.WSSUtils;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import org.adroitlogic.soapbox.CryptoSupport;
import org.adroitlogic.soapbox.CryptoUtil;
import org.adroitlogic.soapbox.EncryptionRequest;
import org.adroitlogic.soapbox.InvalidMessageDataException;
import org.adroitlogic.soapbox.InvalidOptionException;
import org.adroitlogic.soapbox.MessageSecurityContext;
import org.adroitlogic.soapbox.Processor;
import org.adroitlogic.soapbox.SecurityFailureException;
import org.adroitlogic.soapbox.SecurityRequest;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.utils.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EncryptPartialMessageProcessor
implements Processor {
    private static final Logger logger = LoggerWrapperFactory.getLogger(EncryptPartialMessageProcessor.class);
    private List<QName> elements = new ArrayList<QName>();
    private List<Boolean> elementsEncryptContent = new ArrayList<Boolean>();
    private Map<AttachmentPart, Boolean> attachments = new HashMap<AttachmentPart, Boolean>();
    private OpenSPCoop2Message message;
    private String actor;
    private boolean mustUnderstand;

    public void setMessage(OpenSPCoop2Message message) {
        this.message = message;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public void setMustUnderstand(boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
    }

    public void addElementToEncrypt(QName element, boolean content) {
        this.elements.add(element);
        this.elementsEncryptContent.add(content);
    }

    public void addAttachmentToEncrypt(AttachmentPart part, boolean contentOnly) {
        this.attachments.put(part, contentOnly);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(org.adroitlogic.soapbox.SecurityConfig secConfig, MessageSecurityContext msgSecCtx) {
        Document doc = msgSecCtx.getDocument();
        Element wsseSecurityElem = null;
        try {
            wsseSecurityElem = WSSUtils.getWSSecurityHeader(msgSecCtx.getDocument(), this.actor, this.mustUnderstand);
        }
        catch (Exception e) {
            throw new SecurityFailureException(e.getMessage(), (Throwable)e);
        }
        if (CryptoUtil.getFirstChildOrNull((Element)wsseSecurityElem, (String)"http://www.w3.org/2001/04/xmlenc#", (String)"EncryptedKey") != null) {
            throw new InvalidMessageDataException("Message is already encrypted");
        }
        Element env = doc.getDocumentElement();
        String secTokenRef = CryptoUtil.getRandomId();
        if (this.elements.isEmpty() && this.attachments.isEmpty()) {
            this.elements.add(new QName(env.getNamespaceURI(), "Body"));
            this.elementsEncryptContent.add(true);
        }
        try {
            this.processElements(msgSecCtx, secTokenRef);
            this.processAttachments(msgSecCtx);
        }
        catch (Exception e) {
            throw new SecurityFailureException("Error encrypting an element or an attachment", (Throwable)e);
        }
        Cipher cipher = null;
        String cipherValue = null;
        EncryptionRequest encReq = msgSecCtx.getEncryptionRequest();
        try {
            SecurityConfig secConfigOpenSPCoop = (SecurityConfig)secConfig;
            Security.addProvider((Provider)new BouncyCastleProvider());
            cipher = CryptoSupport.getInstance().getCipherInstance(encReq.getEncryptionAlgoURI());
            byte[] encKey = null;
            SecretKey encKeyObject = null;
            try {
                encKeyObject = encReq.getEphemeralKey();
                encKey = encReq.getEphemeralKey().getEncoded();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            if (secConfigOpenSPCoop.isSymmetricSharedKey()) {
                int blockSize = cipher.getBlockSize();
                if (blockSize == 0) {
                    blockSize = 8;
                }
                cipher.init(3, secConfigOpenSPCoop.getSymmetricKey(encReq.getCertAlias()), new IvParameterSpec(new byte[blockSize]));
                cipherValue = Base64.encode((byte[])cipher.wrap(encKeyObject));
            } else {
                cipher.init(1, secConfig.getTrustedCertificatesByAlias(encReq.getCertAlias())[0]);
                if (cipher.getBlockSize() > 0 && cipher.getBlockSize() < encKey.length) {
                    throw new SecurityFailureException("Public key algorithm too weak to encrypt symmetric key  - cipher block size : " + cipher.getBlockSize() + " encrypted bytes length : " + encKey.length);
                }
                cipherValue = Base64.encode((byte[])cipher.doFinal(encKey));
            }
        }
        catch (InvalidKeyException e) {
            try {
                e.printStackTrace();
                throw new SecurityFailureException("Error preparing cipher for encryption : " + encReq.getEncryptionAlgoURI());
                catch (Exception e2) {
                    throw new SecurityFailureException("Failed to encrypt session key", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                CryptoSupport.getInstance().returnCipherInstance(cipher);
                throw throwable;
            }
        }
        CryptoSupport.getInstance().returnCipherInstance(cipher);
        Element encryptedKeyElem = this.createEncryptedKey(doc, encReq, cipherValue, secConfig, msgSecCtx, secTokenRef);
        Element firstChild = CryptoUtil.getFirstElementChild((Element)wsseSecurityElem);
        if (firstChild == null) {
            wsseSecurityElem.appendChild(encryptedKeyElem);
            return;
        }
        wsseSecurityElem.insertBefore(encryptedKeyElem, firstChild);
    }

    private Element createEncryptedKey(Document doc, EncryptionRequest encReq, String cipherValue, org.adroitlogic.soapbox.SecurityConfig secConfig, MessageSecurityContext msgSecCtx, String referenceId) {
        Element encryptedKeyElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptedKey");
        encryptedKeyElem.setAttribute("Id", referenceId);
        Element encryptionMethodElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptionMethod");
        encryptionMethodElem.setAttribute("Algorithm", encReq.getEncryptionAlgoURI());
        encryptedKeyElem.appendChild(encryptionMethodElem);
        SecurityConfig securityConfigOpenSPCoop = (SecurityConfig)secConfig;
        if (securityConfigOpenSPCoop.isSymmetricSharedKey()) {
            encryptedKeyElem.appendChild(SymmetricCryptoUtils.createKeyInfoElement(doc, (SecurityRequest)encReq, msgSecCtx, secConfig));
        } else {
            encryptedKeyElem.appendChild(WSSUtils.createKeyInfoElement(doc, (SecurityRequest)encReq, msgSecCtx, secConfig));
        }
        Element cipherDataElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherData");
        Element cipherValueElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherValue");
        cipherValueElem.setTextContent(cipherValue);
        cipherDataElem.appendChild(cipherValueElem);
        encryptedKeyElem.appendChild(cipherDataElem);
        Element referenceListElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList");
        for (String id : msgSecCtx.getEncryptedReferenceList()) {
            Element dataReferenceElem = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:DataReference");
            dataReferenceElem.setAttribute("URI", "#" + id);
            referenceListElem.appendChild(dataReferenceElem);
        }
        encryptedKeyElem.appendChild(referenceListElem);
        return encryptedKeyElem;
    }

    private void processElements(MessageSecurityContext msgSecCtx, String referenceId) throws Exception {
        Document doc = msgSecCtx.getDocument();
        Element env = doc.getDocumentElement();
        int index = 0;
        for (QName name : this.elements) {
            Element encElement = CryptoUtil.getFirstChild((Element)env, (String)name.getNamespaceURI(), (String)name.getLocalPart());
            EncryptionRequest encReq = msgSecCtx.getEncryptionRequest();
            String symEncAlgo = encReq.getSymmetricKeyAlgoURI();
            XMLCipher xmlCipher = null;
            try {
                xmlCipher = CryptoSupport.getInstance().getXMLCipher(symEncAlgo);
                xmlCipher.init(1, (Key)msgSecCtx.getEncryptionRequest().getEphemeralKey());
                EncryptedData encData = xmlCipher.getEncryptedData();
                String encEltId = CryptoUtil.getRandomId();
                encData.setId(encEltId);
                KeyInfo keyInfo = new KeyInfo(doc);
                Element securityTokenReferenceElem = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:SecurityTokenReference");
                securityTokenReferenceElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
                Element referenceElem = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference");
                referenceElem.setAttribute("URI", "#" + referenceId);
                securityTokenReferenceElem.appendChild(referenceElem);
                keyInfo.addUnknownElement(securityTokenReferenceElem);
                encData.setKeyInfo(keyInfo);
                xmlCipher.doFinal(encElement.getOwnerDocument(), encElement, this.elementsEncryptContent.get(index++).booleanValue());
                msgSecCtx.addEncryptedReference(encEltId);
            }
            catch (XMLEncryptionException e) {
                throw new InvalidOptionException("Unsupported algorithm : " + symEncAlgo, (Throwable)e);
            }
            finally {
                try {
                    CryptoSupport.getInstance().returnXMLCipherInstance(symEncAlgo, xmlCipher);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static byte[] serializeHeaders(List<MimeHeader> mhs) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            StringBuffer line = new StringBuffer();
            for (MimeHeader mh : mhs) {
                String name = mh.getName();
                String vlue = mh.getValue();
                line.append(name);
                line.append(":");
                line.append(vlue);
                line.append("\r\n");
            }
            line.append("\r\n");
            byte[] b = line.toString().getBytes("US-ASCII");
            baos.write(b, 0, b.length);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAttachments(MessageSecurityContext msgSecCtx) throws Exception {
        if (this.attachments.size() <= 0) {
            return;
        }
        Cipher _attachmentEncryptor = null;
        try {
            EncryptionRequest encReq = msgSecCtx.getEncryptionRequest();
            String encAlgo = encReq.getSymmetricKeyAlgoURI();
            _attachmentEncryptor = CryptoSupport.getInstance().getCipherInstance(encAlgo);
            _attachmentEncryptor.init(1, encReq.getEphemeralKey());
            for (AttachmentPart p : this.attachments.keySet()) {
                boolean contentOnly = this.attachments.get(p);
                EncryptedDataHeaderBlock edhb = new EncryptedDataHeaderBlock();
                String id = CryptoUtil.getRandomId();
                edhb.setId(id);
                edhb.setType(contentOnly ? "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Only" : "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Complete");
                edhb.setMimeType(p.getContentType());
                Object uri = p.getContentId();
                uri = uri != null ? (((String)uri).startsWith("<") ? "cid:" + ((String)uri).substring(1, ((String)uri).length() - 1) : "cid:" + (String)uri) : p.getContentLocation();
                edhb.getCipherReference(true, (String)uri);
                edhb.setEncryptionMethod(encAlgo);
                edhb.addTransform(contentOnly ? "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Ciphertext-Transform" : "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Complete-Transform");
                AttachmentPart encPart = EncryptPartialMessageProcessor.encryptAttachment(p, contentOnly, _attachmentEncryptor, this.message.createAttachmentPart());
                MimeHeaders mhs = new MimeHeaders();
                mhs.addHeader("Content-ID", p.getContentId());
                this.message.removeAttachments(mhs);
                this.message.addAttachmentPart(encPart);
                msgSecCtx.addEncryptedReference(edhb.getId());
                SOAPHeaderElement wssHeader = WSSUtils.getWSSecurityHeader(this.message, this.actor, this.mustUnderstand);
                SOAPElement elementToInsert = edhb.getAsSoapElement();
                wssHeader.addChildElement(elementToInsert);
            }
            this.attachments.clear();
        }
        catch (Throwable throwable) {
            CryptoSupport.getInstance().returnCipherInstance(_attachmentEncryptor);
            throw throwable;
        }
        CryptoSupport.getInstance().returnCipherInstance(_attachmentEncryptor);
    }

    private static AttachmentPart encryptAttachment(AttachmentPart part, boolean contentOnly, Cipher cipher, AttachmentPart encPart) throws Exception {
        byte[] cipherInput = contentOnly ? EncryptPartialMessageProcessor.getBytesFromAttachments(part.getDataHandler()) : EncryptPartialMessageProcessor.getCipherInput(part);
        byte[] cipherOutput = cipher.doFinal(cipherInput);
        byte[] iv = cipher.getIV();
        byte[] encryptedBytes = new byte[iv.length + cipherOutput.length];
        System.arraycopy(iv, 0, encryptedBytes, 0, iv.length);
        System.arraycopy(cipherOutput, 0, encryptedBytes, iv.length, cipherOutput.length);
        int cLength = encryptedBytes.length;
        String cType = "application/octet-stream";
        String uri = part.getContentId();
        if (uri != null) {
            encPart.setMimeHeader("Content-ID", uri);
        } else {
            uri = part.getContentLocation();
            if (uri != null) {
                encPart.setMimeHeader("Content-Location", uri);
            }
        }
        encPart.setContentType(cType);
        encPart.setMimeHeader("Content-Length", Integer.toString(cLength));
        encPart.setMimeHeader("Content-Transfer-Encoding", "base64");
        EncryptedAttachmentDataHandler dh = new EncryptedAttachmentDataHandler(new EncryptedAttachmentDataSource(encryptedBytes));
        encPart.setDataHandler((DataHandler)dh);
        cipherInput = contentOnly ? EncryptPartialMessageProcessor.getBytesFromAttachments(encPart.getDataHandler()) : EncryptPartialMessageProcessor.getCipherInput(encPart);
        return encPart;
    }

    private static byte[] getCipherInput(AttachmentPart part) throws Exception, SOAPException, IOException {
        byte[] headers = EncryptPartialMessageProcessor.getAttachmentHeaders(part.getAllMimeHeaders());
        byte[] content = EncryptPartialMessageProcessor.getBytesFromAttachments(part.getDataHandler());
        byte[] cipherInput = new byte[headers.length + content.length];
        System.arraycopy(headers, 0, cipherInput, 0, headers.length);
        System.arraycopy(content, 0, cipherInput, headers.length, content.length);
        return cipherInput;
    }

    private static byte[] getAttachmentHeaders(Iterator<MimeHeader> mhItr) throws Exception {
        ArrayList<MimeHeader> mhs = new ArrayList<MimeHeader>();
        while (mhItr.hasNext()) {
            mhs.add(mhItr.next());
        }
        return EncryptPartialMessageProcessor.serializeHeaders(mhs);
    }

    private static byte[] getBytesFromAttachments(DataHandler dh) throws SOAPException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        dh.writeTo((OutputStream)baos);
        return Base64.encode((byte[])baos.toByteArray()).getBytes("US-ASCII");
    }

    private static class EncryptedAttachmentDataSource
    implements DataSource {
        byte[] datasource;

        EncryptedAttachmentDataSource(byte[] ds) {
            this.datasource = ds;
        }

        public String getContentType() {
            return "application/octet-stream";
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.datasource);
        }

        public String getName() {
            return "Encrypted Attachment DataSource";
        }

        public OutputStream getOutputStream() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.datasource, 0, this.datasource.length);
            return baos;
        }
    }

    private static class EncryptedAttachmentDataHandler
    extends DataHandler {
        EncryptedAttachmentDataHandler(DataSource ds) {
            super(ds);
        }

        public void writeTo(OutputStream os) throws IOException {
            ((ByteArrayOutputStream)this.getDataSource().getOutputStream()).writeTo(os);
        }
    }
}

