/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.signature;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.signature.EnvelopeIdResolverUtilities;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import java.util.Iterator;
import javax.xml.soap.AttachmentPart;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.utils.URI;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLSecEnvelopeIdResolver
extends ResourceResolverSpi {
    private static final Logger logger = LoggerWrapperFactory.getLogger(XMLSecEnvelopeIdResolver.class);
    private OpenSPCoop2Message message = null;

    public static synchronized ResourceResolverSpi getInstance(OpenSPCoop2Message message) {
        return new XMLSecEnvelopeIdResolver(message);
    }

    private XMLSecEnvelopeIdResolver(OpenSPCoop2Message message) {
        this.message = message;
    }

    public boolean engineIsThreadSafe() {
        return true;
    }

    public XMLSignatureInput engineResolve(Attr uri, String BaseURI) throws ResourceResolverException {
        String wsuId = null;
        boolean attach = false;
        if (uri.getNodeValue().startsWith("#")) {
            wsuId = uri.getNodeValue().substring(1);
        } else if (uri.getNodeValue().startsWith("cid:")) {
            wsuId = uri.getNodeValue().substring(4);
            attach = true;
        } else {
            throw new ResourceResolverException("Cannot resoulve uri " + uri.getNodeValue(), uri.getLocalName(), BaseURI);
        }
        Document doc = uri.getOwnerDocument();
        if (logger.isDebugEnabled()) {
            logger.debug("Attempting to resolve : #" + wsuId);
        }
        if (attach) {
            Iterator<?> it = this.message.getAttachments();
            while (it.hasNext()) {
                AttachmentPart ap = (AttachmentPart)it.next();
                String contentId = ap.getContentId();
                if (contentId.startsWith("<")) {
                    contentId = contentId.substring(1);
                }
                if (contentId.endsWith(">")) {
                    contentId = contentId.substring(0, contentId.length() - 1);
                }
                if (!wsuId.equals(contentId)) continue;
                try {
                    byte[] raw = ap.getRawContentBytes();
                    XMLSignatureInput result = new XMLSignatureInput(raw);
                    result.setMIMEType(ap.getContentType());
                    return result;
                }
                catch (Exception e) {
                    throw new ResourceResolverException(e.getMessage(), e, uri.getLocalName(), BaseURI);
                }
            }
            throw new ResourceResolverException("Cannot resoulve attachment uri " + uri.getNodeValue(), uri.getLocalName(), BaseURI);
        }
        Element refElem = null;
        try {
            refElem = EnvelopeIdResolverUtilities.findElementById(doc, wsuId, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            if (refElem == null) {
                refElem = EnvelopeIdResolverUtilities.findElementById(doc, wsuId, "");
            }
        }
        catch (Exception e) {
            throw new ResourceResolverException("Cannot resoulve uri " + uri.getNodeValue() + " : " + e.getMessage(), e, uri.getLocalName(), BaseURI);
        }
        XMLSignatureInput result = new XMLSignatureInput((Node)refElem);
        result.setMIMEType("text/xml");
        try {
            URI uriNew = new URI(new URI(BaseURI), uri.getNodeValue());
            result.setSourceURI(uriNew.toString());
        }
        catch (URI.MalformedURIException ex) {
            result.setSourceURI(BaseURI);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Result: " + result);
        }
        return result;
    }

    public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
        return this.engineResolve(context.attr, context.baseUri);
    }

    public boolean engineCanResolve(Attr uri, String BaseURI) {
        if (uri == null) {
            return false;
        }
        String uriNodeValue = uri.getNodeValue();
        return uriNodeValue.startsWith("#") || uriNodeValue.startsWith("cid:");
    }

    public boolean engineCanResolveURI(ResourceResolverContext context) {
        return this.engineCanResolve(context.attr, context.baseUri);
    }
}

