/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.saml;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.saml.SAMLBuilderConfig;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.saml.SAMLBuilderConfigAttribute;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.saml.SAMLUtilities;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.bean.AttributeBean;
import org.apache.wss4j.common.saml.bean.AttributeStatementBean;
import org.apache.wss4j.common.saml.bean.AudienceRestrictionBean;
import org.apache.wss4j.common.saml.bean.AuthenticationStatementBean;
import org.apache.wss4j.common.saml.bean.ConditionsBean;
import org.apache.wss4j.common.saml.bean.KeyInfoBean;
import org.apache.wss4j.common.saml.bean.SubjectBean;
import org.apache.wss4j.common.saml.bean.SubjectConfirmationDataBean;
import org.apache.wss4j.common.saml.bean.Version;
import org.joda.time.DateTime;

public class SAMLCallbackHandler
implements CallbackHandler {
    private SAMLBuilderConfig samlBuilderConfig = null;

    public SAMLCallbackHandler(SAMLBuilderConfig config) throws IOException {
        if (config == null) {
            throw new IOException("SAMLBuilderConfig undefined");
        }
        this.samlBuilderConfig = config;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            List<SAMLBuilderConfigAttribute> listAttributes;
            if (!(callbacks[i] instanceof SAMLCallback)) continue;
            SAMLCallback callback = (SAMLCallback)callbacks[i];
            DateTime now = new DateTime();
            callback.setSamlVersion(this.samlBuilderConfig.getVersion());
            callback.setIssuer(this.samlBuilderConfig.getIssuerValue());
            callback.setIssuerQualifier(this.samlBuilderConfig.getIssuerQualifier());
            callback.setIssuerFormat(this.samlBuilderConfig.getIssuerFormat());
            boolean signAssertion = this.samlBuilderConfig.isSignAssertion();
            callback.setSignAssertion(signAssertion);
            if (signAssertion) {
                try {
                    callback.setIssuerCrypto(this.samlBuilderConfig.getSignAssertionCrypto());
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage(), e);
                }
                callback.setIssuerKeyName(this.samlBuilderConfig.getSignAssertionIssuerKeyName());
                callback.setIssuerKeyPassword(this.samlBuilderConfig.getSignAssertionIssuerKeyPassword());
                if (this.samlBuilderConfig.getSignAssertionSignatureDigestAlgorithm() != null) {
                    callback.setSignatureDigestAlgorithm(this.samlBuilderConfig.getSignAssertionSignatureDigestAlgorithm());
                }
                if (this.samlBuilderConfig.getSignAssertionSignatureAlgorithm() != null) {
                    callback.setSignatureAlgorithm(this.samlBuilderConfig.getSignAssertionSignatureAlgorithm());
                }
                if (this.samlBuilderConfig.getSignAssertionCanonicalizationAlgorithm() != null) {
                    callback.setCanonicalizationAlgorithm(this.samlBuilderConfig.getSignAssertionCanonicalizationAlgorithm());
                }
                callback.setSendKeyValue(this.samlBuilderConfig.isSignAssertionSendKeyValue());
            }
            SubjectBean subjectBean = null;
            if (this.samlBuilderConfig.isSubjectEnabled()) {
                subjectBean = new SubjectBean();
                subjectBean.setSubjectName(this.samlBuilderConfig.getSubjectNameIDValue());
                subjectBean.setSubjectNameIDFormat(this.samlBuilderConfig.getSubjectNameIDFormat());
                subjectBean.setSubjectNameQualifier(this.samlBuilderConfig.getSubjectNameIDQualifier());
                subjectBean.setSubjectConfirmationMethod(this.samlBuilderConfig.getSubjectConfirmationMethod());
                SubjectConfirmationDataBean subjectConfirmationData = new SubjectConfirmationDataBean();
                DateTime subjectConfirmationMethod_notBefore = SAMLUtilities.minutesOperator(now, this.samlBuilderConfig.getSubjectConfirmationDataNotBefore());
                DateTime subjectConfirmationMethod_notOnOrAfter = SAMLUtilities.minutesOperator(now, this.samlBuilderConfig.getSubjectConfirmationDataNotOnOrAfter());
                subjectConfirmationData.setNotBefore(subjectConfirmationMethod_notBefore);
                subjectConfirmationData.setNotAfter(subjectConfirmationMethod_notOnOrAfter);
                subjectConfirmationData.setAddress(this.samlBuilderConfig.getSubjectConfirmationDataAddress());
                subjectConfirmationData.setInResponseTo(this.samlBuilderConfig.getSubjectConfirmationDataInResponseTo());
                subjectConfirmationData.setRecipient(this.samlBuilderConfig.getSubjectConfirmationDataRecipient());
                subjectBean.setSubjectConfirmationData(subjectConfirmationData);
                if ("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key".equals(this.samlBuilderConfig.getSubjectConfirmationMethod()) || "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key".equals(this.samlBuilderConfig.getSubjectConfirmationMethod())) {
                    try {
                        KeyInfoBean keyInfo = this.createKeyInfo();
                        subjectBean.setKeyInfo(keyInfo);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.out);
                        throw new IOException("Problem creating KeyInfo: " + ex.getMessage());
                    }
                }
                callback.setSubject(subjectBean);
            }
            if (this.samlBuilderConfig.isConditionsEnabled()) {
                ConditionsBean conditions = new ConditionsBean();
                DateTime conditions_notBefore = SAMLUtilities.minutesOperator(now, this.samlBuilderConfig.getConditionsDataNotBefore());
                DateTime conditions_notOnOrAfter = SAMLUtilities.minutesOperator(now, this.samlBuilderConfig.getConditionsDataNotOnOrAfter());
                conditions.setNotBefore(conditions_notBefore);
                conditions.setNotAfter(conditions_notOnOrAfter);
                if (this.samlBuilderConfig.getConditionsAudienceURI() != null) {
                    ArrayList<AudienceRestrictionBean> lAudience = new ArrayList<AudienceRestrictionBean>();
                    AudienceRestrictionBean arb = new AudienceRestrictionBean();
                    ArrayList<String> uri = new ArrayList<String>();
                    uri.add(this.samlBuilderConfig.getConditionsAudienceURI());
                    arb.setAudienceURIs(uri);
                    lAudience.add(arb);
                    conditions.setAudienceRestrictions(lAudience);
                }
                callback.setConditions(conditions);
            }
            AuthenticationStatementBean authBean = null;
            if (this.samlBuilderConfig.isAuthnStatementEnabled()) {
                authBean = new AuthenticationStatementBean();
                authBean.setSubject(subjectBean);
                DateTime authnStatement_instant = SAMLUtilities.minutesOperator(now, this.samlBuilderConfig.getAuthnStatementDataInstant());
                DateTime authnStatement_notOnOrAfter = SAMLUtilities.minutesOperator(now, this.samlBuilderConfig.getAuthnStatementDataNotOnOrAfter());
                authBean.setAuthenticationInstant(authnStatement_instant);
                authBean.setSessionNotOnOrAfter(authnStatement_notOnOrAfter);
                authBean.setAuthenticationMethod(this.samlBuilderConfig.getAuthnStatementClassRef());
                callback.setAuthenticationStatementData(Collections.singletonList(authBean));
            }
            if (authBean == null && !Version.SAML_20.equals((Object)this.samlBuilderConfig.getVersion()) && subjectBean != null) {
                authBean = new AuthenticationStatementBean();
                authBean.setSubject(subjectBean);
                callback.setAuthenticationStatementData(Collections.singletonList(authBean));
            }
            if ((listAttributes = this.samlBuilderConfig.getAttributes()) == null || listAttributes.size() <= 0) continue;
            AttributeStatementBean attrBean = new AttributeStatementBean();
            attrBean.setSubject(subjectBean);
            ArrayList<AttributeBean> attributeBeans = new ArrayList<AttributeBean>();
            for (SAMLBuilderConfigAttribute configAttribute : listAttributes) {
                AttributeBean attributeBean = new AttributeBean();
                attributeBean.setSimpleName(configAttribute.getSimpleName());
                attributeBean.setQualifiedName(configAttribute.getQualifiedName());
                attributeBean.setNameFormat(configAttribute.getFormatName());
                attributeBean.setAttributeValues(configAttribute.getValues());
                attributeBeans.add(attributeBean);
            }
            attrBean.setSamlAttributes(attributeBeans);
            callback.setAttributeStatementData(Collections.singletonList(attrBean));
        }
    }

    protected KeyInfoBean createKeyInfo() throws Exception {
        Crypto crypto = this.samlBuilderConfig.getSubjectConfirmationMethod_holderOfKey_crypto();
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias(this.samlBuilderConfig.getSubjectConfirmationMethod_holderOfKey_cryptoCertificateAlias());
        X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
        KeyInfoBean keyInfo = new KeyInfoBean();
        keyInfo.setCertificate(certs[0]);
        keyInfo.setCertIdentifer(KeyInfoBean.CERT_IDENTIFIER.X509_CERT);
        return keyInfo;
    }
}

