/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.saml;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.saml.SAMLBuilderConfigAttribute;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.bean.Version;

public class SAMLBuilderConfig {
    private static Hashtable<String, SAMLBuilderConfig> SAML_CACHE_CONFIG = new Hashtable();
    private Properties p;
    private boolean cached = false;
    private Version version = null;
    private String issuerValue;
    private String issuerQualifier;
    private String issuerFormat;
    private boolean signAssertion = false;
    private Crypto signAssertionCrypto = null;
    private String signAssertionCryptoProp = null;
    private String signAssertionIssuerKeyPassword = null;
    private String signAssertionIssuerKeyName = null;
    private boolean signAssertionSendKeyValue = false;
    private String signAssertionSignatureAlgorithm;
    private String signAssertionSignatureDigestAlgorithm;
    private String signAssertionCanonicalizationAlgorithm;
    private boolean subjectEnabled = true;
    private String subjectNameIDValue;
    private String subjectNameIDQualifier;
    private String subjectNameIDFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
    private String subjectConfirmationMethod = null;
    private int subjectConfirmationDataNotBefore = 0;
    private int subjectConfirmationDataNotOnOrAfter = 60;
    private String subjectConfirmationDataAddress;
    private String subjectConfirmationDataInResponseTo;
    private String subjectConfirmationDataRecipient;
    private Crypto subjectConfirmationMethod_holderOfKey_crypto = null;
    private String subjectConfirmationMethod_holderOfKey_cryptoProperties = null;
    private String subjectConfirmationMethod_holderOfKey_cryptoCertificateAlias = null;
    private boolean conditionsEnabled = true;
    private int conditionsDataNotBefore = 0;
    private int conditionsDataNotOnOrAfter = 60;
    private String conditionsAudienceURI = null;
    private boolean authnStatementEnabled = true;
    private int authnStatementDataInstant = 0;
    private int authnStatementDataNotOnOrAfter = 60;
    private String authnStatementClassRef;
    private List<SAMLBuilderConfigAttribute> attributes = new ArrayList<SAMLBuilderConfigAttribute>();

    private static synchronized void addSamlConfig(String propertiesName, SAMLBuilderConfig p) {
        if (!SAML_CACHE_CONFIG.containsKey(propertiesName)) {
            SAML_CACHE_CONFIG.put(propertiesName, p);
        }
    }

    public static SAMLBuilderConfig getSamlConfig(String properties) throws IOException {
        InputStream is = null;
        try {
            File f = new File(properties);
            is = f.exists() ? new FileInputStream(f) : SAMLBuilderConfig.class.getResourceAsStream("/" + properties);
            if (is == null) {
                throw new IOException("SAMLPropFile [" + properties + "]: not found");
            }
            try {
                SAMLBuilderConfig sAMLBuilderConfig = SAMLBuilderConfig.getSamlConfig(Utilities.getAsProperties(is));
                return sAMLBuilderConfig;
            }
            catch (Exception e) {
                throw new IOException("SAMLPropFile [" + properties + "]: " + e.getMessage(), e);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static SAMLBuilderConfig getSamlConfig(Properties p) throws IOException {
        String propertiesName = p.getProperty("openspcoop2.saml.config.name");
        if (propertiesName == null) {
            throw new IOException("SAML Config Builder: property [openspcoop2.saml.config.name] not found");
        }
        propertiesName = propertiesName.trim();
        if (SAML_CACHE_CONFIG.containsKey(propertiesName)) {
            return SAML_CACHE_CONFIG.get(propertiesName);
        }
        try {
            SAMLBuilderConfig config = new SAMLBuilderConfig(p);
            if (config.cached) {
                SAMLBuilderConfig.addSamlConfig(propertiesName, config);
            }
            return config;
        }
        catch (Exception e) {
            throw new IOException("Properties config [" + propertiesName + "]: " + e.getMessage(), e);
        }
    }

    private static boolean isTrue(Properties p, String name, boolean defaultValue) throws IOException {
        String tmp = p.getProperty(name);
        if (tmp != null) {
            try {
                return Boolean.parseBoolean(tmp.trim());
            }
            catch (Exception e) {
                throw new IOException("SAML Config Builder: boolean property [" + name + "] with wrong format: " + e.getMessage());
            }
        }
        return defaultValue;
    }

    private static Integer getIntProperty(Properties p, String name, boolean required) throws IOException {
        String tmp = SAMLBuilderConfig.getProperty(p, name, required);
        if (tmp != null) {
            try {
                return Integer.parseInt(tmp);
            }
            catch (Exception e) {
                throw new IOException("SAML Config Builder: integer property [" + name + "] with wrong format: " + e.getMessage());
            }
        }
        return null;
    }

    private static String getProperty(Properties p, String name, boolean required) throws IOException {
        String tmp = p.getProperty(name);
        if (tmp != null) {
            return tmp.trim();
        }
        if (required) {
            throw new IOException("SAML Config Builder: property [" + name + "] not found");
        }
        return null;
    }

    public SAMLBuilderConfig(Properties p) throws IOException {
        this.p = p;
        this.cached = SAMLBuilderConfig.isTrue(p, "openspcoop2.saml.cached", false);
        boolean saml2 = false;
        String version = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.version", true);
        if ("1.0".equals(version)) {
            this.version = Version.SAML_10;
        } else if ("1.1".equals(version)) {
            this.version = Version.SAML_11;
        } else if ("2.0".equals(version)) {
            this.version = Version.SAML_20;
            saml2 = true;
        } else {
            throw new IOException("SAML Config Builder: property [openspcoop2.saml.version] not supported");
        }
        this.issuerValue = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.issuer.value", true);
        this.issuerQualifier = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.issuer.qualifier", false);
        String tmp = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.issuer.format", false);
        if (tmp != null) {
            this.issuerFormat = this.getNameIDFormat(tmp);
        }
        this.signAssertion = SAMLBuilderConfig.isTrue(this.p, "openspcoop2.saml.assertion.sign", false);
        if (this.signAssertion) {
            this.signAssertionCryptoProp = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.assertion.sign.cryptoProp.file", true);
            this.signAssertionIssuerKeyName = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.assertion.sign.key.name", true);
            this.signAssertionIssuerKeyPassword = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.assertion.sign.key.password", true);
            this.signAssertionSendKeyValue = SAMLBuilderConfig.isTrue(this.p, "openspcoop2.saml.assertion.sign.sendKeyValue", false);
            this.signAssertionSignatureAlgorithm = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.assertion.sign.signatureAlgorithm", false);
            this.signAssertionSignatureDigestAlgorithm = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.assertion.sign.signatureDigestAlgorithm", false);
            this.signAssertionCanonicalizationAlgorithm = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.assertion.sign.canonicalizationAlgorithm", false);
        }
        this.subjectNameIDValue = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.nameID.value", true);
        this.subjectNameIDQualifier = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.nameID.qualifier", false);
        tmp = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.nameID.format", false);
        if (tmp != null) {
            this.subjectNameIDFormat = this.getNameIDFormat(tmp);
        }
        tmp = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.confirmation.method", true);
        this.subjectConfirmationMethod = this.getSubjectConfirmationMethod(tmp, saml2);
        boolean holderOfKey = this.isHolderOfKeySubjectConfirmationMethod(this.subjectConfirmationMethod);
        Integer tmpInt = SAMLBuilderConfig.getIntProperty(this.p, "openspcoop2.saml.subject.confirmation.data.notBefore.minutes", false);
        if (tmpInt != null) {
            this.subjectConfirmationDataNotBefore = tmpInt;
        }
        if ((tmpInt = SAMLBuilderConfig.getIntProperty(this.p, "openspcoop2.saml.subject.confirmation.data.notOnOrAfter.minutes", false)) != null) {
            this.subjectConfirmationDataNotOnOrAfter = tmpInt;
        }
        this.subjectConfirmationDataAddress = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.confirmation.data.address", false);
        this.subjectConfirmationDataInResponseTo = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.confirmation.data.inResponseTo", false);
        this.subjectConfirmationDataRecipient = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.confirmation.data.recipient", false);
        if (holderOfKey) {
            this.subjectConfirmationMethod_holderOfKey_cryptoProperties = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoProperties", true);
            this.subjectConfirmationMethod_holderOfKey_cryptoCertificateAlias = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.subject.confirmation.method.holderOfKey.cryptoCertificateAlias", true);
        }
        if ((tmpInt = SAMLBuilderConfig.getIntProperty(this.p, "openspcoop2.saml.conditions.notBefore.minutes", false)) != null) {
            this.conditionsDataNotBefore = tmpInt;
        }
        if ((tmpInt = SAMLBuilderConfig.getIntProperty(this.p, "openspcoop2.saml.conditions.notOnOrAfter.minutes", false)) != null) {
            this.conditionsDataNotOnOrAfter = tmpInt;
        }
        this.conditionsAudienceURI = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.conditions.audienceURI", false);
        this.authnStatementEnabled = SAMLBuilderConfig.isTrue(this.p, "openspcoop2.saml.authn.statement.enabled", true);
        tmpInt = SAMLBuilderConfig.getIntProperty(this.p, "openspcoop2.saml.authn.statement.instant.minutes", false);
        if (tmpInt != null) {
            this.authnStatementDataInstant = tmpInt;
        }
        if ((tmpInt = SAMLBuilderConfig.getIntProperty(this.p, "openspcoop2.saml.authn.statement.notOnOrAfter.minutes", false)) != null) {
            this.authnStatementDataNotOnOrAfter = tmpInt;
        }
        if ((tmp = SAMLBuilderConfig.getProperty(this.p, "openspcoop2.saml.authn", this.authnStatementEnabled)) != null) {
            this.authnStatementClassRef = this.getAuthStatementMethod(tmp, saml2);
        }
        Properties pAttribute = null;
        try {
            pAttribute = Utilities.readProperties("openspcoop2.saml.attribute.statement.", this.p);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        if (pAttribute != null && p.size() > 0) {
            ArrayList<String> attrNames = new ArrayList<String>();
            Enumeration<Object> enAttributes = pAttribute.keys();
            if (enAttributes != null) {
                while (enAttributes.hasMoreElements()) {
                    String key;
                    Object objectName = enAttributes.nextElement();
                    if (!(objectName instanceof String) || !(key = (String)objectName).endsWith(".values")) continue;
                    String attrName = key.substring(0, key.indexOf(".values"));
                    attrNames.add(attrName);
                }
            }
            for (String attrName : attrNames) {
                String values;
                String valuesTmp;
                String[] splitValues;
                String formatTmp;
                SAMLBuilderConfigAttribute attr = new SAMLBuilderConfigAttribute(attrName);
                String qualifiedName = attrName + ".name.qualified";
                String simpleName = attrName + ".name.simple";
                String qualifiedNameTmp = SAMLBuilderConfig.getProperty(pAttribute, qualifiedName, !saml2);
                String simpleNameTmp = SAMLBuilderConfig.getProperty(pAttribute, simpleName, !saml2);
                if (qualifiedNameTmp == null && simpleNameTmp == null) {
                    throw new IOException("SAML Config Builder: attribute [" + attrName + "] requires at least one of the following properties: " + qualifiedName + ", " + simpleName);
                }
                attr.setQualifiedName(qualifiedNameTmp);
                attr.setSimpleName(simpleNameTmp);
                String format = attrName + ".name.format";
                if (saml2) {
                    formatTmp = SAMLBuilderConfig.getProperty(pAttribute, format, true);
                    attr.setFormatName(this.getAttributeFormat(formatTmp));
                } else {
                    formatTmp = SAMLBuilderConfig.getProperty(pAttribute, format, false);
                    if (formatTmp != null) {
                        throw new IOException("SAML Config Builder: name format unsupported in SAML 1.1; found in attribute [" + attrName + "]");
                    }
                }
                String separator = attrName + ".values.separator";
                String separatorTmp = SAMLBuilderConfig.getProperty(pAttribute, separator, false);
                if (separatorTmp == null || "".equals(separatorTmp)) {
                    separatorTmp = ",";
                }
                if ((splitValues = (valuesTmp = SAMLBuilderConfig.getProperty(pAttribute, values = attrName + ".values", true)).split(separatorTmp)) == null || splitValues.length <= 0) {
                    throw new IOException("SAML Config Builder: values not found in attribute [" + attrName + "] using separator [" + valuesTmp + "]");
                }
                for (int i = 0; i < splitValues.length; ++i) {
                    attr.addValue(splitValues[i].trim());
                }
                this.attributes.add(attr);
            }
        }
    }

    private String getNameIDFormat(String tmpParam) {
        String tmp = tmpParam.trim();
        if ("UNSPECIFIED".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        } else if ("EMAIL".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress";
        } else if ("X509_SUBJECT".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName";
        } else if ("WIN_DOMAIN_QUALIFIED".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName";
        } else if ("KERBEROS".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos";
        } else if ("ENTITY".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:2.0:nameid-format:entity";
        } else if ("PERSISTENT".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent";
        } else if ("TRANSIENT".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:2.0:nameid-format:transient";
        } else if ("ENCRYPTED".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted";
        }
        return tmp;
    }

    private String getSubjectConfirmationMethod(String tmpParam, boolean saml2) {
        String tmp = tmpParam.trim();
        if ("ARTIFACT".equals(tmp) && !saml2) {
            tmp = "urn:oasis:names:tc:SAML:1.0:cm:artifact";
        } else if ("IDENTITY".equals(tmp) && !saml2) {
            tmp = "urn:com:sun:identity";
        } else if ("BEARER".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:cm:bearer" : "urn:oasis:names:tc:SAML:1.0:cm:bearer";
        } else if ("HOLDER_OF_KEY".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key" : "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
        } else if ("SENDER_VOUCHES".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches" : "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
        }
        return tmp;
    }

    private boolean isHolderOfKeySubjectConfirmationMethod(String confirmationMethod) {
        return "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key".equals(confirmationMethod) || "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key".equals(confirmationMethod);
    }

    private String getAuthStatementMethod(String tmpParam, boolean saml2) {
        String tmp = tmpParam.trim();
        if ("UNSPECIFIED".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified" : "urn:oasis:names:tc:SAML:1.0:am:unspecified";
        } else if ("PASSWORD".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:Password" : "urn:oasis:names:tc:SAML:1.0:am:password";
        } else if ("KERBEROS".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos" : "urn:ietf:rfc:1510";
        } else if ("TLS".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:TLSClient" : "urn:ietf:rfc:2246";
        } else if ("X509".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:X509" : "urn:oasis:names:tc:SAML:1.0:am:X509-PKI";
        } else if ("PGP".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:PGP" : "urn:oasis:names:tc:SAML:1.0:am:PGP";
        } else if ("SRP".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:SecureRemotePassword" : "urn:ietf:rfc:2945";
        } else if ("SPKI".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:SPKI" : "urn:oasis:names:tc:SAML:1.0:am:SPKI";
        } else if ("DSIG".equals(tmp)) {
            tmp = saml2 ? "urn:oasis:names:tc:SAML:2.0:ac:classes:XMLDSig" : "urn:ietf:rfc:3075";
        } else if ("HARDWARE".equals(tmp)) {
            if (!saml2) {
                tmp = "urn:oasis:names:tc:SAML:1.0:am:HardwareToken";
            }
        } else if ("XKMS".equals(tmp)) {
            if (!saml2) {
                tmp = "urn:oasis:names:tc:SAML:1.0:am:XKMS";
            }
        } else if ("INTERNET_PROTOCOL".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:InternetProtocol";
            }
        } else if ("INTERNET_PROTOCOL_PASSWORD".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:InternetProtocolPassword";
            }
        } else if ("MOBILE_ONE_FACTOR_UNREGISTERED".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:MobileOneFactorUnregistered";
            }
        } else if ("MOBILE_TWO_FACTOR_UNREGISTERED".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:MobileTwoFactorUnregistered";
            }
        } else if ("MOBILE_ONE_FACTOR_CONTRACT".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:MobileOneFactorContract";
            }
        } else if ("MOBILE_TWO_FACTOR_CONTRACT".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:MobileTwoFactorContract";
            }
        } else if ("PASSWORD_PROTECTED_TRANSPORT".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
            }
        } else if ("PREVIOUS_SESSION".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession";
            }
        } else if ("SMARTCARD".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:Smartcard";
            }
        } else if ("SMARTCARD_PKI".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:SmartcardPKI";
            }
        } else if ("SOFTWARE_PKI".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:SoftwarePKI";
            }
        } else if ("TELEPHONY".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:Telephony";
            }
        } else if ("NOMAD_TELEPHONY".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:NomadTelephony";
            }
        } else if ("PERSONAL_TELEPHONY".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:PersonalTelephony";
            }
        } else if ("AUTHENTICATED_TELEPHONY".equals(tmp)) {
            if (saml2) {
                tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:AuthenticatedTelephony";
            }
        } else if ("TIME_SYNC".equals(tmp) && saml2) {
            tmp = "urn:oasis:names:tc:SAML:2.0:ac:classes:TimeSyncToken";
        }
        return tmp;
    }

    private String getAttributeFormat(String tmpParam) {
        String tmp = tmpParam.trim();
        if ("UNSPECIFIED".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
        } else if ("URI".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
        } else if ("BASIC".equals(tmp)) {
            tmp = "urn:oasis:names:tc:SAML:2.0:attrname-format:basic";
        }
        return tmp;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getIssuerValue() {
        return this.issuerValue;
    }

    public String getIssuerQualifier() {
        return this.issuerQualifier;
    }

    public String getIssuerFormat() {
        return this.issuerFormat;
    }

    public boolean isSignAssertion() {
        return this.signAssertion;
    }

    public Crypto getSignAssertionCrypto() throws WSSecurityException {
        if (this.signAssertionCrypto == null) {
            this.initSignAssertionCrypto();
        }
        return this.signAssertionCrypto;
    }

    private synchronized void initSignAssertionCrypto() throws WSSecurityException {
        if (this.signAssertionCrypto == null) {
            this.signAssertionCrypto = CryptoFactory.getInstance((String)this.signAssertionCryptoProp);
        }
    }

    public String getSignAssertionCryptoProp() {
        return this.signAssertionCryptoProp;
    }

    public String getSignAssertionIssuerKeyPassword() {
        return this.signAssertionIssuerKeyPassword;
    }

    public String getSignAssertionIssuerKeyName() {
        return this.signAssertionIssuerKeyName;
    }

    public boolean isSignAssertionSendKeyValue() {
        return this.signAssertionSendKeyValue;
    }

    public String getSignAssertionSignatureAlgorithm() {
        return this.signAssertionSignatureAlgorithm;
    }

    public String getSignAssertionSignatureDigestAlgorithm() {
        return this.signAssertionSignatureDigestAlgorithm;
    }

    public String getSignAssertionCanonicalizationAlgorithm() {
        return this.signAssertionCanonicalizationAlgorithm;
    }

    public boolean isSubjectEnabled() {
        return this.subjectEnabled;
    }

    public String getSubjectNameIDValue() {
        return this.subjectNameIDValue;
    }

    public String getSubjectNameIDQualifier() {
        return this.subjectNameIDQualifier;
    }

    public String getSubjectNameIDFormat() {
        return this.subjectNameIDFormat;
    }

    public String getSubjectConfirmationMethod() {
        return this.subjectConfirmationMethod;
    }

    public int getSubjectConfirmationDataNotBefore() {
        return this.subjectConfirmationDataNotBefore;
    }

    public int getSubjectConfirmationDataNotOnOrAfter() {
        return this.subjectConfirmationDataNotOnOrAfter;
    }

    public String getSubjectConfirmationDataAddress() {
        return this.subjectConfirmationDataAddress;
    }

    public String getSubjectConfirmationDataInResponseTo() {
        return this.subjectConfirmationDataInResponseTo;
    }

    public String getSubjectConfirmationDataRecipient() {
        return this.subjectConfirmationDataRecipient;
    }

    public Crypto getSubjectConfirmationMethod_holderOfKey_crypto() throws WSSecurityException {
        if (this.subjectConfirmationMethod_holderOfKey_crypto == null) {
            this.initSubjectConfirmationMethod_holderOfKey_crypto();
        }
        return this.subjectConfirmationMethod_holderOfKey_crypto;
    }

    private synchronized void initSubjectConfirmationMethod_holderOfKey_crypto() throws WSSecurityException {
        if (this.subjectConfirmationMethod_holderOfKey_crypto == null) {
            this.subjectConfirmationMethod_holderOfKey_crypto = CryptoFactory.getInstance((String)this.subjectConfirmationMethod_holderOfKey_cryptoProperties);
        }
    }

    public String getSubjectConfirmationMethod_holderOfKey_cryptoProperties() {
        return this.subjectConfirmationMethod_holderOfKey_cryptoProperties;
    }

    public String getSubjectConfirmationMethod_holderOfKey_cryptoCertificateAlias() {
        return this.subjectConfirmationMethod_holderOfKey_cryptoCertificateAlias;
    }

    public boolean isConditionsEnabled() {
        return this.conditionsEnabled;
    }

    public int getConditionsDataNotBefore() {
        return this.conditionsDataNotBefore;
    }

    public int getConditionsDataNotOnOrAfter() {
        return this.conditionsDataNotOnOrAfter;
    }

    public String getConditionsAudienceURI() {
        return this.conditionsAudienceURI;
    }

    public boolean isAuthnStatementEnabled() {
        return this.authnStatementEnabled;
    }

    public int getAuthnStatementDataInstant() {
        return this.authnStatementDataInstant;
    }

    public int getAuthnStatementDataNotOnOrAfter() {
        return this.authnStatementDataNotOnOrAfter;
    }

    public String getAuthnStatementClassRef() {
        return this.authnStatementClassRef;
    }

    public List<SAMLBuilderConfigAttribute> getAttributes() {
        return this.attributes;
    }
}

