/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.engine;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.reference.Reference;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityContext;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import java.util.Hashtable;
import java.util.List;

public class WSSUtilities {
    public static List<Reference> getDirtyElements(MessageSecurityContext messageSecurityContext, OpenSPCoop2Message message) throws SecurityException {
        try {
            boolean mustUnderstandValue = false;
            Object mustUnderstand = messageSecurityContext.getIncomingProperties().get("mustUnderstand");
            if (mustUnderstand != null) {
                mustUnderstandValue = Boolean.parseBoolean((String)mustUnderstand);
            }
            String actor = messageSecurityContext.getActor();
            if ("".equals(messageSecurityContext.getActor())) {
                actor = null;
            }
            List<Reference> references = message.getWSSDirtyElements(actor, mustUnderstandValue);
            messageSecurityContext.setReferences(references);
            return references;
        }
        catch (Exception e) {
            SecurityException sec = new SecurityException(e.getMessage(), e);
            if (Utilities.existsInnerMessageException(e, "[WSS-Signature ReferencesSearch]", true)) {
                sec.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA);
            } else if (Utilities.existsInnerMessageException(e, "[WSS-Encrypt ReferencesSearch]", true)) {
                sec.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA_CIFRATURA_NON_VALIDA);
            }
            throw sec;
        }
    }

    public static void cleanDirtyElements(MessageSecurityContext messageSecurityContext, OpenSPCoop2Message message, List<Reference> elementsToClean, boolean detachHeaderWSSecurity, boolean removeAllIdRef) throws SecurityException {
        try {
            boolean mustUnderstandValue = false;
            Object mustUnderstand = messageSecurityContext.getIncomingProperties().get("mustUnderstand");
            if (mustUnderstand != null) {
                mustUnderstandValue = Boolean.parseBoolean((String)mustUnderstand);
            }
            String actor = messageSecurityContext.getActor();
            if ("".equals(messageSecurityContext.getActor())) {
                actor = null;
            }
            message.cleanWSSDirtyElements(actor, mustUnderstandValue, elementsToClean, detachHeaderWSSecurity, removeAllIdRef);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public static boolean isNormalizeToSaajImpl(MessageSecurityContext wssContext) {
        Hashtable<String, Object> wssProperties = null;
        wssProperties = wssContext.isFunctionAsClient() ? wssContext.getOutgoingProperties() : wssContext.getIncomingProperties();
        if (wssProperties != null && wssProperties.containsKey("normalizeToSaajImpl")) {
            return Boolean.parseBoolean((String)wssProperties.get("normalizeToSaajImpl"));
        }
        if (wssProperties != null && wssProperties.containsKey("action")) {
            String action = (String)wssProperties.get("action");
            if (action.contains("Signature") || action.contains("SAMLTokenUnsigned") || action.contains("SAMLTokenSigned") || action.contains("UsernameTokenSignature") || action.contains("SignatureDerived") || action.contains("SignatureWithKerberosToken")) {
                return true;
            }
            if (!wssContext.isFunctionAsClient() && action.contains("Encrypt") && wssProperties.containsKey("encryptionParts")) {
                String attach = "{Attach}";
                String attachAll = attach + "{*}";
                String encryptParts = (String)wssProperties.get("encryptionParts");
                if (encryptParts != null && encryptParts.contains(attach) && !encryptParts.contains(attachAll)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

