/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.engine;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.IMessageSecuritySender;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityContext;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.engine.MessageSecuritySender;

public class MessageSecuritySender_impl
extends MessageSecuritySender {
    protected MessageSecuritySender_impl(MessageSecurityContext messageSecurityContext) {
        super(messageSecurityContext);
    }

    @Override
    protected boolean process(OpenSPCoop2Message message) {
        try {
            IMessageSecuritySender senderInterface = this.messageSecurityContext.getMessageSecuritySender();
            if (message.getSOAPBody().hasFault() && !MessageSecurityUtilities.processSOAPFault(this.messageSecurityContext.getOutgoingProperties())) {
                return true;
            }
            String action = (String)this.messageSecurityContext.getOutgoingProperties().get("action");
            if (action == null || "".equals(action.trim())) {
                return true;
            }
            senderInterface.process(this.messageSecurityContext, message);
        }
        catch (Exception e) {
            String prefix = "Generatosi errore durante il processamento Message-Security(Sender): ";
            this.messageSecurityContext.getLog().error(prefix + e.getMessage(), (Throwable)e);
            this.msgErrore = prefix + e.getMessage();
            this.codiceErrore = CodiceErroreCooperazione.SICUREZZA;
            if (e instanceof SecurityException) {
                SecurityException securityException = (SecurityException)e;
                if (securityException.getMsgErrore() != null) {
                    this.msgErrore = prefix + securityException.getMsgErrore();
                }
                if (securityException.getCodiceErrore() != null) {
                    this.codiceErrore = securityException.getCodiceErrore();
                }
            }
            return false;
        }
        return true;
    }
}

