/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.engine;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.reference.Reference;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.IMessageSecurityReceiver;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityContext;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.SubErrorCodeSecurity;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.authorization.IMessageSecurityAuthorization;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.authorization.MessageSecurityAuthorizationRequest;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.authorization.MessageSecurityAuthorizationResult;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.engine.MessageSecurityReceiver;
import it.link.pdd.tools.migrazione_govway.utils.resources.Loader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class MessageSecurityReceiver_impl
extends MessageSecurityReceiver {
    protected MessageSecurityReceiver_impl(MessageSecurityContext messageSecurityContext) {
        super(messageSecurityContext);
    }

    @Override
    protected boolean process(OpenSPCoop2Message message, Busta busta) {
        try {
            IMessageSecurityReceiver receiverInterface = this.messageSecurityContext.getMessageSecurityReceiver();
            if (message.getSOAPBody().hasFault() && !MessageSecurityUtilities.processSOAPFault(this.messageSecurityContext.getIncomingProperties())) {
                return true;
            }
            String action = (String)this.messageSecurityContext.getIncomingProperties().get("action");
            if (action == null || "".equals(action.trim())) {
                return true;
            }
            String authClass = (String)this.messageSecurityContext.getIncomingProperties().get("authorizationClass");
            String actor = this.messageSecurityContext.getActor();
            if ("".equals(this.messageSecurityContext.getActor())) {
                actor = null;
            }
            if (!this.messageSecurityContext.existsSecurityHeader(message, actor)) {
                this.msgErrore = "Header Message Security, richiesto dalla configurazione (action:" + action + "), non riscontrato nella SOAPEnvelope ricevuta";
                this.codiceErrore = action.contains("Signature") ? CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_PRESENTE : (action.contains("Encrypt") ? CodiceErroreCooperazione.SICUREZZA_CIFRATURA_NON_PRESENTE : CodiceErroreCooperazione.SICUREZZA_NON_PRESENTE);
                return false;
            }
            List<Reference> elementsToClean = receiverInterface.getDirtyElements(this.messageSecurityContext, message);
            ArrayList<SubErrorCodeSecurity> listaErroriRiscontrati = new ArrayList<SubErrorCodeSecurity>();
            Map<QName, QName> notResolved = receiverInterface.checkEncryptSignatureParts(this.messageSecurityContext, elementsToClean, message, listaErroriRiscontrati);
            if (listaErroriRiscontrati.size() > 0) {
                StringBuffer bf = new StringBuffer();
                for (SubErrorCodeSecurity subCodiceErroreSicurezza : listaErroriRiscontrati) {
                    if (bf.length() > 0) {
                        bf.append(" ; ");
                    }
                    bf.append(subCodiceErroreSicurezza.getMsgErrore());
                }
                this.messageSecurityContext.getLog().error(bf.toString());
                this.msgErrore = bf.toString();
                this.codiceErrore = CodiceErroreCooperazione.SICUREZZA_NON_PRESENTE;
                this.listaSubCodiceErrore.addAll(listaErroriRiscontrati);
                return false;
            }
            receiverInterface.process(this.messageSecurityContext, message, busta);
            ArrayList<SubErrorCodeSecurity> listaErroriInElementi = new ArrayList<SubErrorCodeSecurity>();
            receiverInterface.checkEncryptionPartElements(notResolved, message, listaErroriInElementi);
            if (listaErroriInElementi.size() > 0) {
                StringBuffer bf = new StringBuffer();
                for (SubErrorCodeSecurity subCodiceErroreSicurezza : listaErroriInElementi) {
                    if (bf.length() > 0) {
                        bf.append(" ; ");
                    }
                    bf.append(subCodiceErroreSicurezza.getMsgErrore());
                }
                this.messageSecurityContext.getLog().error(bf.toString());
                this.msgErrore = bf.toString();
                this.codiceErrore = CodiceErroreCooperazione.SICUREZZA_NON_PRESENTE;
                this.listaSubCodiceErrore.addAll(listaErroriInElementi);
                return false;
            }
            try {
                this.subject = receiverInterface.getCertificate();
            }
            catch (Exception e) {
                this.messageSecurityContext.getLog().error("GetPrincipal Message-Security(Receiver) error: " + e.getMessage(), (Throwable)e);
            }
            if (authClass != null) {
                try {
                    IMessageSecurityAuthorization auth = (IMessageSecurityAuthorization)Loader.getInstance().newInstance(authClass);
                    MessageSecurityAuthorizationRequest req = new MessageSecurityAuthorizationRequest();
                    req.setBusta(busta);
                    req.setWssSecurityPrincipal(this.subject);
                    req.setMessageSecurityContext(this.messageSecurityContext);
                    req.setMessage(message);
                    MessageSecurityAuthorizationResult result = auth.authorize(req);
                    if (!result.isAuthorized()) {
                        this.msgErrore = "Mittente della busta [" + busta.getTipoMittente() + busta.getMittente() + "] (subject:" + this.subject + ") non autorizzato ad invocare il servizio [" + busta.getServizio() + "] erogato dal soggetto [" + busta.getTipoDestinatario() + busta.getDestinatario() + "]";
                        if (result.getErrorMessage() != null) {
                            this.msgErrore = this.msgErrore + "(" + result.getErrorMessage() + ")";
                        }
                        if (result.getException() != null) {
                            this.messageSecurityContext.getLog().error(this.msgErrore, (Throwable)result.getException());
                        }
                        this.codiceErrore = CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA;
                        return false;
                    }
                }
                catch (Exception e) {
                    throw new Exception("Errore di Processamento durante l'autorizzazione: " + e.getMessage());
                }
            }
            try {
                boolean detachValue = true;
                Object detach = this.messageSecurityContext.getIncomingProperties().get("detachHeaderWSSecurity");
                if (detach != null) {
                    detachValue = Boolean.parseBoolean((String)detach);
                }
                boolean removeAllIdRefValue = this.messageSecurityContext.isRemoveAllWsuIdRef();
                Object removeAllIdRef = this.messageSecurityContext.getIncomingProperties().get("removeAllWsuIdRef");
                if (removeAllIdRef != null) {
                    removeAllIdRefValue = Boolean.parseBoolean((String)removeAllIdRef);
                }
                receiverInterface.cleanDirtyElements(this.messageSecurityContext, message, elementsToClean, detachValue, removeAllIdRefValue);
            }
            catch (SecurityException e) {
                this.messageSecurityContext.getLog().error("Errore durante il clean del messaggio: " + e.getMessage(), (Throwable)e);
                throw new Exception("Errore durante la cleanMessage: " + e.getMessage());
            }
        }
        catch (Exception e) {
            String prefix = "Generatosi errore durante il processamento Message-Security(Receiver): ";
            this.messageSecurityContext.getLog().error(prefix + e.getMessage(), (Throwable)e);
            this.msgErrore = prefix + "Generatosi errore durante il processamento Message-Security(Receiver): " + e.getMessage();
            this.codiceErrore = CodiceErroreCooperazione.SICUREZZA;
            if (e instanceof SecurityException) {
                SecurityException securityException = (SecurityException)e;
                if (securityException.getMsgErrore() != null) {
                    this.msgErrore = prefix + securityException.getMsgErrore();
                }
                if (securityException.getCodiceErrore() != null) {
                    this.codiceErrore = securityException.getCodiceErrore();
                }
            }
            return false;
        }
        return true;
    }
}

