/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.engine;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityContext;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityContextParameters;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityDigestReader;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.constants.SecurityType;
import it.link.pdd.tools.migrazione_govway.utils.digest.IDigestReader;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;

public class MessageSecurityFactory {
    public static String messageSecurityContextImplClass = "it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.engine.MessageSecurityContext_impl";
    public static String messageSecurityDigestReaderImplClass = "it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.engine.MessageSecurityDigestReader_impl";

    public static void setMessageSecurityContextClassName(String messageSecurityContextImplClass) {
        if (messageSecurityContextImplClass != null) {
            MessageSecurityFactory.messageSecurityContextImplClass = messageSecurityContextImplClass;
        }
    }

    public static void setMessageSecurityDigestReaderClassName(String messageSecurityDigestReader) {
        if (messageSecurityDigestReader != null) {
            messageSecurityDigestReaderImplClass = messageSecurityDigestReader;
        }
    }

    public MessageSecurityContext getMessageSecurityContext(MessageSecurityContextParameters messageSecurityContextParameters) throws SecurityException {
        try {
            Constructor<?> constructor = Class.forName(messageSecurityContextImplClass).getConstructor(MessageSecurityContextParameters.class);
            return (MessageSecurityContext)constructor.newInstance(messageSecurityContextParameters);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public static IDigestReader getMessageSecurityDigestReader(SecurityType securityType, Logger log) throws SecurityException {
        try {
            Constructor<?> constructor = Class.forName(messageSecurityDigestReaderImplClass).getConstructor(Logger.class);
            MessageSecurityDigestReader digestReader = (MessageSecurityDigestReader)constructor.newInstance(log);
            return digestReader.getDigestReader(securityType);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }
}

