/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.authorization;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.DynamicNamespaceContextFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XPathExpressionEngine;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.registry.RegistroServiziManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Documento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipiDocumentoSicurezza;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityContext;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.authorization.IMessageSecurityAuthorization;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.authorization.MessageSecurityAuthorizationRequest;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.authorization.MessageSecurityAuthorizationResult;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.resources.FileSystemUtilities;
import it.link.pdd.tools.migrazione_govway.utils.resources.HttpBodyParameters;
import it.link.pdd.tools.migrazione_govway.utils.resources.HttpResponseBody;
import it.link.pdd.tools.migrazione_govway.utils.resources.HttpUtilities;
import it.link.pdd.tools.migrazione_govway.utils.xacml.MarshallUtilities;
import it.link.pdd.tools.migrazione_govway.utils.xacml.PolicyDecisionPoint;
import it.link.pdd.tools.migrazione_govway.utils.xacml.PolicyException;
import it.link.pdd.tools.migrazione_govway.utils.xacml.ResultCombining;
import it.link.pdd.tools.migrazione_govway.utils.xacml.ResultUtilities;
import it.link.pdd.tools.migrazione_govway.utils.xacml.XacmlRequest;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXPathExpressionEngine;
import it.link.pdd.tools.migrazione_govway.utils.xml.DynamicNamespaceContext;
import it.link.pdd.tools.migrazione_govway.utils.xml.XPathException;
import it.link.pdd.tools.migrazione_govway.utils.xml.XPathNotFoundException;
import it.link.pdd.tools.migrazione_govway.utils.xml.XPathNotValidException;
import it.link.pdd.tools.migrazione_govway.utils.xml.XPathReturnType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.herasaf.xacml.core.context.impl.ResultType;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MessageSecurityAuthorizationSAMLPolicy
implements IMessageSecurityAuthorization {
    public static final String SAML_20_ISSUER = "urn:oasis:names:tc:SAML:2.0:assertion:Issuer";
    public static final String SAML_20_SUBJECT_NAME = "urn:oasis:names:tc:SAML:2.0:assertion:Subject:NameID";
    public static final String SAML_20_ATTRIBUTE_NAME = "urn:oasis:names:tc:SAML:2.0:assertion:AttributeStatement:Attribute:Name:";
    public static final String SAML_11_ISSUER = "urn:oasis:names:tc:SAML:2.0:assertion:Issuer";
    public static final String SAML_11_AUTHENTICATION_SUBJECT_NAME = "urn:oasis:names:tc:SAML:1.0:assertion:AuthenticationStatement:Subject:NameIdentifier";
    public static final String SAML_11_AUTHORIZATION_SUBJECT_NAME = "urn:oasis:names:tc:SAML:1.0:assertion:AttributeStatement:Subject:NameIdentifier";
    public static final String SAML_11_ATTRIBUTE_NAME = "urn:oasis:names:tc:SAML:1.0:assertion:AttributeStatement:Attribute:Name:";
    private static PolicyDecisionPoint pdp;
    private AbstractXPathExpressionEngine xpathExpressionEngine;

    private static synchronized void initPdD(Logger log) throws PolicyException {
        if (pdp == null) {
            pdp = new PolicyDecisionPoint(log);
        }
    }

    public MessageSecurityAuthorizationSAMLPolicy() {
        PolicyDecisionPoint.runInitializers();
        this.xpathExpressionEngine = new XPathExpressionEngine();
    }

    @Override
    public MessageSecurityAuthorizationResult authorize(MessageSecurityAuthorizationRequest request) throws SecurityException {
        String principalWSS = request.getWssSecurityPrincipal();
        Busta busta = request.getBusta();
        MessageSecurityContext messageSecurityContext = request.getMessageSecurityContext();
        OpenSPCoop2Message message = request.getMessage();
        IDServizio idServizio = new IDServizio(busta.getTipoDestinatario(), busta.getDestinatario(), busta.getTipoServizio(), busta.getServizio());
        try {
            String actor = messageSecurityContext.getActor();
            if ("".equals(messageSecurityContext.getActor())) {
                actor = null;
            }
            String pdpLocalString = (String)messageSecurityContext.getIncomingProperties().get("pdpLocal");
            boolean pdpLocal = true;
            if (pdpLocalString == null || "".equals(pdpLocalString.trim())) {
                pdpLocal = true;
            } else if ("true".equalsIgnoreCase(pdpLocalString.trim())) {
                pdpLocal = true;
            } else if ("false".equalsIgnoreCase(pdpLocalString.trim())) {
                pdpLocal = false;
            } else {
                throw new SecurityException("Property 'pdpLocal' with wrong value [" + pdpLocalString.trim() + "]");
            }
            String remotePdD_url = null;
            Integer remotePdD_connectionTimeout = 10000;
            Integer remotePdD_readConnectionTimeout = 120000;
            if (!pdpLocal) {
                remotePdD_url = (String)messageSecurityContext.getIncomingProperties().get("pdpRemoteUrl");
                if (pdpLocalString == null || "".equals(pdpLocalString.trim())) {
                    throw new SecurityException("Property 'pdpRemoteUrl' not found (required with pdpLocal=false)");
                }
                pdpLocalString = pdpLocalString.trim();
                try {
                    new URI(remotePdD_url).toString();
                }
                catch (Exception e) {
                    throw new SecurityException("Property 'pdpRemoteUrl' with wrong value [" + remotePdD_url + "]: " + e.getMessage(), e);
                }
                String tmp = (String)messageSecurityContext.getIncomingProperties().get("pdpRemoteConnectionTimeout");
                if (tmp != null && !"".equals(tmp)) {
                    tmp = tmp.trim();
                    try {
                        remotePdD_connectionTimeout = Integer.parseInt(tmp);
                    }
                    catch (Exception e) {
                        throw new SecurityException("Property 'pdpRemoteConnectionTimeout' with wrong value [" + tmp + "]: " + e.getMessage(), e);
                    }
                }
                if ((tmp = (String)messageSecurityContext.getIncomingProperties().get("pdpRemoteReadConnectionTimeout")) != null && !"".equals(tmp)) {
                    tmp = tmp.trim();
                    try {
                        remotePdD_readConnectionTimeout = Integer.parseInt(tmp);
                    }
                    catch (Exception e) {
                        throw new SecurityException("Property 'pdpRemoteReadConnectionTimeout' with wrong value [" + tmp + "]: " + e.getMessage(), e);
                    }
                }
            }
            String tipoSoggettoErogatore = busta.getTipoDestinatario();
            String nomeSoggettoErogatore = busta.getDestinatario();
            String tipoServizio = busta.getTipoServizio();
            String nomeServizio = busta.getServizio();
            String azione = busta.getAzione() != null ? busta.getAzione() : "";
            String servizioKey = "http://" + tipoSoggettoErogatore + nomeSoggettoErogatore + ".openspcoop2.org/servizi/" + tipoServizio + nomeServizio;
            String azioneKey = servizioKey + "/" + azione;
            if (pdpLocal) {
                byte[] policy = null;
                try {
                    AccordoServizioParteSpecifica asps = RegistroServiziManager.getInstance().getAccordoServizioParteSpecifica(idServizio, null, true);
                    for (int i = 0; i < asps.sizeSpecificaSicurezzaList(); ++i) {
                        Documento d = asps.getSpecificaSicurezza(i);
                        if (!TipiDocumentoSicurezza.XACML_POLICY.getNome().equals(d.getTipo())) continue;
                        if (policy == null) {
                            if (d.getByteContenuto() != null) {
                                policy = d.getByteContenuto();
                                continue;
                            }
                            if (d.getFile() == null) continue;
                            if (d.getFile().startsWith("http://") || d.getFile().startsWith("file://")) {
                                URL url = new URL(d.getFile());
                                policy = HttpUtilities.requestHTTPFile(url.toString());
                                continue;
                            }
                            File f = new File(d.getFile());
                            policy = FileSystemUtilities.readBytesFromFile(f);
                            continue;
                        }
                        throw new SecurityException("Piu di una xacml policy trovata trovata per il servizio " + idServizio.toString());
                    }
                }
                catch (Exception e) {
                    throw new SecurityException("Errore durante la ricerca delle policies xacml per il servizio " + idServizio.toString() + ": " + e.getMessage(), e);
                }
                if (policy == null) {
                    throw new SecurityException("Nessuna xacml policy trovata per il servizio " + idServizio.toString());
                }
                if (pdp == null) {
                    MessageSecurityAuthorizationSAMLPolicy.initPdD(messageSecurityContext.getLog());
                }
                pdp.addPolicy(MarshallUtilities.unmarshallPolicy(policy), servizioKey);
            }
            SOAPElement security = null;
            try {
                security = (SOAPElement)WSSecurityUtil.getSecurityHeader((Document)message.getSOAPPart(), (String)actor);
            }
            catch (Exception e) {
                throw new SecurityException("Errore durante la ricerca dell'header WSSecurity (actor:" + actor + ") " + e.getMessage(), e);
            }
            if (security == null) {
                throw new SecurityException("Header WSSecurity (actor:" + actor + ") contenente una SAML non trovato");
            }
            DynamicNamespaceContext dnc = null;
            dnc = message.getVersioneSoap().equals((Object)SOAPVersion.SOAP11) ? DynamicNamespaceContextFactory.getInstance().getNamespaceContextFromSoapEnvelope11(message.getSOAPPart().getEnvelope()) : DynamicNamespaceContextFactory.getInstance().getNamespaceContextFromSoapEnvelope12(message.getSOAPPart().getEnvelope());
            boolean SAML_2_0 = false;
            try {
                Object o = this.xpathExpressionEngine.getMatchPattern(security, dnc, "//{urn:oasis:names:tc:SAML:2.0:assertion}:Assertion", XPathReturnType.NODE);
                SAML_2_0 = o != null;
            }
            catch (XPathNotFoundException e) {
                SAML_2_0 = false;
            }
            XacmlRequest xacmlRequest = new XacmlRequest();
            xacmlRequest.addAction(azioneKey);
            if (principalWSS != null) {
                xacmlRequest.addSubjectAttribute("urn:oasis:names:tc:xacml:1.0:subject:subject-id", principalWSS);
            }
            SAMLAttributes saml = new SAMLAttributes(security, dnc, SAML_2_0, this.xpathExpressionEngine);
            if (SAML_2_0) {
                if (saml.nameIDAuthorization != null) {
                    xacmlRequest.addSubjectAttribute(SAML_20_SUBJECT_NAME, saml.nameIDAuthorization);
                }
            } else {
                if (saml.nameIDAuthorization != null) {
                    xacmlRequest.addSubjectAttribute(SAML_11_AUTHORIZATION_SUBJECT_NAME, saml.nameIDAuthorization);
                }
                if (saml.nameIDAuthentication != null) {
                    xacmlRequest.addSubjectAttribute(SAML_11_AUTHENTICATION_SUBJECT_NAME, saml.nameIDAuthentication);
                }
            }
            if (SAML_2_0) {
                xacmlRequest.addSubjectAttribute("urn:oasis:names:tc:SAML:2.0:assertion:Issuer", saml.issuer);
            } else {
                xacmlRequest.addSubjectAttribute("urn:oasis:names:tc:SAML:2.0:assertion:Issuer", saml.issuer);
            }
            for (String string : saml.customAttributes.keySet()) {
                xacmlRequest.addSubjectAttribute(string, saml.customAttributes.get(string));
            }
            xacmlRequest.createEnvironment();
            List<ResultType> results = null;
            if (pdpLocal) {
                try {
                    xacmlRequest.addResourceAttribute("___resource-id___", servizioKey);
                    messageSecurityContext.getLog().debug("----XACML Request locale begin ---");
                    messageSecurityContext.getLog().debug(new String(MarshallUtilities.marshallRequest(xacmlRequest)));
                    messageSecurityContext.getLog().debug("----XACML Request locale end ---");
                    results = pdp.evaluate(xacmlRequest);
                    messageSecurityContext.getLog().debug("----XACML Results begin ---");
                    for (ResultType resultType : results) {
                        messageSecurityContext.getLog().debug("Decision: " + resultType.getDecision().toString());
                    }
                    messageSecurityContext.getLog().debug("----XACML Results end ---");
                }
                catch (Exception exception) {
                    throw new SecurityException("Errore avvenuto durante l'interrogazione del PdP locale per l'autorizzazione del servizio " + idServizio.toString() + ": " + exception.getMessage(), exception);
                }
            }
            try {
                xacmlRequest.createResource();
                byte[] byArray = MarshallUtilities.marshallRequest(xacmlRequest);
                messageSecurityContext.getLog().debug("----XACML Request remota begin ---");
                messageSecurityContext.getLog().debug(new String(byArray));
                messageSecurityContext.getLog().debug("----XACML Request remota end ---");
                HttpResponseBody httpResponseBody = this.post(remotePdD_url, byArray, remotePdD_readConnectionTimeout, remotePdD_connectionTimeout, null, null);
                if (httpResponseBody.getResultHTTPOperation() != 200) {
                    throw new Exception("invocazione fallita (http-return-code: " + httpResponseBody.getResultHTTPOperation() + ")");
                }
                byte[] res = httpResponseBody.getResponse();
                results = MarshallUtilities.unmarshallResult(res);
            }
            catch (Exception exception) {
                throw new SecurityException("Errore avvenuto durante l'interrogazione del PdP remoto [" + remotePdD_url + "] per l'autorizzazione del servizio " + idServizio.toString() + ": " + exception.getMessage(), exception);
            }
            DecisionType decisionType = ResultCombining.combineDenyOverrides(results);
            MessageSecurityAuthorizationResult messageSecurityAuthorizationResult = new MessageSecurityAuthorizationResult();
            if (DecisionType.PERMIT.equals((Object)decisionType)) {
                messageSecurityAuthorizationResult.setAuthorized(true);
                messageSecurityAuthorizationResult.setErrorMessage(null);
            } else {
                String resultAsString;
                Object url = "";
                String tipo = "XACML-Policy";
                if (!pdpLocal) {
                    url = " url[" + remotePdD_url + "]";
                    tipo = "XACML-Policy-RemotePdp";
                }
                try {
                    resultAsString = ResultUtilities.toRawString(results);
                    messageSecurityContext.getLog().error("Autorizzazione con XACMLPolicy fallita pddLocal[" + pdpLocal + "]" + (String)url + "; results (size:" + results.size() + "): \n" + resultAsString);
                }
                catch (Throwable e) {
                    messageSecurityContext.getLog().error("Autorizzazione con XACMLPolicy fallita pddLocal[" + pdpLocal + "]" + (String)url + ". Serializzazione risposta non riuscita", e);
                }
                messageSecurityAuthorizationResult.setAuthorized(false);
                resultAsString = ResultUtilities.toString(results, decisionType);
                if (resultAsString != null && resultAsString.length() > 0) {
                    messageSecurityAuthorizationResult.setErrorMessage(tipo + " " + resultAsString);
                } else {
                    messageSecurityAuthorizationResult.setErrorMessage(tipo);
                }
            }
            return messageSecurityAuthorizationResult;
        }
        catch (SecurityException e) {
            messageSecurityContext.getLog().error("Errore di sicurezza durante la gestione della richiesta per il servizio: " + idServizio.toString(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            messageSecurityContext.getLog().error("Errore generico durante la gestione della richiesta per il servizio: " + idServizio.toString(), (Throwable)e);
            throw new SecurityException(e);
        }
    }

    private HttpResponseBody post(String path, byte[] body, int readTimeout, int connectTimeout, String username, String password) throws UtilsException {
        InputStream is = null;
        ByteArrayOutputStream outResponse = null;
        try {
            int resultHTTPOperation;
            URL url = new URL(path);
            URLConnection connection = url.openConnection();
            HttpURLConnection httpConn = (HttpURLConnection)connection;
            httpConn.setConnectTimeout(connectTimeout);
            httpConn.setReadTimeout(readTimeout);
            if (username != null && password != null) {
                String authentication = username + ":" + password;
                authentication = "Basic " + Base64.encode((byte[])authentication.getBytes());
                httpConn.setRequestProperty("Authorization", authentication);
            }
            MessageSecurityAuthorizationSAMLPolicy.setStream(httpConn, "POST", "text/xml");
            HttpBodyParameters httpContent = new HttpBodyParameters("POST", "text/xml");
            if (httpContent.isDoOutput() && body != null) {
                OutputStream out = httpConn.getOutputStream();
                out.write(body);
                out.flush();
                out.close();
            }
            if ((resultHTTPOperation = httpConn.getResponseCode()) == 404) {
                throw new UtilsException("404");
            }
            outResponse = new ByteArrayOutputStream();
            if (resultHTTPOperation > 399) {
                is = httpConn.getErrorStream();
                if (is == null) {
                    is = httpConn.getInputStream();
                }
            } else {
                is = httpConn.getInputStream();
                if (is == null) {
                    is = httpConn.getErrorStream();
                }
            }
            byte[] readB = new byte[65536];
            int readByte = 0;
            while ((readByte = is.read(readB)) != -1) {
                outResponse.write(readB, 0, readByte);
            }
            is.close();
            httpConn.disconnect();
            byte[] xmlottenuto = outResponse.toByteArray();
            outResponse.close();
            HttpResponseBody response = new HttpResponseBody();
            response.setResponse(xmlottenuto);
            response.setResultHTTPOperation(resultHTTPOperation);
            return response;
        }
        catch (Exception e) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (outResponse != null) {
                    outResponse.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e.getMessage() != null && e.getMessage().contains("404")) {
                throw new UtilsException("404");
            }
            throw new UtilsException("Utilities.requestHTTPFile error " + e.getMessage(), e);
        }
    }

    public static void setStream(HttpURLConnection httpConn, String httpMethod, String contentType) throws UtilsException {
        try {
            HttpBodyParameters params = new HttpBodyParameters(httpMethod, contentType);
            httpConn.setRequestMethod(httpMethod);
            if (params.isDoOutput()) {
                httpConn.setDoOutput(params.isDoOutput());
            }
            if (params.isDoInput()) {
                httpConn.setDoInput(params.isDoInput());
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private class SAMLAttributes {
        public String nameIDAuthentication;
        public String nameIDAuthorization;
        public String issuer;
        public Map<String, List<String>> customAttributes;
        private DynamicNamespaceContext dnc;
        private boolean saml20;
        private AbstractXPathExpressionEngine xpathExpressionEngine;

        public SAMLAttributes(SOAPElement security, DynamicNamespaceContext dnc, boolean saml20, AbstractXPathExpressionEngine xpathExpressionEngine) throws Exception {
            this.dnc = dnc;
            this.saml20 = saml20;
            this.xpathExpressionEngine = xpathExpressionEngine;
            if (this.saml20) {
                this.nameIDAuthorization = this.find(security, "//{urn:oasis:names:tc:SAML:2.0:assertion}:Assertion/{urn:oasis:names:tc:SAML:2.0:assertion}:Subject/{urn:oasis:names:tc:SAML:2.0:assertion}:NameID/text()", false);
                this.issuer = this.find(security, "//{urn:oasis:names:tc:SAML:2.0:assertion}:Assertion/{urn:oasis:names:tc:SAML:2.0:assertion}:Issuer/text()", true);
            } else {
                this.nameIDAuthorization = this.find(security, "//{urn:oasis:names:tc:SAML:1.0:assertion}:Assertion/{urn:oasis:names:tc:SAML:1.0:assertion}:AttributeStatement/{urn:oasis:names:tc:SAML:1.0:assertion}:Subject/{urn:oasis:names:tc:SAML:1.0:assertion}:NameIdentifier/text()", false);
                this.nameIDAuthentication = this.find(security, "//{urn:oasis:names:tc:SAML:1.0:assertion}:Assertion/{urn:oasis:names:tc:SAML:1.0:assertion}:AuthenticationStatement/{urn:oasis:names:tc:SAML:1.0:assertion}:Subject/{urn:oasis:names:tc:SAML:1.0:assertion}:NameIdentifier/text()", false);
                this.issuer = this.find(security, "//{urn:oasis:names:tc:SAML:1.0:assertion}:Assertion/@Issuer", true);
            }
            this.customAttributes = this.findNameAttributes(security);
        }

        private String find(SOAPElement security, String xpath, boolean required) throws SAXException, SOAPException, XPathException, XPathNotValidException, Exception {
            String match = null;
            try {
                match = (String)this.xpathExpressionEngine.getMatchPattern(security, this.dnc, xpath, XPathReturnType.STRING);
            }
            catch (XPathNotFoundException e) {
                if (required) {
                    throw new Exception(e.getMessage(), e);
                }
                return null;
            }
            return match;
        }

        private Map<String, List<String>> findNameAttributes(SOAPElement security) throws SAXException, SOAPException, XPathException, XPathNotValidException, Exception {
            HashMap<String, List<String>> nameAttributes = new HashMap<String, List<String>>();
            String xpath = null;
            xpath = this.saml20 ? "//{urn:oasis:names:tc:SAML:2.0:assertion}:Assertion/{urn:oasis:names:tc:SAML:2.0:assertion}:AttributeStatement/{urn:oasis:names:tc:SAML:2.0:assertion}:Attribute" : "//{urn:oasis:names:tc:SAML:1.0:assertion}:Assertion/{urn:oasis:names:tc:SAML:1.0:assertion}:AttributeStatement/{urn:oasis:names:tc:SAML:1.0:assertion}:Attribute";
            try {
                NodeList attributes = (NodeList)this.xpathExpressionEngine.getMatchPattern(security, this.dnc, xpath, XPathReturnType.NODESET);
                if (attributes != null) {
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Node friendlyNameAttribute;
                        Node nameAttribute;
                        Node attribute = attributes.item(i);
                        String name = null;
                        String friendlyName = null;
                        boolean uriNameFormat = false;
                        if (this.saml20) {
                            Node nameFormatAttribute;
                            nameAttribute = attribute.getAttributes().getNamedItem("Name");
                            name = nameAttribute.getNodeValue();
                            friendlyNameAttribute = attribute.getAttributes().getNamedItem("FriendlyName");
                            if (friendlyNameAttribute != null) {
                                friendlyName = friendlyNameAttribute.getNodeValue();
                            }
                            if ((nameFormatAttribute = attribute.getAttributes().getNamedItem("NameFormat")) != null) {
                                uriNameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri".equals(nameFormatAttribute.getNodeValue());
                            }
                        } else {
                            nameAttribute = attribute.getAttributes().getNamedItem("AttributeNamespace");
                            name = nameAttribute.getNodeValue();
                            friendlyNameAttribute = attribute.getAttributes().getNamedItem("AttributeName");
                            friendlyName = friendlyNameAttribute.getNodeValue();
                        }
                        if (!uriNameFormat && friendlyName == null && (name.startsWith("urn:") || name.startsWith("url:") || name.startsWith("http:") || name.startsWith("htts:"))) {
                            uriNameFormat = true;
                        }
                        Object key = null;
                        key = friendlyName != null ? (this.saml20 ? MessageSecurityAuthorizationSAMLPolicy.SAML_20_ATTRIBUTE_NAME + friendlyName : MessageSecurityAuthorizationSAMLPolicy.SAML_11_ATTRIBUTE_NAME + friendlyName) : (uriNameFormat ? name : (this.saml20 ? MessageSecurityAuthorizationSAMLPolicy.SAML_20_ATTRIBUTE_NAME + name : MessageSecurityAuthorizationSAMLPolicy.SAML_11_ATTRIBUTE_NAME + name));
                        String samlNamespace = null;
                        samlNamespace = this.saml20 ? "urn:oasis:names:tc:SAML:2.0:assertion" : "urn:oasis:names:tc:SAML:1.0:assertion";
                        List values = null;
                        values = nameAttributes.containsKey(key) ? (List)nameAttributes.remove(key) : new ArrayList();
                        NodeList attributeValues = attribute.getChildNodes();
                        if (attributeValues != null) {
                            for (int j = 0; j < attributeValues.getLength(); ++j) {
                                Node attributeValue = attributeValues.item(j);
                                if (attributeValue == null || !"AttributeValue".equals(attributeValue.getLocalName()) || !samlNamespace.equals(attributeValue.getNamespaceURI())) continue;
                                values.add(attributeValue.getTextContent());
                            }
                        }
                        nameAttributes.put((String)key, values);
                    }
                }
            }
            catch (XPathNotFoundException e) {
                throw new Exception("Impossibile trovare l'xPath [" + xpath + "]");
            }
            return nameAttributes;
        }
    }
}

