/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SoapUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.reference.Reference;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.IMessageSecurityContext;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.IMessageSecurityDigest;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.IMessageSecurityReceiver;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.IMessageSecuritySender;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityContextParameters;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.SubErrorCodeSecurity;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.digest.IDigestReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public abstract class MessageSecurityContext {
    protected Hashtable<String, Object> incomingProperties = new Hashtable();
    protected Hashtable<String, Object> outgoingProperties = new Hashtable();
    protected boolean useActorDefaultIfNotDefined = true;
    protected String actorDefault = null;
    protected String actor;
    protected String msgErrore;
    protected CodiceErroreCooperazione codiceErrore;
    protected List<SubErrorCodeSecurity> listaSubCodiceErrore = new ArrayList<SubErrorCodeSecurity>();
    protected boolean functionAsClient = true;
    protected String prefixWsuId;
    protected boolean removeAllWsuIdRef;
    protected String securityEngine;
    protected IMessageSecurityContext messageSecurityContext;
    protected IMessageSecuritySender messageSecuritySender;
    protected IMessageSecurityReceiver messageSecurityReceiver;
    protected IMessageSecurityDigest messageSecurityDigest;
    protected Logger log;
    private IDSoggetto idFruitore;
    private String pddFruitore;
    private IDServizio idServizio;
    private String pddErogatore;
    private boolean useXMLSec = true;
    private List<Reference> references;

    public Logger getLog() {
        return this.log;
    }

    public IDSoggetto getIdFruitore() {
        return this.idFruitore;
    }

    public IDServizio getIdServizio() {
        return this.idServizio;
    }

    public String getPddFruitore() {
        return this.pddFruitore;
    }

    public String getPddErogatore() {
        return this.pddErogatore;
    }

    public boolean isUseXMLSec() {
        return this.useXMLSec;
    }

    public void setUseXMLSec(boolean useXMLSec) {
        this.useXMLSec = useXMLSec;
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public void setReferences(List<Reference> references) {
        this.references = references;
    }

    public MessageSecurityContext(MessageSecurityContextParameters messageSecurityContextParameters) {
        this.useActorDefaultIfNotDefined = messageSecurityContextParameters.isUseActorDefaultIfNotDefined();
        this.actorDefault = messageSecurityContextParameters.getActorDefault();
        this.log = messageSecurityContextParameters.getLog() != null ? messageSecurityContextParameters.getLog() : LoggerWrapperFactory.getLogger(MessageSecurityContext.class);
        this.functionAsClient = messageSecurityContextParameters.isFunctionAsClient();
        this.prefixWsuId = messageSecurityContextParameters.getPrefixWsuId();
        this.removeAllWsuIdRef = messageSecurityContextParameters.isRemoveAllWsuIdRef();
        this.idFruitore = messageSecurityContextParameters.getIdFruitore();
        this.idServizio = messageSecurityContextParameters.getIdServizio();
        this.pddFruitore = messageSecurityContextParameters.getPddFruitore();
        this.pddErogatore = messageSecurityContextParameters.getPddErogatore();
    }

    public abstract boolean processIncoming(OpenSPCoop2Message var1, Busta var2);

    public abstract boolean processOutgoing(OpenSPCoop2Message var1);

    public void setFunctionAsClient(boolean functionAsClient) {
        this.functionAsClient = functionAsClient;
    }

    public boolean isFunctionAsClient() {
        return this.functionAsClient;
    }

    public String getPrefixWsuId() {
        return this.prefixWsuId;
    }

    public boolean isRemoveAllWsuIdRef() {
        return this.removeAllWsuIdRef;
    }

    public abstract String getSubject();

    public String getMsgErrore() {
        return this.msgErrore;
    }

    public CodiceErroreCooperazione getCodiceErrore() {
        return this.codiceErrore;
    }

    public List<SubErrorCodeSecurity> getListaSubCodiceErrore() {
        return this.listaSubCodiceErrore;
    }

    public String getActor() {
        return this.actor;
    }

    private void setActor(boolean incoming) {
        boolean actorDefinito = false;
        boolean mustUnderstandTrue = false;
        Hashtable<String, Object> securityProperties = null;
        securityProperties = incoming ? this.incomingProperties : this.outgoingProperties;
        if (securityProperties != null && securityProperties.size() > 0) {
            Enumeration<String> e = securityProperties.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                String value = (String)securityProperties.get(key);
                if ("actor".equals(key)) {
                    this.actor = value;
                }
                if ("mustUnderstand".equals(key)) {
                    if (!"true".equals(value)) continue;
                    mustUnderstandTrue = true;
                    continue;
                }
                if (!"actor".equals(key)) continue;
                actorDefinito = true;
            }
        }
        if (mustUnderstandTrue && !actorDefinito && this.useActorDefaultIfNotDefined) {
            this.actor = this.actorDefault;
        }
    }

    public void setIncomingProperties(Hashtable<String, Object> secProperties) throws SecurityException {
        this.incomingProperties = secProperties;
        this.setActor(true);
        this.readMessageSecurityEngine(true);
        this.readSignatureEngine(true);
    }

    public Hashtable<String, Object> getIncomingProperties() {
        return this.incomingProperties;
    }

    public void setOutgoingProperties(Hashtable<String, Object> secProperties) throws SecurityException {
        this.outgoingProperties = secProperties;
        this.setActor(false);
        this.readMessageSecurityEngine(false);
        this.readSignatureEngine(false);
    }

    public Hashtable<String, Object> getOutgoingProperties() {
        return this.outgoingProperties;
    }

    public String getSecurityEngine() {
        return this.securityEngine;
    }

    public IMessageSecurityContext getMessageSecurityContext() {
        return this.messageSecurityContext;
    }

    public IMessageSecuritySender getMessageSecuritySender() {
        return this.messageSecuritySender;
    }

    public IMessageSecurityReceiver getMessageSecurityReceiver() {
        return this.messageSecurityReceiver;
    }

    public IMessageSecurityDigest getMessageSecurityDigest() {
        return this.messageSecurityDigest;
    }

    public IDigestReader getDigestReader() throws SecurityException {
        if (this.messageSecurityDigest != null) {
            return this.getMessageSecurityDigest().getDigestReader(this);
        }
        return null;
    }

    private void readMessageSecurityEngine(boolean incoming) throws SecurityException {
        try {
            this.securityEngine = "wss4j";
            String engineProperty = null;
            engineProperty = incoming ? (String)this.incomingProperties.get("securityEngine") : (String)this.outgoingProperties.get("securityEngine");
            if (engineProperty != null) {
                if ("wss4j".equals(engineProperty = engineProperty.trim())) {
                    this.securityEngine = "wss4j";
                } else if ("soapbox".equals(engineProperty)) {
                    this.securityEngine = "soapbox";
                } else {
                    throw new SecurityException("Security engine impostato [" + engineProperty + "] non supportato");
                }
            }
            if ("wss4j".equals(this.securityEngine)) {
                this.messageSecurityContext = (IMessageSecurityContext)Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.wss4j.MessageSecurityContext_wss4j").getConstructor(new Class[0]).newInstance(new Object[0]);
                this.messageSecuritySender = (IMessageSecuritySender)Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.wss4j.MessageSecuritySender_wss4j").getConstructor(new Class[0]).newInstance(new Object[0]);
                this.messageSecurityReceiver = (IMessageSecurityReceiver)Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.wss4j.MessageSecurityReceiver_wss4j").getConstructor(new Class[0]).newInstance(new Object[0]);
                this.messageSecurityDigest = (IMessageSecurityDigest)Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.wss4j.MessageSecurityDigest_wss4j").getConstructor(new Class[0]).newInstance(new Object[0]);
            } else if ("soapbox".equals(this.securityEngine)) {
                this.messageSecurityContext = (IMessageSecurityContext)Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.MessageSecurityContext_soapbox").getConstructor(new Class[0]).newInstance(new Object[0]);
                this.messageSecuritySender = (IMessageSecuritySender)Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.MessageSecuritySender_soapbox").getConstructor(new Class[0]).newInstance(new Object[0]);
                this.messageSecurityReceiver = (IMessageSecurityReceiver)Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.MessageSecurityReceiver_soapbox").getConstructor(new Class[0]).newInstance(new Object[0]);
                this.messageSecurityDigest = (IMessageSecurityDigest)Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.soapbox.MessageSecurityDigest_soapbox").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            this.messageSecurityContext.init(this);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    private void readSignatureEngine(boolean incoming) throws SecurityException {
        block4: {
            try {
                this.useXMLSec = true;
                String engineProperty = null;
                engineProperty = incoming ? (String)this.incomingProperties.get("signatureEngine") : (String)this.outgoingProperties.get("signatureEngine");
                if (engineProperty == null) break block4;
                if ("sun".equalsIgnoreCase(engineProperty = engineProperty.trim())) {
                    this.useXMLSec = false;
                    break block4;
                }
                if ("xmlSec".equalsIgnoreCase(engineProperty)) {
                    this.useXMLSec = true;
                    break block4;
                }
                throw new SecurityException("Signature engine impostato [" + engineProperty + "] non supportato");
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
        }
    }

    public boolean existsSecurityHeader(OpenSPCoop2Message msg, String actor) {
        try {
            if (msg == null) {
                return false;
            }
            SOAPHeader header = msg.getSOAPHeader();
            if (header == null || SoapUtils.getNotEmptyChildNodes((Node)header).size() == 0) {
                return false;
            }
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                if (!"Security".equals(headerElement.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(headerElement.getNamespaceURI())) continue;
                String actorCheck = SoapUtils.getSoapActor(headerElement, msg.getVersioneSoap());
                if (actor == null) {
                    return actorCheck == null;
                }
                return actor.equals(actorCheck);
            }
            return false;
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error("existsHeaderMessageSecurity error con actor[" + actor + "]", (Throwable)e);
            }
            return false;
        }
    }
}

