/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.cache;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.CRLCertstore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.MerlinKeystore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.MerlinTruststore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.MultiKeystore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.SymmetricKeystore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.cache.CRLCertstoreCache;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.cache.MerlinKeystoreCache;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.cache.MerlinTruststoreCache;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.cache.MultiKeystoreCache;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.cache.SymmetricKeystoreCache;

public class GestoreKeystoreCache {
    private static final MerlinTruststoreCache merlinTruststoreCache = new MerlinTruststoreCache();
    private static final MerlinKeystoreCache merlinKeystoreCache = new MerlinKeystoreCache();
    private static final SymmetricKeystoreCache symmetricKeystoreCache = new SymmetricKeystoreCache();
    private static final MultiKeystoreCache multiKeystoreCache = new MultiKeystoreCache();
    private static final CRLCertstoreCache crlCertstoreCache = new CRLCertstoreCache();
    private static boolean cacheEnabled = false;

    public static void setKeystoreCacheParameters(boolean cacheEnabled, int cacheLifeSecond, int cacheSize) {
        GestoreKeystoreCache.cacheEnabled = cacheEnabled;
        merlinTruststoreCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        merlinKeystoreCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        symmetricKeystoreCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        multiKeystoreCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        crlCertstoreCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
    }

    public static MerlinTruststore getMerlinTruststore(String propertyFilePath) throws SecurityException {
        if (cacheEnabled) {
            return (MerlinTruststore)merlinTruststoreCache.getKeystoreAndCreateIfNotExists(propertyFilePath, new Object[0]);
        }
        return new MerlinTruststore(propertyFilePath);
    }

    public static MerlinTruststore getMerlinTruststore(String pathStore, String tipoStore, String passwordStore) throws SecurityException {
        if (cacheEnabled) {
            return (MerlinTruststore)merlinTruststoreCache.getKeystoreAndCreateIfNotExists(pathStore, tipoStore, passwordStore);
        }
        return new MerlinTruststore(pathStore, tipoStore, passwordStore);
    }

    public static MerlinKeystore getMerlinKeystore(String propertyFilePath, String passwordPrivateKey) throws SecurityException {
        if (cacheEnabled) {
            return (MerlinKeystore)merlinKeystoreCache.getKeystoreAndCreateIfNotExists(propertyFilePath, passwordPrivateKey);
        }
        return new MerlinKeystore(propertyFilePath, passwordPrivateKey);
    }

    public static MerlinKeystore getMerlinKeystore(String pathStore, String tipoStore, String passwordStore, String passwordPrivateKey) throws SecurityException {
        if (cacheEnabled) {
            return (MerlinKeystore)merlinKeystoreCache.getKeystoreAndCreateIfNotExists(pathStore, tipoStore, passwordStore, passwordPrivateKey);
        }
        return new MerlinKeystore(pathStore, tipoStore, passwordStore, passwordPrivateKey);
    }

    public static SymmetricKeystore getSymmetricKeystore(String alias, String key, String algoritmo) throws SecurityException {
        if (cacheEnabled) {
            return (SymmetricKeystore)symmetricKeystoreCache.getKeystoreAndCreateIfNotExists(key, alias, algoritmo);
        }
        return new SymmetricKeystore(alias, key, algoritmo);
    }

    public static MultiKeystore getMultiKeystore(String propertyFilePath) throws SecurityException {
        if (cacheEnabled) {
            return (MultiKeystore)multiKeystoreCache.getKeystoreAndCreateIfNotExists(propertyFilePath, new Object[0]);
        }
        return new MultiKeystore(propertyFilePath);
    }

    public static CRLCertstore getCRLCertstore(String crlPath) throws SecurityException {
        if (cacheEnabled) {
            return (CRLCertstore)crlCertstoreCache.getKeystoreAndCreateIfNotExists(crlPath, new Object[0]);
        }
        return new CRLCertstore(crlPath);
    }
}

