/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.cache;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.cache.KeystoreCacheEntry;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import java.util.Hashtable;

public abstract class AbstractKeystoreCache<T> {
    private int cacheLifeSecond = -1;
    private int cacheSize = -1;
    private Hashtable<String, KeystoreCacheEntry<T>> cache = new Hashtable();

    public void setKeystoreCacheParameters(int cacheLifeSecond, int cacheSize) {
        this.cacheLifeSecond = cacheLifeSecond;
        this.cacheSize = cacheSize;
    }

    public boolean existsKeystore(String key) {
        return this.cache.containsKey(key);
    }

    public T getKeystore(String key) throws SecurityException {
        KeystoreCacheEntry<T> o = this.cache.get(key);
        if (o == null) {
            throw new SecurityException("Keystore with key [" + key + "] not found");
        }
        return this.estraiKeystore(o);
    }

    public T getKeystoreAndCreateIfNotExists(String key, Object ... params) throws SecurityException {
        KeystoreCacheEntry<T> o = this.cache.get(key);
        if (o == null) {
            return this.initKeystore(key, params);
        }
        return this.estraiKeystore(o);
    }

    public abstract T createKeystore(String var1, Object ... var2) throws SecurityException;

    private synchronized T initKeystore(String key, Object ... params) throws SecurityException {
        if (!this.cache.containsKey(key)) {
            T keystore = this.createKeystore(key, params);
            KeystoreCacheEntry<T> cacheEntry = new KeystoreCacheEntry<T>();
            cacheEntry.setKey(key);
            cacheEntry.setKeystore(keystore);
            cacheEntry.setDate(DateManager.getDate());
            this.cache.put(key, cacheEntry);
            return keystore;
        }
        return this.estraiKeystore(this.cache.get(key));
    }

    private T estraiKeystore(KeystoreCacheEntry<T> entry) throws SecurityException {
        long now;
        long scadenza;
        T keystore = entry.getKeystore();
        if (this.cacheLifeSecond > -1 && (scadenza = entry.getDate().getTime() + (long)(this.cacheLifeSecond * 1000)) < (now = DateManager.getTimeMillis())) {
            this.removeKeystore(entry.getKey());
        }
        if (this.cacheSize > -1 && this.cache.size() > this.cacheSize) {
            this.clearKeystore();
        }
        return keystore;
    }

    private synchronized void removeKeystore(String key) {
        if (this.cache.containsKey(key)) {
            this.cache.remove(key);
        }
    }

    private synchronized void clearKeystore() {
        this.cache.clear();
    }
}

