/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.MerlinKeystore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.SymmetricKeystore;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;

public class MultiKeystore {
    private static final String ALIASES = "aliases";
    private static final String KEYSTORE_TYPE = ".keystore.type";
    private static final String KEYSTORE_PATH = ".keystore.path";
    private static final String KEYSTORE_PASSWORD = ".keystore.password";
    private static final String KEY_ALIAS = ".key.alias";
    private static final String KEY_PASSWORD = ".key.password";
    private static final String KEY_VALUE = ".key.value";
    private static final String KEY_ALGORITHM = ".key.algorithm";
    private List<String> aliases = new ArrayList<String>();
    private Hashtable<String, Object> keystores = new Hashtable();
    private Hashtable<String, String> mappingAliasToKeyAlias = new Hashtable();
    private Hashtable<String, String> mappingAliasToKeyPassword = new Hashtable();

    public MultiKeystore(String propertyFilePath) throws SecurityException {
        InputStream isStore = null;
        try {
            File fStore = new File(propertyFilePath);
            if (fStore.exists()) {
                isStore = new FileInputStream(fStore);
            } else {
                isStore = MerlinKeystore.class.getResourceAsStream("/" + propertyFilePath);
                if (isStore == null) {
                    throw new Exception("Store [" + propertyFilePath + "] not found");
                }
            }
            Properties multiProperties = new Properties();
            multiProperties.load(isStore);
            isStore.close();
            String keyAliases = this.getProperty(multiProperties, ALIASES);
            String[] tmp = keyAliases.split(",");
            for (int i = 0; i < tmp.length; ++i) {
                if (this.aliases.contains(tmp[i].trim())) continue;
                this.aliases.add(tmp[i].trim());
            }
            for (String alias : this.aliases) {
                String keyAlias = null;
                try {
                    keyAlias = this.getProperty(multiProperties, alias + KEY_ALIAS);
                }
                catch (Exception e) {
                    keyAlias = alias;
                }
                String keyPassword = this.getProperty(multiProperties, alias + KEY_PASSWORD);
                String keyValue = multiProperties.getProperty(alias + KEY_VALUE);
                if (keyValue != null) {
                    String keyAlgorithm = this.getProperty(multiProperties, alias + KEY_ALGORITHM);
                    try {
                        this.keystores.put(alias, new SymmetricKeystore(keyAlias, keyValue, keyAlgorithm));
                    }
                    catch (Throwable e) {
                        String idKeystore = "!!! Errore durante il caricamento del SymmetricKeystore !!! [keyAlias:" + keyAlias + "] ";
                        LoggerWrapperFactory.getLogger(MultiKeystore.class).error(idKeystore + e.getMessage(), e);
                    }
                } else {
                    String keystoreType = this.getProperty(multiProperties, alias + KEYSTORE_TYPE);
                    String keystorePath = this.getProperty(multiProperties, alias + KEYSTORE_PATH);
                    String keystorePassword = this.getProperty(multiProperties, alias + KEYSTORE_PASSWORD);
                    try {
                        this.keystores.put(alias, new MerlinKeystore(keystorePath, keystoreType, keystorePassword, keyPassword));
                    }
                    catch (Throwable e) {
                        String idKeystore = "!!! Errore durante il caricamento del MerlinKeystore !!! [keyAlias:" + keyAlias + "] ";
                        LoggerWrapperFactory.getLogger(MultiKeystore.class).error(idKeystore + e.getMessage(), e);
                    }
                }
                this.mappingAliasToKeyAlias.put(alias, keyAlias);
                this.mappingAliasToKeyPassword.put(alias, keyPassword);
            }
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
        finally {
            try {
                if (isStore != null) {
                    isStore.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private String getProperty(Properties multiProperties, String property) throws SecurityException {
        if (!multiProperties.containsKey(property)) {
            throw new SecurityException("Proprieta' [" + property + "] non trovata nel MultiProperties file");
        }
        return multiProperties.getProperty(property).trim();
    }

    public Key getKey(String alias) throws SecurityException {
        try {
            if (!this.aliases.contains(alias)) {
                throw new Exception("Alias[" + alias + "] non trovato nella configurazione MultiKeystore");
            }
            Object keystore = this.keystores.get(alias);
            if (keystore == null) {
                throw new Exception("Non esiste un keystore per l'alias[" + alias + "]; verificare che non sia avvenuti errori durante l'inizializzazione (MultiKeystore)");
            }
            if (keystore instanceof MerlinKeystore) {
                return ((MerlinKeystore)keystore).getKey(this.mappingAliasToKeyAlias.get(alias));
            }
            if (keystore instanceof MerlinKeystore) {
                return ((SymmetricKeystore)keystore).getKey();
            }
            throw new Exception("Tipo di Keystore non supportato: " + keystore.getClass().getName());
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public boolean existsAlias(String alias) {
        return this.aliases.contains(alias);
    }

    public KeyStore getKeyStore(String alias) throws SecurityException {
        try {
            if (!this.aliases.contains(alias)) {
                throw new Exception("Alias[" + alias + "] non trovato nella configurazione MultiKeystore");
            }
            Object keystore = this.keystores.get(alias);
            if (keystore == null) {
                throw new Exception("Non esiste un keystore per l'alias[" + alias + "]; verificare che non sia avvenuti errori durante l'inizializzazione (MultiKeystore)");
            }
            if (keystore instanceof MerlinKeystore) {
                return ((MerlinKeystore)keystore).getKeyStore();
            }
            if (keystore instanceof MerlinKeystore) {
                return ((SymmetricKeystore)keystore).getKeyStore();
            }
            throw new Exception("Tipo di Keystore non supportato: " + keystore.getClass().getName());
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public String getKeyAlias(String alias) throws SecurityException {
        try {
            if (!this.aliases.contains(alias)) {
                throw new Exception("Alias[" + alias + "] non trovato nella configurazione MultiKeystore");
            }
            return this.mappingAliasToKeyAlias.get(alias);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public String getKeyPassword(String alias) throws SecurityException {
        try {
            if (!this.aliases.contains(alias)) {
                throw new Exception("Alias[" + alias + "] non trovato nella configurazione MultiKeystore");
            }
            return this.mappingAliasToKeyPassword.get(alias);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }
}

