/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore.FixTrustAnchorsNotEmpty;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.util.Properties;

public class MerlinKeystore {
    private KeyStore ks = null;
    private String tipoStore = null;
    private String pathStore = null;
    private String passwordStore = null;
    private String passwordPrivateKey = null;

    public MerlinKeystore(String propertyFilePath, String passwordPrivateKey) throws SecurityException {
        InputStream isStore = null;
        try {
            if (propertyFilePath == null) {
                throw new Exception("PropertyFilePath per lo Store non indicato");
            }
            File fStore = new File(propertyFilePath);
            if (fStore.exists()) {
                isStore = new FileInputStream(fStore);
            } else {
                isStore = MerlinKeystore.class.getResourceAsStream("/" + propertyFilePath);
                if (isStore == null) {
                    throw new Exception("Store [" + propertyFilePath + "] not found");
                }
            }
            Properties propStore = new Properties();
            propStore.load(isStore);
            isStore.close();
            this.tipoStore = propStore.getProperty("org.apache.ws.security.crypto.merlin.keystore.type");
            this.tipoStore = this.tipoStore != null ? this.tipoStore.trim() : KeyStore.getDefaultType();
            this.pathStore = propStore.getProperty("org.apache.ws.security.crypto.merlin.file");
            this.passwordStore = propStore.getProperty("org.apache.ws.security.crypto.merlin.keystore.password");
            this.init(passwordPrivateKey);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
        finally {
            try {
                if (isStore != null) {
                    isStore.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public MerlinKeystore(String pathStore, String tipoStore, String passwordStore, String passwordPrivateKey) throws SecurityException {
        this.pathStore = pathStore;
        this.tipoStore = tipoStore;
        this.passwordStore = passwordStore;
        this.init(passwordPrivateKey);
    }

    private void init(String passwordPrivateKey) throws SecurityException {
        try {
            if (this.pathStore == null) {
                throw new Exception("Path per lo Store non indicato");
            }
            if (this.tipoStore == null) {
                throw new Exception("Tipo dello Store non indicato");
            }
            if (this.passwordStore == null) {
                throw new Exception("Password dello Store non indicata");
            }
            File fPathStore = new File(this.pathStore);
            if (!fPathStore.exists()) {
                throw new Exception("keystore [" + fPathStore.getAbsolutePath() + "] not found");
            }
            FileInputStream finStore = new FileInputStream(fPathStore);
            this.ks = KeyStore.getInstance(this.tipoStore);
            this.ks.load(finStore, this.passwordStore.toCharArray());
            finStore.close();
            FixTrustAnchorsNotEmpty.addCertificate(this.ks);
            if (passwordPrivateKey == null) {
                throw new Exception("Password chiave private non indicata per lo Store [" + this.pathStore + "] ");
            }
            this.passwordPrivateKey = passwordPrivateKey;
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public Key getKey(String alias) throws SecurityException {
        try {
            return this.ks.getKey(alias, this.passwordPrivateKey.toCharArray());
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public KeyStore getKeyStore() throws SecurityException {
        try {
            return this.ks;
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }
}

