/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;

public class FixTrustAnchorsNotEmpty {
    private static CertificateFactory cf = null;
    private static Certificate certFix = null;

    private static synchronized void initCertificateFactory() {
        if (cf == null) {
            InputStream is = null;
            try {
                cf = CertificateFactory.getInstance("X.509");
                is = FixTrustAnchorsNotEmpty.class.getResourceAsStream("/it.link.pdd.tools.migrazione_govway.openspcoop2_core.security/keystore/FixTrustAnchorsParameterMustBeNonEmpty.cer");
                certFix = cf.generateCertificate(is);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void addCertificate(KeyStore keystore) throws SecurityException {
        try {
            Enumeration<String> aliases = keystore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keystore.isCertificateEntry(alias)) continue;
                return;
            }
            if (cf == null) {
                FixTrustAnchorsNotEmpty.initCertificateFactory();
            }
            keystore.setCertificateEntry("FixTrustAnchorsParameterMustBeNonEmpty", certFix);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }
}

