/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.keystore;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.SecurityException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.CertStore;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.util.ArrayList;

public class CRLCertstore {
    private CertificateFactory certFactory = null;
    private X509CRL caCrl = null;
    private CertStore certStore = null;

    public CRLCertstore(String crlPath) throws SecurityException {
        InputStream isStore = null;
        try {
            if (crlPath == null) {
                throw new Exception("crlPath non indicato");
            }
            File fStore = new File(crlPath);
            if (fStore.exists()) {
                isStore = new FileInputStream(fStore);
            } else {
                isStore = CRLCertstore.class.getResourceAsStream("/" + crlPath);
                if (isStore == null) {
                    throw new Exception("Store [" + crlPath + "] not found");
                }
            }
            this.certFactory = CertificateFactory.getInstance("X.509");
            this.caCrl = (X509CRL)this.certFactory.generateCRL(isStore);
            ArrayList<X509CRL> crlList = new ArrayList<X509CRL>();
            crlList.add(this.caCrl);
            CollectionCertStoreParameters certStoreParams = new CollectionCertStoreParameters(crlList);
            this.certStore = CertStore.getInstance("Collection", certStoreParams);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
        finally {
            try {
                if (isStore != null) {
                    isStore.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public CertificateFactory getCertFactory() {
        return this.certFactory;
    }

    public X509CRL getCaCrl() {
        return this.caCrl;
    }

    public CertStore getCertStore() {
        return this.certStore;
    }
}

