/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.wsdl;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SoapUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.MessagePart;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Operation;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.BindingStyle;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.BindingUse;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.CostantiRegistroServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.wsdl.AccordoServizioWrapper;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.wsdl.RootElementBody;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.wsdl.WSDLValidatorException;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.wsdl.WSDLException;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.ValidatoreXSD;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import org.slf4j.Logger;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WSDLValidator {
    public static final String XMLSCHEMA_INSTANCE_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XMLSCHEMA_INSTANCE_LOCAL_NAME_TYPE = "type";
    private static final String PREFIX_RPC_AGGIUNTO = "op2RPC";
    private OpenSPCoop2Message openspcoop2Message;
    SOAPVersion soapVersion;
    SOAPEnvelope envelope;
    SOAPBody body;
    AccordoServizioWrapper accordoServizioWrapper = null;
    Logger logger = null;
    AbstractXMLUtils xmlUtils = null;
    private boolean gestioneXsiType_rpcLiteral;
    private SOAPElement rpcChildElement;
    private QName rpcChildElementNamespaceAggiunto;
    private QName rpcChildElementXSITypeAggiunto;
    private PortType ptWsdlConformanceCheck = null;
    private Operation opWsdlConformanceCheck = null;

    public WSDLValidator(OpenSPCoop2Message msg, AbstractXMLUtils xmlUtils, AccordoServizioWrapper accordoServizioWrapper, Logger log, boolean gestioneXsiType_rpcLiteral) throws WSDLException {
        this.openspcoop2Message = msg;
        this.soapVersion = msg.getVersioneSoap();
        try {
            this.envelope = msg.getSOAPPart().getEnvelope();
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), e);
        }
        if (this.envelope == null) {
            throw new WSDLException("SOAPEnvelope non esistente");
        }
        try {
            this.body = this.envelope.getBody();
        }
        catch (Exception e) {
            this.logger.error("SOAPEnvelope.getBody failed: " + e.getMessage(), (Throwable)e);
            throw new WSDLException("SOAPEnvelope senza body");
        }
        if (this.body == null || !this.body.hasChildNodes()) {
            throw new WSDLException("SOAPBody non esistente");
        }
        this.logger = log;
        this.xmlUtils = xmlUtils;
        this.accordoServizioWrapper = accordoServizioWrapper;
        this.gestioneXsiType_rpcLiteral = gestioneXsiType_rpcLiteral;
    }

    public void wsdlConformanceCheck_restoreOriginalDocument() {
        if (this.gestioneXsiType_rpcLiteral && this.rpcChildElement != null) {
            try {
                if (this.rpcChildElementXSITypeAggiunto != null) {
                    this.rpcChildElement.removeAttribute(this.rpcChildElementXSITypeAggiunto);
                }
            }
            catch (Exception e) {
                this.logger.error("Errore durante l'eliminazione dell'attributo [" + this.rpcChildElementXSITypeAggiunto + "] dal rpc element");
            }
            try {
                if (this.rpcChildElementNamespaceAggiunto != null) {
                    this.rpcChildElement.removeAttribute(this.rpcChildElementNamespaceAggiunto);
                    this.rpcChildElement.removeNamespaceDeclaration(PREFIX_RPC_AGGIUNTO);
                }
            }
            catch (Exception e) {
                this.logger.error("Errore durante l'eliminazione dell'attributo [" + this.rpcChildElementNamespaceAggiunto + "] dal rpc element");
            }
        }
    }

    public void validateAgainstXSDSchema(boolean isRichiesta, String operationName) throws WSDLException, WSDLValidatorException {
        this.validateAgainstXSDSchema(isRichiesta, operationName, this.ptWsdlConformanceCheck, this.opWsdlConformanceCheck);
    }

    public void validateAgainstXSDSchema(boolean isRichiesta, String operationName, PortType portType, Operation operation) throws WSDLException, WSDLValidatorException {
        ValidatoreXSD validatoreBodyApplicativo = null;
        try {
            if (this.accordoServizioWrapper.getSchema() == null) {
                throw new Exception("Schema non costruito?");
            }
            validatoreBodyApplicativo = new ValidatoreXSD(this.accordoServizioWrapper.getSchema());
        }
        catch (Exception e) {
            throw new WSDLException("Riscontrato errore durante la costruzione del validatore XSD per il contenuto applicativo: " + e.getMessage(), e);
        }
        if (portType == null && this.accordoServizioWrapper.getNomePortType() != null && (portType = this.accordoServizioWrapper.getPortType(this.accordoServizioWrapper.getNomePortType())) == null) {
            try {
                IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
                String uriAccordo = idAccordoFactory.getUriFromIDAccordo(this.accordoServizioWrapper.getIdAccordoServizio());
                if (this.accordoServizioWrapper.isPortTypesLoadedFromWSDL()) {
                    this.logger.debug("Port-Type [" + this.accordoServizioWrapper.getNomePortType() + "] non esistente nei wsdl registrati all'interno dell'accordo di servizio " + uriAccordo);
                } else {
                    this.logger.debug("Servizio [" + this.accordoServizioWrapper.getNomePortType() + "] non esistente nell'accordo di servizio " + uriAccordo);
                }
            }
            catch (Exception e) {
                this.logger.error("Errore durante l'emissione del log che indica la non esistenza del porttype/servizio [" + this.accordoServizioWrapper.getNomePortType() + "] nei wsdl registrati all'interno dell'accordo di servizio: " + e.getMessage(), (Throwable)e);
            }
        }
        if (operation == null && operationName != null && portType != null) {
            for (int i = 0; i < portType.sizeAzioneList(); ++i) {
                if (!operationName.equals(portType.getAzione(i).getNome())) continue;
                operation = portType.getAzione(i);
                break;
            }
        }
        StringBuffer errorMsgValidazioneXSD = new StringBuffer();
        if (portType == null || operation == null) {
            this.logger.debug("Validazione XSD senza considerare il WSDLAccordoServizio e quindi senza considerare style (document/rpc) e gli use (literal/encoded)");
            NodeList nl = this.body.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i) instanceof Text || nl.item(i) instanceof Comment) continue;
                Object nomeElemento = null;
                String namespaceElemento = null;
                Node n = null;
                try {
                    n = nl.item(i);
                    nomeElemento = n.getLocalName();
                    namespaceElemento = n.getNamespaceURI();
                    this.openspcoop2Message.addNamespaceXSITypeIfNotExists(n, (Node)this.envelope);
                    validatoreBodyApplicativo.valida(n, true);
                    continue;
                }
                catch (Exception e) {
                    if (errorMsgValidazioneXSD.length() == 0) {
                        errorMsgValidazioneXSD.append("Riscontrata non conformit\u00e0 rispetto agli schemi XSD\n");
                    } else {
                        errorMsgValidazioneXSD.append("\n");
                    }
                    if (namespaceElemento != null) {
                        nomeElemento = "{" + namespaceElemento + "}" + (String)nomeElemento;
                    }
                    errorMsgValidazioneXSD.append("(elemento " + (String)nomeElemento + "): " + e.getMessage());
                    String elementNonValidato = null;
                    try {
                        elementNonValidato = this.xmlUtils.toString(n);
                    }
                    catch (Exception eString) {
                        this.logger.error("Errore durante la conversione del Node in String: " + eString.getMessage(), (Throwable)eString);
                    }
                    this.logger.error("Validazione fallita (elemento " + (String)nomeElemento + ") [" + elementNonValidato + "]: " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            this.logger.debug("Validazione XSD che considera il WSDLAccordoServizio (ho localizzato prima il port-type:" + portType.getNome() + " e l'operation:" + operation.getNome() + ")");
            BindingStyle style = CostantiRegistroServizi.WSDL_STYLE_DOCUMENT;
            BindingUse use = CostantiRegistroServizi.WSDL_USE_LITERAL;
            String azione = operationName;
            try {
                if (portType.getStyle() != null && !"".equals(portType.getStyle()) && CostantiRegistroServizi.WSDL_STYLE_RPC.equals(portType.getStyle())) {
                    style = CostantiRegistroServizi.WSDL_STYLE_RPC;
                }
                if (operation.getStyle() != null && !"".equals(operation.getStyle())) {
                    if (CostantiRegistroServizi.WSDL_STYLE_RPC.equals(operation.getStyle())) {
                        style = CostantiRegistroServizi.WSDL_STYLE_RPC;
                    } else if (CostantiRegistroServizi.WSDL_STYLE_DOCUMENT.equals(operation.getStyle())) {
                        style = CostantiRegistroServizi.WSDL_STYLE_DOCUMENT;
                    }
                }
            }
            catch (Exception e) {
                errorMsgValidazioneXSD.append("Validazione fallita durante il riconoscimento del wsdl style rpc/document: " + e.getMessage());
                this.logger.error("Validazione fallita durante il riconoscimento del wsdl style rpc/document: " + e.getMessage(), (Throwable)e);
            }
            try {
                if (isRichiesta) {
                    if (operation.getMessageInput() != null && operation.getMessageInput().getUse() != null && !"".equals(operation.getMessageInput().getUse()) && CostantiRegistroServizi.WSDL_USE_ENCODED.equals(operation.getMessageInput().getUse())) {
                        use = CostantiRegistroServizi.WSDL_USE_ENCODED;
                    }
                } else if (operation.getMessageOutput() != null && operation.getMessageOutput().getUse() != null && !"".equals(operation.getMessageOutput().getUse()) && CostantiRegistroServizi.WSDL_USE_ENCODED.equals(operation.getMessageOutput().getUse())) {
                    use = CostantiRegistroServizi.WSDL_USE_ENCODED;
                }
            }
            catch (Exception e) {
                errorMsgValidazioneXSD.append("Validazione fallita durante il riconoscimento del wsdl use literal/encoded: " + e.getMessage());
                this.logger.error("Validazione fallita durante il riconoscimento del wsdl style literal/encoded: " + e.getMessage(), (Throwable)e);
            }
            if (errorMsgValidazioneXSD.length() == 0) {
                this.logger.debug("Validazione XSD con style[" + style + "] e use[" + use + "]...");
                NodeList nl = this.body.getChildNodes();
                if (CostantiRegistroServizi.WSDL_STYLE_RPC.equals(style)) {
                    int children = 0;
                    for (int i = 0; i < nl.getLength(); ++i) {
                        if (nl.item(i) instanceof Text || nl.item(i) instanceof Comment) continue;
                        ++children;
                    }
                    if (children > 1) {
                        errorMsgValidazioneXSD.append("Operation [" + azione + "] (style RPC) con piu' di un root element nel contenuto applicativo");
                    }
                }
                if (errorMsgValidazioneXSD.length() == 0) {
                    for (int i = 0; i < nl.getLength(); ++i) {
                        if (nl.item(i) instanceof Text || nl.item(i) instanceof Comment) continue;
                        Object nomeElemento = null;
                        String namespaceElemento = null;
                        Node n = null;
                        Node nodo = null;
                        Node nChild = null;
                        try {
                            n = nl.item(i);
                            nomeElemento = n.getLocalName();
                            namespaceElemento = n.getNamespaceURI();
                            if (CostantiRegistroServizi.WSDL_USE_ENCODED.equals(use)) {
                                this.logger.debug("Validazione XSD con style[" + style + "] e use[" + use + "], richiede la pulizia dei xsi:types prima della validazione...");
                                nodo = this.cleanXSITypes(n);
                            } else {
                                nodo = n;
                            }
                            if (CostantiRegistroServizi.WSDL_STYLE_RPC.equals(style)) {
                                this.logger.debug("Validazione XSD con style[" + style + "] e use[" + use + "] RPC Validation...");
                                Object nomeAtteso = azione;
                                if (!isRichiesta) {
                                    nomeAtteso = azione + "Response";
                                }
                                if (!((String)nomeAtteso).equals(nomeElemento)) {
                                    throw new Exception("Root element [" + (String)nomeElemento + "] non equivale all'operation name " + (String)nomeAtteso + " (RPC Style)");
                                }
                                NodeList nlChilds = nodo.getChildNodes();
                                this.logger.debug("Valido figli size: " + nlChilds.getLength());
                                for (int j = 0; j < nlChilds.getLength(); ++j) {
                                    if (nlChilds.item(j) instanceof Text || nlChilds.item(j) instanceof Comment) continue;
                                    nChild = nlChilds.item(j);
                                    this.openspcoop2Message.addNamespaceXSITypeIfNotExists(nChild, (Node)this.envelope);
                                    validatoreBodyApplicativo.valida(nChild, true);
                                }
                                continue;
                            }
                            this.logger.debug("Validazione XSD con style[" + style + "] e use[" + use + "] Document Validation...");
                            this.openspcoop2Message.addNamespaceXSITypeIfNotExists(nodo, (Node)this.envelope);
                            validatoreBodyApplicativo.valida(nodo, true);
                            continue;
                        }
                        catch (Exception e) {
                            if (errorMsgValidazioneXSD.length() == 0) {
                                errorMsgValidazioneXSD.append("Riscontrata non conformit\u00e0 rispetto agli schemi XSD\n");
                            } else {
                                errorMsgValidazioneXSD.append("\n");
                            }
                            if (namespaceElemento != null) {
                                nomeElemento = "{" + namespaceElemento + "}" + (String)nomeElemento;
                            }
                            errorMsgValidazioneXSD.append("(elemento " + (String)nomeElemento + "): " + e.getMessage());
                            String elementNonValidato = null;
                            try {
                                elementNonValidato = this.xmlUtils.toString(n);
                            }
                            catch (Exception eString) {
                                this.logger.error("Errore durante la conversione del Node in String: " + eString.getMessage(), (Throwable)eString);
                            }
                            String elementNonValidato_cleanXSIType = null;
                            try {
                                elementNonValidato_cleanXSIType = this.xmlUtils.toString(nodo);
                            }
                            catch (Exception eString) {
                                this.logger.error("Errore durante la conversione del Node (clean xsiType) in String: " + eString.getMessage(), (Throwable)eString);
                            }
                            String elementNonValidato_child = null;
                            try {
                                if (nChild != null) {
                                    elementNonValidato_child = this.xmlUtils.toString(nChild);
                                }
                            }
                            catch (Exception eString) {
                                this.logger.error("Errore durante la conversione del Node (clean xsiType) in String: " + eString.getMessage(), (Throwable)eString);
                            }
                            this.logger.error("Validazione fallita (elemento " + (String)nomeElemento + ") originale[" + elementNonValidato + "] cleanXsiType[" + elementNonValidato_cleanXSIType + "] nChild[" + elementNonValidato_child + "]: " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
        if (errorMsgValidazioneXSD.length() > 0) {
            throw new WSDLValidatorException(errorMsgValidazioneXSD.toString());
        }
    }

    public PortType getPtWsdlConformanceCheck() {
        return this.ptWsdlConformanceCheck;
    }

    public Operation getOpWsdlConformanceCheck() {
        return this.opWsdlConformanceCheck;
    }

    public void wsdlConformanceCheck(boolean isRichiesta, String soapAction, String operationName, boolean throwSOAPActionException, boolean logErrorAsDebug) throws WSDLValidatorException {
        String portType = this.accordoServizioWrapper.getNomePortType();
        if (portType != null) {
            if (operationName == null) {
                throw new WSDLValidatorException("operationName non definita");
            }
            this.logger.info("WSDL, effettuo validazione wsdlConformanceCheck ottimale sia con port type che operation ...");
            this._engineWsdlConformanceCheck(isRichiesta, soapAction, portType, operationName, throwSOAPActionException, logErrorAsDebug);
            this.ptWsdlConformanceCheck = this.accordoServizioWrapper.getPortType(portType);
            for (int i = 0; i < this.ptWsdlConformanceCheck.sizeAzioneList(); ++i) {
                Operation operationAS = this.ptWsdlConformanceCheck.getAzione(i);
                if (!operationAS.getNome().equals(operationName)) continue;
                this.opWsdlConformanceCheck = operationAS;
                break;
            }
        } else {
            if (operationName != null) {
                this.logger.info("WSDL, effettuo validazione wsdlConformanceCheck cercando una qualche operation con nome [" + operationName + "]...");
                StringBuffer bfEccezione = new StringBuffer();
                boolean operationFound = this._engineWsdlConformanceCheckAll(isRichiesta, soapAction, operationName, bfEccezione, throwSOAPActionException, logErrorAsDebug);
                if (operationFound) {
                    if (bfEccezione.length() > 0) {
                        throw new WSDLValidatorException(bfEccezione.toString());
                    }
                    return;
                }
                try {
                    IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
                    String uriAccordo = idAccordoFactory.getUriFromIDAccordo(this.accordoServizioWrapper.getIdAccordoServizio());
                    if (this.accordoServizioWrapper.isPortTypesLoadedFromWSDL()) {
                        throw new WSDLValidatorException("Operation [" + operationName + "] non trovata in alcun port-type esistente nei wsdl registrati all'interno dell'accordo di servizio " + uriAccordo);
                    }
                    throw new WSDLValidatorException("Azione [" + operationName + "] non trovata in alcun Servizio esistente nell'accordo di servizio " + uriAccordo);
                }
                catch (DriverRegistroServiziException de) {
                    String msgErrore = "Errore durante la registrazione del messaggio di errore Operation [" + operationName + "] non trovata in alcun port-type esistente nei wsdl registrati all'interno dell'accordo di servizio";
                    if (logErrorAsDebug) {
                        this.logger.debug(msgErrore);
                    } else {
                        this.logger.error(msgErrore, (Throwable)de);
                    }
                    if (this.accordoServizioWrapper.isPortTypesLoadedFromWSDL()) {
                        throw new WSDLValidatorException("Operation [" + operationName + "] non trovata in alcun port-type esistente nei wsdl registrati all'interno dell'accordo di servizio");
                    }
                    throw new WSDLValidatorException("Azione [" + operationName + "] non trovata in alcun Servizio esistente nell'accordo di servizio");
                }
            }
            StringBuffer bfEccezione = new StringBuffer();
            this.logger.info("WSDL, effettuo validazione wsdlConformanceCheck utilizzando una qualunque operation ...");
            this._engineWsdlConformanceCheckAll(isRichiesta, soapAction, null, bfEccezione, throwSOAPActionException, logErrorAsDebug);
            if (bfEccezione.length() > 0) {
                throw new WSDLValidatorException(bfEccezione.toString());
            }
            return;
        }
    }

    private boolean _engineWsdlConformanceCheckAll(boolean isRichiesta, String soapAction, String operationName, StringBuffer bfEccezione, boolean throwSOAPActionException, boolean logErrorAsDebug) throws WSDLValidatorException {
        try {
            IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
            String uriAccordo = idAccordoFactory.getUriFromIDAccordo(this.accordoServizioWrapper.getIdAccordoServizio());
            PortType[] pts = this.accordoServizioWrapper.getPortTypeList();
            if (pts == null || pts.length <= 0) {
                if (this.accordoServizioWrapper.isPortTypesLoadedFromWSDL()) {
                    throw new WSDLValidatorException("Port-Types non esistenti nei wsdl registrati all'interno dell'accordo di servizio " + uriAccordo);
                }
                throw new WSDLValidatorException("Servizi non esistenti nell'accordo di servizio " + uriAccordo);
            }
            boolean operationFound = false;
            for (int i = 0; i < pts.length; ++i) {
                PortType pt = pts[i];
                List<Operation> ops = pt.getAzioneList();
                if (ops == null || ops.size() <= 0) {
                    if (this.accordoServizioWrapper.isPortTypesLoadedFromWSDL()) {
                        throw new WSDLValidatorException("Operations non esistenti nel Port-Type [" + pt.getNome() + "] nei wsdl registrati all'interno dell'accordo di servizio " + uriAccordo);
                    }
                    throw new WSDLValidatorException("Azioni non esistenti nel Servizio [" + pt.getNome() + "] dell'accordo di servizio " + uriAccordo);
                }
                boolean validazioneCompletataConSuccesso = false;
                for (Operation operation : ops) {
                    boolean verify = false;
                    if (operationName == null) {
                        verify = true;
                    } else {
                        verify = operation.getNome().equals(operationName);
                        if (verify) {
                            operationFound = true;
                        }
                    }
                    if (!verify) continue;
                    try {
                        this.logger.info("WSDL, effettuo validazione wsdlConformanceCheck per operation [" + operation.getNome() + "] del port type [" + pt.getNome() + "]...");
                        this._engineWsdlConformanceCheck(isRichiesta, soapAction, pt.getNome(), operation.getNome(), throwSOAPActionException, logErrorAsDebug);
                        this.ptWsdlConformanceCheck = pt;
                        this.opWsdlConformanceCheck = operation;
                        validazioneCompletataConSuccesso = true;
                        break;
                    }
                    catch (WSDLValidatorException exception) {
                        bfEccezione.append("\n");
                        bfEccezione.append("[Tentativo validazione come PortType:").append(pt.getNome()).append(" Operation:").append(operation.getNome()).append(" fallito]: ").append(exception.getMessage());
                    }
                }
                if (validazioneCompletataConSuccesso) break;
            }
            return operationFound;
        }
        catch (WSDLValidatorException e) {
            throw e;
        }
        catch (Exception e) {
            String msgErrore = "Validazione WSDL (" + isRichiesta + ") fallita: " + e.getMessage();
            if (logErrorAsDebug) {
                this.logger.debug(msgErrore);
            } else {
                this.logger.error(msgErrore, (Throwable)e);
            }
            throw new WSDLValidatorException("Validazione WSDL 'all' (" + isRichiesta + ") fallita: " + e.getMessage(), e);
        }
    }

    private void _engineWsdlConformanceCheck(boolean isRichiesta, String soapAction, String portType, String operation, boolean throwSOAPActionException, boolean logErrorAsDebug) throws WSDLValidatorException {
        String errorMsgValidazioneXSD = null;
        try {
            BindingStyle style = CostantiRegistroServizi.WSDL_STYLE_DOCUMENT;
            BindingUse use = CostantiRegistroServizi.WSDL_USE_LITERAL;
            String namespaceRPC = null;
            Node rpcElement = null;
            IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
            String uriAccordo = idAccordoFactory.getUriFromIDAccordo(this.accordoServizioWrapper.getIdAccordoServizio());
            PortType portTypeAS = this.accordoServizioWrapper.getPortType(portType);
            if (portTypeAS == null) {
                if (this.accordoServizioWrapper.isPortTypesLoadedFromWSDL()) {
                    throw new WSDLValidatorException("Port-Type [" + portType + "] non esistente nei wsdl registrati all'interno dell'accordo di servizio " + uriAccordo);
                }
                throw new WSDLValidatorException("Servizio [" + portType + "] non esistente nell'accordo di servizio " + uriAccordo);
            }
            if (portTypeAS.getStyle() != null && !"".equals(portTypeAS.getStyle()) && CostantiRegistroServizi.WSDL_STYLE_RPC.equals(portTypeAS.getStyle())) {
                style = CostantiRegistroServizi.WSDL_STYLE_RPC;
            }
            if (portTypeAS.sizeAzioneList() <= 0) {
                throw new Exception("operations per il port type [" + portType + "] non presenti");
            }
            boolean matchingNameOperation = false;
            boolean matchingArgomentsOperation = false;
            String soapActionWSDL = null;
            StringBuffer eccezioni = new StringBuffer();
            StringBuffer eccezioneActionMatch = new StringBuffer();
            for (int i = 0; i < portTypeAS.sizeAzioneList(); ++i) {
                int wsdlIndex;
                Message argumentsOperation;
                Operation operationAS = portTypeAS.getAzione(i);
                if (!operationAS.getNome().equals(operation)) continue;
                matchingNameOperation = true;
                Message message = argumentsOperation = isRichiesta ? operationAS.getMessageInput() : operationAS.getMessageOutput();
                if (operationAS.getStyle() != null && !"".equals(operationAS.getStyle())) {
                    if (CostantiRegistroServizi.WSDL_STYLE_RPC.equals(operationAS.getStyle())) {
                        style = CostantiRegistroServizi.WSDL_STYLE_RPC;
                    } else if (CostantiRegistroServizi.WSDL_STYLE_DOCUMENT.equals(operationAS.getStyle())) {
                        style = CostantiRegistroServizi.WSDL_STYLE_DOCUMENT;
                    }
                }
                if (argumentsOperation != null && argumentsOperation.getUse() != null && !"".equals(argumentsOperation.getUse()) && CostantiRegistroServizi.WSDL_USE_ENCODED.equals(argumentsOperation.getUse())) {
                    use = CostantiRegistroServizi.WSDL_USE_ENCODED;
                }
                if (CostantiRegistroServizi.WSDL_STYLE_RPC.equals(style) && argumentsOperation != null && argumentsOperation.getSoapNamespace() != null && !"".equals(argumentsOperation.getSoapNamespace())) {
                    namespaceRPC = argumentsOperation.getSoapNamespace();
                }
                this.logger.debug("WSDL, esamino operation[" + operation + "] con style[" + style + "] e use[" + use + "] (RPCNamespace:" + namespaceRPC + ") ...");
                NodeList nodiContenutoApplicativo = null;
                Object nodoPossiedeContenutoApplicativo = null;
                if (CostantiRegistroServizi.WSDL_STYLE_RPC.equals(style)) {
                    SOAPElement childRPCElement;
                    Object nomeAtteso = operation;
                    if (!isRichiesta) {
                        nomeAtteso = operation + "Response";
                    }
                    if ((childRPCElement = SoapUtils.getNotEmptyFirstChildSOAPElement((SOAPElement)this.body)) == null) {
                        this.logger.debug("WSDL, esamino operation[" + operation + "] con style[" + style + "] e use[" + use + "]: Root element RCP non trovato rispetto all'operation name " + (String)nomeAtteso + " (RPC Style)");
                        continue;
                    }
                    if (!((String)nomeAtteso).equals(childRPCElement.getLocalName())) {
                        this.logger.debug("WSDL, esamino operation[" + operation + "] con style[" + style + "] e use[" + use + "]: Root element [" + childRPCElement.getLocalName() + "] non equivale all'operation name " + (String)nomeAtteso + " (RPC Style)");
                        continue;
                    }
                    nodiContenutoApplicativo = this.body.getChildNodes();
                    for (int ii = 0; ii < nodiContenutoApplicativo.getLength(); ++ii) {
                        if (nodiContenutoApplicativo.item(ii) instanceof Text || nodiContenutoApplicativo.item(ii) instanceof Comment) continue;
                        nodoPossiedeContenutoApplicativo = nodiContenutoApplicativo.item(ii);
                        rpcElement = nodoPossiedeContenutoApplicativo;
                        nodiContenutoApplicativo = nodoPossiedeContenutoApplicativo.getChildNodes();
                        break;
                    }
                } else {
                    nodiContenutoApplicativo = this.body.getChildNodes();
                    nodoPossiedeContenutoApplicativo = this.body;
                }
                int sizeArgumentsOperation = 0;
                if (argumentsOperation != null) {
                    sizeArgumentsOperation = argumentsOperation.sizePartList();
                }
                int nodiContenutoApplicativoLength = 0;
                StringBuffer nodiMessaggioErrore = new StringBuffer();
                for (int ii = 0; ii < nodiContenutoApplicativo.getLength(); ++ii) {
                    if (nodiContenutoApplicativo.item(ii) instanceof Text || nodiContenutoApplicativo.item(ii) instanceof Comment) continue;
                    if (nodiMessaggioErrore.length() > 0) {
                        nodiMessaggioErrore.append(", ");
                    }
                    Node n = nodiContenutoApplicativo.item(ii);
                    RootElementBody rootElementBody = new RootElementBody(this.envelope, (Node)nodoPossiedeContenutoApplicativo, CostantiRegistroServizi.WSDL_STYLE_RPC.equals(style), n);
                    nodiMessaggioErrore.append(rootElementBody.toString());
                    ++nodiContenutoApplicativoLength;
                }
                if (sizeArgumentsOperation != nodiContenutoApplicativoLength) {
                    if (eccezioneActionMatch.length() > 0) {
                        eccezioneActionMatch.append("\n");
                    }
                    eccezioneActionMatch.append("Parametri trovati (size:" + nodiContenutoApplicativoLength + "): ");
                    eccezioneActionMatch.append(nodiMessaggioErrore.toString());
                    this.logger.debug("WSDL, esamino operation[" + operation + "] con style[" + style + "] e use[" + use + "]: Argomenti attesi[" + sizeArgumentsOperation + "], trovati nel body[" + nodiContenutoApplicativo.getLength() + "]");
                    continue;
                }
                String tipo = "output";
                if (isRichiesta) {
                    tipo = "input";
                }
                if (argumentsOperation == null || argumentsOperation.sizePartList() <= 0) continue;
                Vector<RootElementBody> elementRootBody = new Vector<RootElementBody>();
                StringBuffer bodyElements = new StringBuffer();
                int numeroBodyElements = 0;
                int realIndexBody = 0;
                for (int indexBody = 0; indexBody < nodiContenutoApplicativo.getLength(); ++indexBody) {
                    if (nodiContenutoApplicativo.item(indexBody) instanceof Text || nodiContenutoApplicativo.item(indexBody) instanceof Comment) continue;
                    Node n = nodiContenutoApplicativo.item(indexBody);
                    RootElementBody rootElementBody = new RootElementBody(this.envelope, (Node)nodoPossiedeContenutoApplicativo, CostantiRegistroServizi.WSDL_STYLE_RPC.equals(style), n);
                    elementRootBody.add(rootElementBody);
                    if (realIndexBody > 0) {
                        bodyElements.append(",");
                    }
                    ++realIndexBody;
                    bodyElements.append(rootElementBody.toString());
                }
                numeroBodyElements = elementRootBody.size();
                int soapBodyArguments = nodiContenutoApplicativoLength;
                for (wsdlIndex = 0; wsdlIndex < argumentsOperation.sizePartList(); ++wsdlIndex) {
                    SOAPElement rpcOperation;
                    if (wsdlIndex == soapBodyArguments) {
                        this.logger.debug("WSDL, esamino operation[" + operation + "] con style[" + style + "] e use[" + use + "]: Pi\u00f9 oggetti definiti nel WSDL di quanti ce ne siano nel messaggio");
                        continue;
                    }
                    MessagePart argument = argumentsOperation.getPart(wsdlIndex);
                    String nomeElementAtteso = null;
                    String namespaceElementAtteso = null;
                    String tipoXSIAtteso = null;
                    boolean validazioneTipologiaElement = argument.getElementName() != null;
                    String argomentoAtteso = null;
                    if (argument.getElementName() != null) {
                        nomeElementAtteso = argument.getElementName();
                        namespaceElementAtteso = argument.getElementNamespace();
                    } else {
                        nomeElementAtteso = argument.getName();
                        namespaceElementAtteso = argument.getTypeNamespace();
                        tipoXSIAtteso = argument.getTypeName();
                    }
                    argomentoAtteso = RootElementBody.toString(nomeElementAtteso, namespaceElementAtteso, tipoXSIAtteso);
                    boolean find = false;
                    for (int indexBody = 0; indexBody < elementRootBody.size(); ++indexBody) {
                        RootElementBody r = (RootElementBody)elementRootBody.get(indexBody);
                        if (validazioneTipologiaElement) {
                            if (nomeElementAtteso.equals(r.getLocalName()) && namespaceElementAtteso.equals(r.getNamespace())) {
                                find = true;
                                elementRootBody.remove(indexBody);
                                continue;
                            }
                            if (!CostantiRegistroServizi.WSDL_USE_ENCODED.equals(use) || !nomeElementAtteso.equals(r.getLocalName()) || !namespaceElementAtteso.equals(r.getNamespaceElementoCheContieneXSIType())) continue;
                            find = true;
                            elementRootBody.remove(indexBody);
                            continue;
                        }
                        if (!nomeElementAtteso.equals(r.getLocalName()) || !namespaceElementAtteso.equals(r.getNamespace()) || !tipoXSIAtteso.equals(r.getXsiType())) continue;
                        find = true;
                        elementRootBody.remove(indexBody);
                    }
                    if (find) continue;
                    boolean error = true;
                    if (CostantiRegistroServizi.WSDL_STYLE_RPC.equals(style) && CostantiRegistroServizi.WSDL_USE_LITERAL.equals(use) && tipoXSIAtteso != null && elementRootBody.size() == 1 && argumentsOperation.sizePartList() == 1 && (rpcOperation = SoapUtils.getNotEmptyFirstChildSOAPElement((SOAPElement)this.body)) != null) {
                        SOAPElement childRpc = SoapUtils.getNotEmptyFirstChildSOAPElement(rpcOperation);
                        if (this.gestioneXsiType_rpcLiteral && childRpc != null && nomeElementAtteso != null && nomeElementAtteso.equals(childRpc.getLocalName())) {
                            try {
                                QName namespaceId = new QName("xmlns:op2RPC");
                                childRpc.addAttribute(namespaceId, namespaceElementAtteso);
                                this.rpcChildElementNamespaceAggiunto = namespaceId;
                                QName id = new QName(XMLSCHEMA_INSTANCE_NAMESPACE, XMLSCHEMA_INSTANCE_LOCAL_NAME_TYPE, "xsi");
                                String value = "op2RPC:" + tipoXSIAtteso;
                                childRpc.addAttribute(id, value);
                                this.rpcChildElementXSITypeAggiunto = id;
                                error = false;
                                this.rpcChildElement = childRpc;
                            }
                            catch (Exception e) {
                                this.logger.error("Errore durante la registrazione degli attributi richiesti per la validazione rpc con type: " + e.getMessage(), (Throwable)e);
                                try {
                                    if (this.rpcChildElementNamespaceAggiunto != null) {
                                        this.rpcChildElement.removeAttribute(this.rpcChildElementNamespaceAggiunto);
                                        this.rpcChildElement.removeNamespaceDeclaration(PREFIX_RPC_AGGIUNTO);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (!error) continue;
                    eccezioni.append("\nParametro di " + tipo + " '" + argomentoAtteso + "' richiesto nel wsdl ma non trovato nei root-element (" + numeroBodyElements + ") presenti nel body: " + bodyElements);
                    this.logger.debug("WSDL, esamino operation[" + operation + "] con style[" + style + "] e use[" + use + "]: Atteso " + argomentoAtteso + " body " + bodyElements);
                    break;
                }
                if (wsdlIndex != soapBodyArguments) continue;
                soapActionWSDL = operationAS.getSoapAction();
                matchingArgomentsOperation = true;
            }
            if (!matchingArgomentsOperation) {
                if (matchingNameOperation) {
                    if (eccezioni.length() > 0) {
                        if (this.accordoServizioWrapper.isPortTypesLoadedFromWSDL()) {
                            throw new WSDLValidatorException("Messaggio con elementi non conformi alla definizione wsdl dell'Operation [" + operation + "] del port-type [" + portType + "] (AccordoServizio:" + uriAccordo + " style:" + style + " use:" + use + "): " + eccezioni.toString());
                        }
                        throw new WSDLValidatorException("Messaggio con elementi non conformi alla definizione wsdl dell'Azione [" + operation + "] del Servizio [" + portType + "] (AccordoServizio:" + uriAccordo + " style:" + style + " use:" + use + "): " + eccezioni.toString());
                    }
                    if (eccezioneActionMatch.length() > 0) {
                        StringBuffer bfMessage = new StringBuffer();
                        for (int i = 0; i < portTypeAS.sizeAzioneList(); ++i) {
                            Operation operationAS = portTypeAS.getAzione(i);
                            if (!operationAS.getNome().equals(operation)) continue;
                            Message argumentsOperation = isRichiesta ? operationAS.getMessageInput() : operationAS.getMessageOutput();
                            int length = 0;
                            if (argumentsOperation != null && argumentsOperation.getPartList() != null) {
                                length = argumentsOperation.getPartList().size();
                            }
                            bfMessage.append("\n");
                            bfMessage.append("Parametri attesi (size:" + length + "): ");
                            if (length <= 0) continue;
                            for (int j = 0; j < length; ++j) {
                                MessagePart argument = argumentsOperation.getPart(j);
                                String nomeElementAtteso = null;
                                String namespaceElementAtteso = null;
                                String tipoXSIAtteso = null;
                                String argomentoAtteso = null;
                                if (argument.getElementName() != null) {
                                    nomeElementAtteso = argument.getElementName();
                                    namespaceElementAtteso = argument.getElementNamespace();
                                } else {
                                    nomeElementAtteso = argument.getName();
                                    namespaceElementAtteso = argument.getTypeNamespace();
                                    tipoXSIAtteso = argument.getTypeName();
                                }
                                argomentoAtteso = RootElementBody.toString(nomeElementAtteso, namespaceElementAtteso, tipoXSIAtteso);
                                if (j > 0) {
                                    bfMessage.append(", ");
                                }
                                bfMessage.append(argomentoAtteso);
                            }
                        }
                        bfMessage.append("\n").append(eccezioneActionMatch.toString());
                        if (this.accordoServizioWrapper.isPortTypesLoadedFromWSDL()) {
                            throw new WSDLValidatorException("Messaggio con elementi non conformi alla definizione wsdl dell'Operation [" + operation + "] del port-type [" + portType + "] (AccordoServizio:" + uriAccordo + " style:" + style + " use:" + use + "): " + bfMessage.toString());
                        }
                        throw new WSDLValidatorException("Messaggio con elementi non conformi alla definizione wsdl dell'Azione [" + operation + "] del Servizio [" + portType + "] (AccordoServizio:" + uriAccordo + " style:" + style + " use:" + use + "): " + bfMessage.toString());
                    }
                    if (this.accordoServizioWrapper.isPortTypesLoadedFromWSDL()) {
                        throw new WSDLValidatorException("Messaggio con elementi non conformi alla definizione wsdl dell'Operation [" + operation + "] del port-type [" + portType + "] (AccordoServizio:" + uriAccordo + " style:" + style + " use:" + use + ")");
                    }
                    throw new WSDLValidatorException("Messaggio con elementi non conformi alla definizione wsdl dell'Azione [" + operation + "] del Servizio [" + portType + "] (AccordoServizio:" + uriAccordo + " style:" + style + " use:" + use + ")");
                }
                if (this.accordoServizioWrapper.isPortTypesLoadedFromWSDL()) {
                    throw new WSDLValidatorException("Operation [" + operation + "] del port-type [" + portType + "] non esistente nei wsdl registrati all'interno dell'accordo di servizio " + uriAccordo);
                }
                throw new WSDLValidatorException("Azione [" + operation + "] del Servizio [" + portType + "] non esistente nell'accordo di servizio " + uriAccordo);
            }
            if (isRichiesta && soapActionWSDL != null) {
                this.logger.debug("CheckSOAPAction");
                String soapActionRipulita = null;
                if (soapAction != null) {
                    soapActionRipulita = soapAction.trim();
                    if (soapActionRipulita.startsWith("\"")) {
                        soapActionRipulita = soapActionRipulita.substring(1);
                    }
                    if (soapActionRipulita.endsWith("\"")) {
                        soapActionRipulita = soapActionRipulita.substring(0, soapActionRipulita.length() - 1);
                    }
                }
                if (!soapActionWSDL.equalsIgnoreCase(soapActionRipulita)) {
                    boolean tmpThrowSOAPActionException = throwSOAPActionException;
                    if (soapActionRipulita == null && SOAPVersion.SOAP12.equals((Object)this.soapVersion)) {
                        tmpThrowSOAPActionException = false;
                    }
                    if (tmpThrowSOAPActionException) {
                        throw new WSDLValidatorException("Operazione [" + operation + "] del port-type [" + portType + "] con soap action [" + soapActionRipulita + "] che non rispetta quella indicata nel wsdl: " + soapActionWSDL);
                    }
                }
            }
            if (namespaceRPC != null && rpcElement != null) {
                this.logger.debug("CheckRPCNamespace");
                if (rpcElement.getNamespaceURI() == null) {
                    throw new WSDLValidatorException("Operazione [" + operation + "] del port-type [" + portType + "] possiede un rpc element non conforme a quanto dichiarato nel wsdl: non qualificato tramite namespace");
                }
                if (!rpcElement.getNamespaceURI().equals(namespaceRPC)) {
                    throw new WSDLValidatorException("Operazione [" + operation + "] del port-type [" + portType + "] possiede un rpc element non conforme a quanto dichiarato nel wsdl: trovato[" + rpcElement.getNamespaceURI() + "] atteso[" + namespaceRPC + "]");
                }
            }
        }
        catch (Exception e) {
            String msgErrore = "Validazione WSDL (" + isRichiesta + ") fallita: " + e.getMessage();
            if (logErrorAsDebug) {
                this.logger.debug(msgErrore);
            } else {
                this.logger.error(msgErrore, (Throwable)e);
            }
            if (!(e instanceof WSDLValidatorException)) {
                this.logger.debug("Validazione WSDL fallita", (Throwable)e);
            }
            errorMsgValidazioneXSD = "Riscontrata non conformit\u00e0 rispetto all'interfaccia WSDL; " + e.getMessage();
        }
        if (errorMsgValidazioneXSD != null) {
            throw new WSDLValidatorException(errorMsgValidazioneXSD);
        }
    }

    public Element cleanXSITypes(Node node) throws Exception {
        byte[] element = this.eraserType(this.xmlUtils.toByteArray(node, true));
        Document doc = this.xmlUtils.newDocument(element);
        Element domElem = doc.getDocumentElement();
        return domElem;
    }

    public byte[] eraserType(byte[] xml) throws UtilsException {
        ByteArrayOutputStream cleanXML = null;
        String prefix = "";
        try {
            int k;
            int contatoreFineAttributo;
            cleanXML = new ByteArrayOutputStream();
            int i = 0;
            while (i < xml.length) {
                if (xml[i] == 32) {
                    String importXSITYPE = XMLSCHEMA_INSTANCE_NAMESPACE;
                    if (i + "xmlns:".length() < xml.length && xml[i + 1] == 120 && xml[i + 2] == 109 && xml[i + 3] == 108 && xml[i + 4] == 110 && xml[i + 5] == 115 && xml[i + 6] == 58) {
                        StringBuffer test = new StringBuffer("xmlns:");
                        StringBuffer prefixTest = new StringBuffer();
                        contatoreFineAttributo = 0;
                        k = 7;
                        while (i + k < xml.length) {
                            if ((char)xml[i + k] == '\"') {
                                ++contatoreFineAttributo;
                            }
                            if (contatoreFineAttributo == 0) {
                                prefixTest.append((char)xml[i + k]);
                            }
                            test.append((char)xml[i + k]);
                            if (contatoreFineAttributo >= 2) break;
                            ++k;
                        }
                        int indexFirst = test.toString().indexOf(34);
                        int secondFirst = test.toString().indexOf(34, indexFirst + 1);
                        String testEquals = test.toString().substring(indexFirst + 1, secondFirst);
                        if (importXSITYPE.equalsIgnoreCase(testEquals)) {
                            prefix = prefixTest.toString().substring(0, prefixTest.length() - 1);
                            i = i + test.toString().length() + 1;
                            continue;
                        }
                    }
                    cleanXML.write(xml[i]);
                    ++i;
                    continue;
                }
                cleanXML.write(xml[i]);
                ++i;
            }
            byte[] risultato = cleanXML.toByteArray();
            cleanXML = new ByteArrayOutputStream();
            cleanXML.close();
            int i2 = 0;
            while (i2 < risultato.length) {
                if (risultato[i2] == 32) {
                    String XSITYPE_PREFIX = prefix + ":type=\"";
                    if (i2 + XSITYPE_PREFIX.length() + 2 < risultato.length) {
                        StringBuffer test = new StringBuffer("");
                        contatoreFineAttributo = 0;
                        k = 1;
                        while (i2 + k < risultato.length) {
                            if ((char)risultato[i2 + k] == '\"') {
                                ++contatoreFineAttributo;
                            }
                            test.append((char)risultato[i2 + k]);
                            if (contatoreFineAttributo >= 2) break;
                            ++k;
                        }
                        if (test.toString().startsWith(XSITYPE_PREFIX)) {
                            i2 = i2 + test.toString().length() + 1;
                            continue;
                        }
                    }
                    cleanXML.write(risultato[i2]);
                    ++i2;
                    continue;
                }
                cleanXML.write(risultato[i2]);
                ++i2;
            }
            risultato = cleanXML.toByteArray();
            cleanXML.close();
            return risultato;
        }
        catch (Exception e) {
            this.logger.error("Utilities.eraserType", (Throwable)e);
            try {
                if (cleanXML != null) {
                    cleanXML.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("Eliminazione xsi:type per validazione non riuscita " + e.getMessage(), e);
        }
    }
}

